/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.generation.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.FolderUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.generation.Activator;
import org.eclipse.gmt.modisco.java.generation.utils.Messages;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public final class JavaUtils {
    private static CodeFormatter sourceFormatter = null;

    private JavaUtils() {
    }

    public static void formatJavaCode(File directory) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                JavaUtils.formatJavaCode(file);
            } else if (file.getName().endsWith(".java")) {
                String source = FolderUtils.getFileContent((File)file);
                String target = JavaUtils.formatJavaCode(source);
                try {
                    FileWriter fw = new FileWriter(file, false);
                    fw.write(target);
                    fw.close();
                }
                catch (IOException e) {
                    if (Platform.isRunning()) {
                        MoDiscoLogger.logWarning((Throwable)e, (String)(String.valueOf(Messages.JavaUtils_1) + file.getAbsoluteFile()), (Plugin)Activator.getDefault());
                    }
                    System.err.println(String.valueOf(Messages.JavaUtils_2) + file.getAbsoluteFile());
                }
            }
            ++n2;
        }
    }

    private static String formatJavaCode(String source) {
        CodeFormatter formatter = JavaUtils.getDefaultFormatter();
        Document document = new Document(source);
        TextEdit textEdit = formatter.format(8, source, 0, source.length(), 0, "\n");
        if (textEdit != null) {
            try {
                textEdit.apply((IDocument)document);
                return document.get();
            }
            catch (Exception e) {
                if (Platform.isRunning()) {
                    MoDiscoLogger.logWarning((Throwable)e, (String)Messages.JavaUtils_4, (Plugin)Activator.getDefault());
                }
                System.err.println(String.valueOf(Messages.JavaUtils_5) + e.getMessage());
            }
        } else {
            MoDiscoLogger.logWarning((String)Messages.JavaUtils_4, (Plugin)Activator.getDefault());
        }
        return source;
    }

    private static CodeFormatter getDefaultFormatter() {
        if (sourceFormatter == null) {
            Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            options.put("org.eclipse.jdt.core.compiler.source", "1.5");
            sourceFormatter = ToolFactory.createCodeFormatter((Map)options);
        }
        return sourceFormatter;
    }
}

