/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.kdm.browser.extension.build;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.gmt.modisco.kdm.browser.extension.Activator;
import org.eclipse.gmt.modisco.omg.kdm.build.*;

/**
 * @generated
 */
public class IconProvider implements org.eclipse.gmt.modisco.infra.browser.uicore.extensions.icons.IconProvider {
//	Start of user code Image attribute for BuildDescription		
	private Image BuildDescriptionImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BuildComponent		
	private Image BuildComponentImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Library		
	private Image LibraryImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BuildStep		
	private Image BuildStepImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BuildProduct		
	private Image BuildProductImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BuildResource		
	private Image BuildResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for SymbolicLink		
	private Image SymbolicLinkImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for LinksTo		
	private Image LinksToImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Consumes		
	private Image ConsumesImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BuildModel		
	private Image BuildModelImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Supplier		
	private Image SupplierImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Tool		
	private Image ToolImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BuildElement		
	private Image BuildElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BuildRelationship		
	private Image BuildRelationshipImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for SuppliedBy		
	private Image SuppliedByImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Produces		
	private Image ProducesImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for SupportedBy		
	private Image SupportedByImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DescribedBy		
	private Image DescribedByImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractBuildElement		
	private Image AbstractBuildElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractBuildRelationship		
	private Image AbstractBuildRelationshipImage = this.createImage("");
//	End of user code
	

	/**
	 * @generated
	 */	
	public IconProvider() {
	}

	/**
	 * @return the icon that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default icon, which can be empty, or let another {@link IconProvider}
	 *         provide the icon
	 * @generated
	 */
	public Image getIcon(EObject eObject) {
    Image result = null;
    if (eObject instanceof BuildDescription) {
      result = this.BuildDescriptionImage;
    } else
    if (eObject instanceof BuildComponent) {
      result = this.BuildComponentImage;
    } else
    if (eObject instanceof Library) {
      result = this.LibraryImage;
    } else
    if (eObject instanceof BuildStep) {
      result = this.BuildStepImage;
    } else
    if (eObject instanceof BuildProduct) {
      result = this.BuildProductImage;
    } else
    if (eObject instanceof BuildResource) {
      result = this.BuildResourceImage;
    } else
    if (eObject instanceof SymbolicLink) {
      result = this.SymbolicLinkImage;
    } else
    if (eObject instanceof LinksTo) {
      result = this.LinksToImage;
    } else
    if (eObject instanceof Consumes) {
      result = this.ConsumesImage;
    } else
    if (eObject instanceof BuildModel) {
      result = this.BuildModelImage;
    } else
    if (eObject instanceof Supplier) {
      result = this.SupplierImage;
    } else
    if (eObject instanceof Tool) {
      result = this.ToolImage;
    } else
    if (eObject instanceof BuildElement) {
      result = this.BuildElementImage;
    } else
    if (eObject instanceof BuildRelationship) {
      result = this.BuildRelationshipImage;
    } else
    if (eObject instanceof SuppliedBy) {
      result = this.SuppliedByImage;
    } else
    if (eObject instanceof Produces) {
      result = this.ProducesImage;
    } else
    if (eObject instanceof SupportedBy) {
      result = this.SupportedByImage;
    } else
    if (eObject instanceof DescribedBy) {
      result = this.DescribedByImage;
    } else
    if (eObject instanceof AbstractBuildElement) {
      result = this.AbstractBuildElementImage;
    } else
    if (eObject instanceof AbstractBuildRelationship) {
      result = this.AbstractBuildRelationshipImage;
    } 

    return result;

  }

	/**
	 * Create an image from a resource in the bundle (plugin)
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image
	 * @generated
	 */
	private Image createImage(String resourcePath) {
    Image result = null;
    if ((resourcePath != null) && (resourcePath.length() > 0)) {
      ImageDescriptor descriptor = Activator.getImageDescriptor("icons/kdm/build/" + resourcePath);
      if (descriptor != null) {
        result = descriptor.createImage();
      }
    }
    return result;
  }

}

