/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.kdm.browser.extension.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.gmt.modisco.kdm.browser.extension.Activator;
import org.eclipse.gmt.modisco.omg.kdm.ui.*;

/**
 * @generated
 */
public class IconProvider implements org.eclipse.gmt.modisco.infra.browser.uicore.extensions.icons.IconProvider {
//	Start of user code Image attribute for Screen		
	private Image ScreenImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Report		
	private Image ReportImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIDisplay		
	private Image UIDisplayImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIField		
	private Image UIFieldImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIResource		
	private Image UIResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIModel		
	private Image UIModelImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UILayout		
	private Image UILayoutImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DisplaysImage		
	private Image DisplaysImageImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Displays		
	private Image DisplaysImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIFlow		
	private Image UIFlowImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIElement		
	private Image UIElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIRelationship		
	private Image UIRelationshipImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIAction		
	private Image UIActionImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for UIEvent		
	private Image UIEventImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ReadsUI		
	private Image ReadsUIImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for WritesUI		
	private Image WritesUIImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ManagesUI		
	private Image ManagesUIImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractUIElement		
	private Image AbstractUIElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractUIRelationship		
	private Image AbstractUIRelationshipImage = this.createImage("");
//	End of user code
	

	/**
	 * @generated
	 */	
	public IconProvider() {
	}

	/**
	 * @return the icon that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default icon, which can be empty, or let another {@link IconProvider}
	 *         provide the icon
	 * @generated
	 */
	public Image getIcon(EObject eObject) {
    Image result = null;
    if (eObject instanceof Screen) {
      result = this.ScreenImage;
    } else
    if (eObject instanceof Report) {
      result = this.ReportImage;
    } else
    if (eObject instanceof UIDisplay) {
      result = this.UIDisplayImage;
    } else
    if (eObject instanceof UIField) {
      result = this.UIFieldImage;
    } else
    if (eObject instanceof UIResource) {
      result = this.UIResourceImage;
    } else
    if (eObject instanceof UIModel) {
      result = this.UIModelImage;
    } else
    if (eObject instanceof UILayout) {
      result = this.UILayoutImage;
    } else
    if (eObject instanceof DisplaysImage) {
      result = this.DisplaysImageImage;
    } else
    if (eObject instanceof Displays) {
      result = this.DisplaysImage;
    } else
    if (eObject instanceof UIFlow) {
      result = this.UIFlowImage;
    } else
    if (eObject instanceof UIElement) {
      result = this.UIElementImage;
    } else
    if (eObject instanceof UIRelationship) {
      result = this.UIRelationshipImage;
    } else
    if (eObject instanceof UIAction) {
      result = this.UIActionImage;
    } else
    if (eObject instanceof UIEvent) {
      result = this.UIEventImage;
    } else
    if (eObject instanceof ReadsUI) {
      result = this.ReadsUIImage;
    } else
    if (eObject instanceof WritesUI) {
      result = this.WritesUIImage;
    } else
    if (eObject instanceof ManagesUI) {
      result = this.ManagesUIImage;
    } else
    if (eObject instanceof AbstractUIElement) {
      result = this.AbstractUIElementImage;
    } else
    if (eObject instanceof AbstractUIRelationship) {
      result = this.AbstractUIRelationshipImage;
    } 

    return result;

  }

	/**
	 * Create an image from a resource in the bundle (plugin)
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image
	 * @generated
	 */
	private Image createImage(String resourcePath) {
    Image result = null;
    if ((resourcePath != null) && (resourcePath.length() > 0)) {
      ImageDescriptor descriptor = Activator.getImageDescriptor("icons/kdm/ui/" + resourcePath);
      if (descriptor != null) {
        result = descriptor.createImage();
      }
    }
    return result;
  }

}

