/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.jet.execution;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.AbstractDriverExecution;
import org.eclipse.gmt.modisco.workflow.driver.jet.Activator;
import org.eclipse.gmt.modisco.workflow.driver.jet.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;
import org.eclipse.jet.internal.launch.JET2TransformationDelegate;

@SuppressWarnings("restriction")
public class TransformationExecute extends AbstractDriverExecution {

	@Override
	public void launch(final ILaunchConfigurationWorkingCopy configuration,
			final ILaunch launch) {
		try {
			JET2TransformationDelegate delegate = new JET2TransformationDelegate();
			delegate.launch(configuration, ILaunchManager.RUN_MODE, launch,
					new NullProgressMonitor());
		} catch (CoreException e) {
			MoDiscoLogger.logError(e, Messages.TransformationExecute_0,
					Activator.getDefault());
		}
	}

	@Override
	public void launch(final Work work) {
		ILaunchConfigurationType type = DebugPlugin.getDefault()
				.getLaunchManager().getLaunchConfigurationType(
						Constant.typeLaunchConfiguration);
		ILaunchConfiguration launchConfiguration = null;
		try {
			launchConfiguration = type.newInstance(null, DebugPlugin
					.getDefault().getLaunchManager()
					.generateLaunchConfigurationName("tmp")); //$NON-NLS-1$
			ILaunchConfigurationWorkingCopy copy = launchConfiguration
					.getWorkingCopy();
			workToLaunchWorkingCopy(work, copy);
			copy.launch(ILaunchManager.RUN_MODE, new NullProgressMonitor());
		} catch (CoreException e) {
			MoDiscoLogger.logError(e, Activator.getDefault());
		}

	}
}
