/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.ui.Messages;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDriversPage
extends WizardPage {
    private Table driversTable;
    private ControllerDriverPage controller;
    private Composite container;
    private HashMap<TableItem, DriverInterface> mapItemDriver;

    protected ListDriversPage(String pageName, ControllerDriverPage controller) {
        super(pageName, pageName, null);
        this.setImageDescriptor(Activator.getImageDescriptor("icon/bigModiscoWorkflow.png"));
        this.controller = controller;
        this.setDescription(Messages.ListDriversPage_0);
        this.mapItemDriver = new HashMap();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.driversTable = new Table(this.container, 2560);
        this.driversTable.setLayoutData((Object)gridData);
        this.driversTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListDriversPage.this.getController().refreshDriverPage(ListDriversPage.this.getMapItemDriver().get(ListDriversPage.this.getDriversTable().getItem(ListDriversPage.this.getDriversTable().getSelectionIndex())).getTypeLaunchConfig());
                ListDriversPage.this.setErrorMessage(null);
                ListDriversPage.this.setMessage(Messages.ListDriversPage_1);
                ListDriversPage.this.setPageComplete(true);
            }
        });
        this.loadDriver();
        this.setControl((Control)this.container);
        this.container.layout();
    }

    private void loadDriver() {
        boolean oneDriver = false;
        for (Map.Entry<String, DriverInterface> entry : this.controller.getMapNameDriver().entrySet()) {
            TableItem item = new TableItem(this.driversTable, 0);
            item.setText(entry.getKey());
            item.setImage(Common.getInstance().retrieveImageDriver(entry.getValue().getTypeLaunchConfig()));
            oneDriver = true;
            this.mapItemDriver.put(item, entry.getValue());
        }
        if (oneDriver) {
            this.setErrorMessage(Messages.ListDriversPage_2);
        } else {
            this.setErrorMessage(Messages.ListDriversPage_3);
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getShell().setSize(400, 400);
            this.getShell().setLocation(Common.getInstance().centerShell(Display.getDefault(), this.getShell()));
        }
        super.setVisible(visible);
    }

    public void setController(ControllerDriverPage controller) {
        this.controller = controller;
    }

    public ControllerDriverPage getController() {
        return this.controller;
    }

    public void setMapItemDriver(HashMap<TableItem, DriverInterface> mapItemDriver) {
        this.mapItemDriver = mapItemDriver;
    }

    public HashMap<TableItem, DriverInterface> getMapItemDriver() {
        return this.mapItemDriver;
    }

    public void setDriversTable(Table driversTable) {
        this.driversTable = driversTable;
    }

    public Table getDriversTable() {
        return this.driversTable;
    }
}

