/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.xml.discoverer.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.xml.discoverer.XmlActivator;
import org.eclipse.gmt.modisco.xml.discoverer.actions.Messages;
import org.eclipse.gmt.modisco.xml.resource.GenericXMLResourceFactoryImpl;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLModelDiscoverer
implements Discoverer {
    private static Resource.Factory modiscoResourceFactory = new GenericXMLResourceFactoryImpl();
    private static List<DiscoveryParameter> parametersKeys = null;
    private Resource resourceResult = null;
    public static final DiscoveryParameter PARAMETER_SILENT_MODE = new DiscoveryParameterImpl("OPTION_SILENT_MODE", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_IGNORE_WHITESPACES = new DiscoveryParameterImpl("OPTION_IGNORE_WHITESPACES", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_LIGHTWEIGHT_MODEL = new DiscoveryParameterImpl("OPTION_IGNORE_WHITESPACES", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_SERIALIZE_XMI = new DiscoveryParameterImpl("OPTION_SERIALIZE_XMI", DiscoveryParameterDirectionKind.in, Boolean.class, false);
    public static final DiscoveryParameter PARAMETER_TARGET_RESOURCE = new DiscoveryParameterImpl("TARGET_RESOURCE", DiscoveryParameterDirectionKind.out, Resource.class, false);

    public final boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IFile && ((IFile)source).exists()) {
            try {
                IContentType candidateType;
                IContentType xmlContentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
                result = ((IFile)source).getContentDescription() != null ? ((candidateType = ((IFile)source).getContentDescription().getContentType()) != null ? candidateType.isKindOf(xmlContentType) : true) : true;
            }
            catch (CoreException e) {
                Status warning = new Status(2, "org.eclipse.gmt.modisco.xml.discoverer", "Could not test xml nature for file " + source.toString(), (Throwable)e);
                XmlActivator.getDefault().getLog().log((IStatus)warning);
            }
        }
        return result;
    }

    public final Resource discoverElement(Object source, URI target) {
        HashMap<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
        parameters.put(PARAMETER_SILENT_MODE, false);
        parameters.put(PARAMETER_IGNORE_WHITESPACES, false);
        parameters.put(PARAMETER_LIGHTWEIGHT_MODEL, false);
        parameters.put(PARAMETER_SERIALIZE_XMI, false);
        this.discoverElement(source, parameters);
        return (Resource)parameters.get(PARAMETER_TARGET_RESOURCE);
    }

    public final void discoverElement(final Object source, final Map<DiscoveryParameter, Object> parameters) {
        boolean isSilent = false;
        if (parameters != null && parameters.get(PARAMETER_SILENT_MODE) != null) {
            isSilent = (Boolean)parameters.get(PARAMETER_SILENT_MODE);
        }
        final boolean serializeXMI = parameters != null && parameters.get(PARAMETER_SERIALIZE_XMI) != null ? (Boolean)parameters.get(PARAMETER_SERIALIZE_XMI) : false;
        this.setResourceResult(null);
        Job job = new Job(Messages.XMLModelDiscoverer_4){

            protected IStatus run(IProgressMonitor monitor) {
                Status result = null;
                monitor.beginTask(Messages.XMLModelDiscoverer_5, -1);
                try {
                    String absolutePath = null;
                    URI sourceURI = null;
                    if (source instanceof IFile) {
                        absolutePath = ((IFile)source).getFullPath().toString();
                        sourceURI = URI.createURI((String)absolutePath);
                    } else if (source instanceof File) {
                        absolutePath = ((File)source).getAbsolutePath();
                        sourceURI = URI.createFileURI((String)absolutePath);
                    }
                    Resource resource = XMLModelDiscoverer.getModiscoResourceFactory().createResource(sourceURI);
                    resource.load(parameters);
                    if (monitor.isCanceled()) {
                        Status status = result = Status.CANCEL_STATUS;
                        return status;
                    }
                    try {
                        result = Status.OK_STATUS;
                        XMLModelDiscoverer.this.setResourceResult(resource);
                        if (serializeXMI) {
                            XMLModelDiscoverer.this.saveResource(monitor, sourceURI, resource);
                        }
                    }
                    catch (IOException e) {
                        result = new Status(4, "org.eclipse.gmt.modisco.xml.discoverer", "An error occured during model discovering from " + source.toString(), (Throwable)e);
                        XmlActivator.getDefault().getLog().log((IStatus)result);
                    }
                }
                finally {
                    monitor.done();
                }
                return result;
            }
        };
        if (!isSilent) {
            this.scheduleEditorOpening(source, job);
        }
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.xml.discoverer", e.getMessage(), (Throwable)e);
            XmlActivator.getDefault().getLog().log((IStatus)status);
        }
        if (parameters != null) {
            parameters.put(PARAMETER_TARGET_RESOURCE, this.getResourceResult());
        }
    }

    private void scheduleEditorOpening(final Object source, Job job) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob().getResult().isOK()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                IEditorDescriptor editDesc;
                                String fileExtension = ((IFile)source).getFullPath().getFileExtension();
                                Object factoryBak = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(fileExtension);
                                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(fileExtension, XMLModelDiscoverer.getModiscoResourceFactory());
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IEditorPart existingEditorOnResource = page.findEditor((IEditorInput)new FileEditorInput((IFile)source));
                                if (existingEditorOnResource != null) {
                                    page.closeEditor(existingEditorOnResource, true);
                                }
                                if ((editDesc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.gmt.modisco.infra.browser.editorID")) != null) {
                                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)source), (String)editDesc.getId());
                                } else {
                                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)source));
                                }
                                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(fileExtension, factoryBak);
                            }
                            catch (PartInitException e) {
                                Status status = new Status(4, "org.eclipse.gmt.modisco.xml.discoverer", e.getMessage(), (Throwable)e);
                                XmlActivator.getDefault().getLog().log((IStatus)status);
                            }
                        }
                    });
                }
            }
        });
    }

    public final List<DiscoveryParameter> getDiscovererParameters() {
        if (parametersKeys == null) {
            parametersKeys = new ArrayList<DiscoveryParameter>();
            parametersKeys.add(PARAMETER_SILENT_MODE);
            parametersKeys.add(PARAMETER_TARGET_RESOURCE);
            parametersKeys.add(PARAMETER_IGNORE_WHITESPACES);
            parametersKeys.add(PARAMETER_LIGHTWEIGHT_MODEL);
            parametersKeys.add(PARAMETER_SERIALIZE_XMI);
        }
        return parametersKeys;
    }

    protected void saveResource(IProgressMonitor monitor, URI sourceURI, Resource resource) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.setURI(sourceURI.appendFileExtension("xmi"));
        monitor.subTask(Messages.XMLModelDiscoverer_1);
        resource.save(options);
    }

    public void setResourceResult(Resource aResourceResult) {
        this.resourceResult = aResourceResult;
    }

    public Resource getResourceResult() {
        return this.resourceResult;
    }

    public static void setModiscoResourceFactory(Resource.Factory aModiscoResourceFactory) {
        modiscoResourceFactory = aModiscoResourceFactory;
    }

    public static Resource.Factory getModiscoResourceFactory() {
        return modiscoResourceFactory;
    }
}

