/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Grgoire Dup (Mia-Software) - initial API and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl;

import java.util.Date;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.ReportmodelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getDicoveryDate <em>Dicovery Date</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getAlgoVariante <em>Algo Variante</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getDiscovererClassName <em>Discoverer Class Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getSaveTime <em>Save Time</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getTotalExecutionTime <em>Total Execution Time</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getMetaModelVariante <em>Meta Model Variante</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl#getMaxUsedMemory <em>Max Used Memory</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConfigurationImpl extends EObjectImpl implements Configuration {
	/**
	 * The default value of the '{@link #getDicoveryDate() <em>Dicovery Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDicoveryDate()
	 * @generated
	 * @ordered
	 */
	protected static final Date DICOVERY_DATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDicoveryDate() <em>Dicovery Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDicoveryDate()
	 * @generated
	 * @ordered
	 */
	protected Date dicoveryDate = DICOVERY_DATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAlgoVariante() <em>Algo Variante</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAlgoVariante()
	 * @generated
	 * @ordered
	 */
	protected static final String ALGO_VARIANTE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAlgoVariante() <em>Algo Variante</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAlgoVariante()
	 * @generated
	 * @ordered
	 */
	protected String algoVariante = ALGO_VARIANTE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDiscovererClassName() <em>Discoverer Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscovererClassName()
	 * @generated
	 * @ordered
	 */
	protected static final String DISCOVERER_CLASS_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDiscovererClassName() <em>Discoverer Class Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDiscovererClassName()
	 * @generated
	 * @ordered
	 */
	protected String discovererClassName = DISCOVERER_CLASS_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getSaveTime() <em>Save Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSaveTime()
	 * @generated
	 * @ordered
	 */
	protected static final double SAVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getSaveTime() <em>Save Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSaveTime()
	 * @generated
	 * @ordered
	 */
	protected double saveTime = SAVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalExecutionTime() <em>Total Execution Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalExecutionTime()
	 * @generated
	 * @ordered
	 */
	protected static final double TOTAL_EXECUTION_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTotalExecutionTime() <em>Total Execution Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalExecutionTime()
	 * @generated
	 * @ordered
	 */
	protected double totalExecutionTime = TOTAL_EXECUTION_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getMetaModelVariante() <em>Meta Model Variante</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetaModelVariante()
	 * @generated
	 * @ordered
	 */
	protected static final String META_MODEL_VARIANTE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMetaModelVariante() <em>Meta Model Variante</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetaModelVariante()
	 * @generated
	 * @ordered
	 */
	protected String metaModelVariante = META_MODEL_VARIANTE_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaxUsedMemory() <em>Max Used Memory</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxUsedMemory()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_USED_MEMORY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaxUsedMemory() <em>Max Used Memory</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxUsedMemory()
	 * @generated
	 * @ordered
	 */
	protected int maxUsedMemory = MAX_USED_MEMORY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ReportmodelPackage.Literals.CONFIGURATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Date getDicoveryDate() {
		return dicoveryDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDicoveryDate(Date newDicoveryDate) {
		Date oldDicoveryDate = dicoveryDate;
		dicoveryDate = newDicoveryDate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__DICOVERY_DATE, oldDicoveryDate, dicoveryDate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAlgoVariante() {
		return algoVariante;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAlgoVariante(String newAlgoVariante) {
		String oldAlgoVariante = algoVariante;
		algoVariante = newAlgoVariante;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__ALGO_VARIANTE, oldAlgoVariante, algoVariante));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDiscovererClassName() {
		return discovererClassName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDiscovererClassName(String newDiscovererClassName) {
		String oldDiscovererClassName = discovererClassName;
		discovererClassName = newDiscovererClassName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__DISCOVERER_CLASS_NAME, oldDiscovererClassName, discovererClassName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getSaveTime() {
		return saveTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSaveTime(double newSaveTime) {
		double oldSaveTime = saveTime;
		saveTime = newSaveTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__SAVE_TIME, oldSaveTime, saveTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTotalExecutionTime() {
		return totalExecutionTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalExecutionTime(double newTotalExecutionTime) {
		double oldTotalExecutionTime = totalExecutionTime;
		totalExecutionTime = newTotalExecutionTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__TOTAL_EXECUTION_TIME, oldTotalExecutionTime, totalExecutionTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMetaModelVariante() {
		return metaModelVariante;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMetaModelVariante(String newMetaModelVariante) {
		String oldMetaModelVariante = metaModelVariante;
		metaModelVariante = newMetaModelVariante;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__META_MODEL_VARIANTE, oldMetaModelVariante, metaModelVariante));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaxUsedMemory() {
		return maxUsedMemory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxUsedMemory(int newMaxUsedMemory) {
		int oldMaxUsedMemory = maxUsedMemory;
		maxUsedMemory = newMaxUsedMemory;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.CONFIGURATION__MAX_USED_MEMORY, oldMaxUsedMemory, maxUsedMemory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ReportmodelPackage.CONFIGURATION__DICOVERY_DATE:
				return getDicoveryDate();
			case ReportmodelPackage.CONFIGURATION__ALGO_VARIANTE:
				return getAlgoVariante();
			case ReportmodelPackage.CONFIGURATION__DISCOVERER_CLASS_NAME:
				return getDiscovererClassName();
			case ReportmodelPackage.CONFIGURATION__SAVE_TIME:
				return getSaveTime();
			case ReportmodelPackage.CONFIGURATION__TOTAL_EXECUTION_TIME:
				return getTotalExecutionTime();
			case ReportmodelPackage.CONFIGURATION__META_MODEL_VARIANTE:
				return getMetaModelVariante();
			case ReportmodelPackage.CONFIGURATION__NAME:
				return getName();
			case ReportmodelPackage.CONFIGURATION__MAX_USED_MEMORY:
				return getMaxUsedMemory();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ReportmodelPackage.CONFIGURATION__DICOVERY_DATE:
				setDicoveryDate((Date)newValue);
				return;
			case ReportmodelPackage.CONFIGURATION__ALGO_VARIANTE:
				setAlgoVariante((String)newValue);
				return;
			case ReportmodelPackage.CONFIGURATION__DISCOVERER_CLASS_NAME:
				setDiscovererClassName((String)newValue);
				return;
			case ReportmodelPackage.CONFIGURATION__SAVE_TIME:
				setSaveTime((Double)newValue);
				return;
			case ReportmodelPackage.CONFIGURATION__TOTAL_EXECUTION_TIME:
				setTotalExecutionTime((Double)newValue);
				return;
			case ReportmodelPackage.CONFIGURATION__META_MODEL_VARIANTE:
				setMetaModelVariante((String)newValue);
				return;
			case ReportmodelPackage.CONFIGURATION__NAME:
				setName((String)newValue);
				return;
			case ReportmodelPackage.CONFIGURATION__MAX_USED_MEMORY:
				setMaxUsedMemory((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ReportmodelPackage.CONFIGURATION__DICOVERY_DATE:
				setDicoveryDate(DICOVERY_DATE_EDEFAULT);
				return;
			case ReportmodelPackage.CONFIGURATION__ALGO_VARIANTE:
				setAlgoVariante(ALGO_VARIANTE_EDEFAULT);
				return;
			case ReportmodelPackage.CONFIGURATION__DISCOVERER_CLASS_NAME:
				setDiscovererClassName(DISCOVERER_CLASS_NAME_EDEFAULT);
				return;
			case ReportmodelPackage.CONFIGURATION__SAVE_TIME:
				setSaveTime(SAVE_TIME_EDEFAULT);
				return;
			case ReportmodelPackage.CONFIGURATION__TOTAL_EXECUTION_TIME:
				setTotalExecutionTime(TOTAL_EXECUTION_TIME_EDEFAULT);
				return;
			case ReportmodelPackage.CONFIGURATION__META_MODEL_VARIANTE:
				setMetaModelVariante(META_MODEL_VARIANTE_EDEFAULT);
				return;
			case ReportmodelPackage.CONFIGURATION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ReportmodelPackage.CONFIGURATION__MAX_USED_MEMORY:
				setMaxUsedMemory(MAX_USED_MEMORY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ReportmodelPackage.CONFIGURATION__DICOVERY_DATE:
				return DICOVERY_DATE_EDEFAULT == null ? dicoveryDate != null : !DICOVERY_DATE_EDEFAULT.equals(dicoveryDate);
			case ReportmodelPackage.CONFIGURATION__ALGO_VARIANTE:
				return ALGO_VARIANTE_EDEFAULT == null ? algoVariante != null : !ALGO_VARIANTE_EDEFAULT.equals(algoVariante);
			case ReportmodelPackage.CONFIGURATION__DISCOVERER_CLASS_NAME:
				return DISCOVERER_CLASS_NAME_EDEFAULT == null ? discovererClassName != null : !DISCOVERER_CLASS_NAME_EDEFAULT.equals(discovererClassName);
			case ReportmodelPackage.CONFIGURATION__SAVE_TIME:
				return saveTime != SAVE_TIME_EDEFAULT;
			case ReportmodelPackage.CONFIGURATION__TOTAL_EXECUTION_TIME:
				return totalExecutionTime != TOTAL_EXECUTION_TIME_EDEFAULT;
			case ReportmodelPackage.CONFIGURATION__META_MODEL_VARIANTE:
				return META_MODEL_VARIANTE_EDEFAULT == null ? metaModelVariante != null : !META_MODEL_VARIANTE_EDEFAULT.equals(metaModelVariante);
			case ReportmodelPackage.CONFIGURATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ReportmodelPackage.CONFIGURATION__MAX_USED_MEMORY:
				return maxUsedMemory != MAX_USED_MEMORY_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (dicoveryDate: "); //$NON-NLS-1$
		result.append(dicoveryDate);
		result.append(", algoVariante: "); //$NON-NLS-1$
		result.append(algoVariante);
		result.append(", discovererClassName: "); //$NON-NLS-1$
		result.append(discovererClassName);
		result.append(", saveTime: "); //$NON-NLS-1$
		result.append(saveTime);
		result.append(", totalExecutionTime: "); //$NON-NLS-1$
		result.append(totalExecutionTime);
		result.append(", metaModelVariante: "); //$NON-NLS-1$
		result.append(metaModelVariante);
		result.append(", name: "); //$NON-NLS-1$
		result.append(name);
		result.append(", maxUsedMemory: "); //$NON-NLS-1$
		result.append(maxUsedMemory);
		result.append(')');
		return result.toString();
	}

} //ConfigurationImpl
