/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;

/**
 * 
 * @author Nicolas Payneau
 */
public class MoDiscoWorkflowTabGroup extends
		AbstractLaunchConfigurationTabGroup {
	private WorkflowTransformationTab wfTab;
	private MoDiscoExportTab export;
	private MoDiscoWorkflowCommonTab common;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.debug.ui.ILaunchConfigurationTabGroup#createTabs(org.eclipse
	 * .debug.ui.ILaunchConfigurationDialog, java.lang.String)
	 */
	public void createTabs(final ILaunchConfigurationDialog dialog, final String mode) {
		this.wfTab = new WorkflowTransformationTab();
		this.export = new MoDiscoExportTab();
		this.common = new MoDiscoWorkflowCommonTab();
		setTabs(new ILaunchConfigurationTab[] { this.wfTab, this.export,
				this.common });
	}

	@Override
	public void initializeFrom(final ILaunchConfiguration configuration) {
		this.common.initializeFrom(configuration);
		this.wfTab.setResourcePath(this.common.getResourcePath());
		this.wfTab.initializeFrom(configuration);
		DebugPlugin.getDefault().getLaunchManager()
				.addLaunchConfigurationListener(
						new ILaunchConfigurationListener() {
							public void launchConfigurationAdded(
									final ILaunchConfiguration configuration) {
							}

							public void launchConfigurationChanged(
									final ILaunchConfiguration configuration) {
							}

							public void launchConfigurationRemoved(
									final ILaunchConfiguration configuration) {
								String resourcePath = null;
								if (!configuration.isLocal()) {
									IPath path = configuration
											.getFile()
											.getLocation()
											.removeLastSegments(1)
											.append(configuration.getName())
											.addFileExtension(
													Constants.workflowExtension);
									resourcePath = path.toString();
								} else {
									resourcePath = Activator
											.getDefault()
											.getStateLocation()
											.append(configuration.getName())
											.addFileExtension(
													Constants.workflowExtension)
											.toString();
								}
								MoDiscoWorkflowTabGroup.this.getWfTab()
										.getController().removeResource(
												resourcePath);
							}
						});
		this.export.initializeFrom(configuration);
	}

	@Override
	public void performApply(final ILaunchConfigurationWorkingCopy configuration) {
		this.wfTab.getController().changeWorkflowEngine(configuration);
		super.performApply(configuration);
		this.wfTab.getController().saveWorkflowResource(configuration, false);
		this.wfTab.getController().moveWorkflowResource(
				this.common.getResourcePath());
		// For rename configuration
		if (!configuration.getOriginal().getName().equals(
				configuration.getName())) {
			String resourcePath = null;
			if (!configuration.isLocal()) {
				IPath path = configuration.getFile().getLocation()
						.removeLastSegments(1).append(configuration.getName())
						.addFileExtension(Constants.workflowExtension);
				resourcePath = path.toString();
			} else {
				resourcePath = Activator.getDefault().getStateLocation()
						.append(configuration.getName()).addFileExtension(
								Constants.workflowExtension).toString();
			}
			this.wfTab.getController().moveWorkflowResource(resourcePath);
		}
		Common.getInstance().refreshPackageExplorer();
	}

	public WorkflowTransformationTab getWfTab() {
		return this.wfTab;
	}
}
