/**
 * *******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 * *******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.java.nousages.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.ImportDeclaration;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.MethodRef;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.nousages.meta.JavaPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Method Declaration</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>
 * {@link org.eclipse.gmt.modisco.java.nousages.impl.MethodDeclarationImpl#getExtraArrayDimensions
 * <em>Extra Array Dimensions</em>}</li>
 * <li>
 * {@link org.eclipse.gmt.modisco.java.nousages.impl.MethodDeclarationImpl#getReturnType
 * <em>Return Type</em>}</li>
 * <li>
 * {@link org.eclipse.gmt.modisco.java.nousages.impl.MethodDeclarationImpl#getRedefinedMethodDeclaration
 * <em>Redefined Method Declaration</em>}</li>
 * <li>
 * {@link org.eclipse.gmt.modisco.java.nousages.impl.MethodDeclarationImpl#getRedefinitions
 * <em>Redefinitions</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class MethodDeclarationImpl extends AbstractMethodDeclarationImpl
		implements MethodDeclaration {
	/**
	 * The default value of the '{@link #getExtraArrayDimensions()
	 * <em>Extra Array Dimensions</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getExtraArrayDimensions()
	 * @generated
	 * @ordered
	 */
	protected static final int EXTRA_ARRAY_DIMENSIONS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getExtraArrayDimensions()
	 * <em>Extra Array Dimensions</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getExtraArrayDimensions()
	 * @generated
	 * @ordered
	 */
	protected int extraArrayDimensions = EXTRA_ARRAY_DIMENSIONS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getReturnType() <em>Return Type</em>}'
	 * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getReturnType()
	 * @generated
	 * @ordered
	 */
	protected TypeAccess returnType;

	/**
	 * The cached value of the '{@link #getRedefinedMethodDeclaration()
	 * <em>Redefined Method Declaration</em>}' reference. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @see #getRedefinedMethodDeclaration()
	 * @generated
	 * @ordered
	 */
	protected MethodDeclaration redefinedMethodDeclaration;

	/**
	 * The cached value of the '{@link #getRedefinitions()
	 * <em>Redefinitions</em>}' reference list. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #getRedefinitions()
	 * @generated
	 * @ordered
	 */
	protected EList<MethodDeclaration> redefinitions;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MethodDeclarationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return JavaPackage.eINSTANCE.getMethodDeclaration();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public int getExtraArrayDimensions() {
		return extraArrayDimensions;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setExtraArrayDimensions(int newExtraArrayDimensions) {
		int oldExtraArrayDimensions = extraArrayDimensions;
		extraArrayDimensions = newExtraArrayDimensions;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					JavaPackage.METHOD_DECLARATION__EXTRA_ARRAY_DIMENSIONS,
					oldExtraArrayDimensions, extraArrayDimensions));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public TypeAccess getReturnType() {
		return returnType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetReturnType(TypeAccess newReturnType,
			NotificationChain msgs) {
		TypeAccess oldReturnType = returnType;
		returnType = newReturnType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this,
					Notification.SET,
					JavaPackage.METHOD_DECLARATION__RETURN_TYPE, oldReturnType,
					newReturnType);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setReturnType(TypeAccess newReturnType) {
		if (newReturnType != returnType) {
			NotificationChain msgs = null;
			if (returnType != null)
				msgs = ((InternalEObject) returnType).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE
								- JavaPackage.METHOD_DECLARATION__RETURN_TYPE,
						null, msgs);
			if (newReturnType != null)
				msgs = ((InternalEObject) newReturnType).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE
								- JavaPackage.METHOD_DECLARATION__RETURN_TYPE,
						null, msgs);
			msgs = basicSetReturnType(newReturnType, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					JavaPackage.METHOD_DECLARATION__RETURN_TYPE, newReturnType,
					newReturnType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MethodDeclaration getRedefinedMethodDeclaration() {
		if (redefinedMethodDeclaration != null
				&& redefinedMethodDeclaration.eIsProxy()) {
			InternalEObject oldRedefinedMethodDeclaration = (InternalEObject) redefinedMethodDeclaration;
			redefinedMethodDeclaration = (MethodDeclaration) eResolveProxy(oldRedefinedMethodDeclaration);
			if (redefinedMethodDeclaration != oldRedefinedMethodDeclaration) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(
							this,
							Notification.RESOLVE,
							JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION,
							oldRedefinedMethodDeclaration,
							redefinedMethodDeclaration));
			}
		}
		return redefinedMethodDeclaration;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MethodDeclaration basicGetRedefinedMethodDeclaration() {
		return redefinedMethodDeclaration;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetRedefinedMethodDeclaration(
			MethodDeclaration newRedefinedMethodDeclaration,
			NotificationChain msgs) {
		MethodDeclaration oldRedefinedMethodDeclaration = redefinedMethodDeclaration;
		redefinedMethodDeclaration = newRedefinedMethodDeclaration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(
					this,
					Notification.SET,
					JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION,
					oldRedefinedMethodDeclaration,
					newRedefinedMethodDeclaration);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setRedefinedMethodDeclaration(
			MethodDeclaration newRedefinedMethodDeclaration) {
		if (newRedefinedMethodDeclaration != redefinedMethodDeclaration) {
			NotificationChain msgs = null;
			if (redefinedMethodDeclaration != null)
				msgs = ((InternalEObject) redefinedMethodDeclaration)
						.eInverseRemove(this,
								JavaPackage.METHOD_DECLARATION__REDEFINITIONS,
								MethodDeclaration.class, msgs);
			if (newRedefinedMethodDeclaration != null)
				msgs = ((InternalEObject) newRedefinedMethodDeclaration)
						.eInverseAdd(this,
								JavaPackage.METHOD_DECLARATION__REDEFINITIONS,
								MethodDeclaration.class, msgs);
			msgs = basicSetRedefinedMethodDeclaration(
					newRedefinedMethodDeclaration, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(
					this,
					Notification.SET,
					JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION,
					newRedefinedMethodDeclaration,
					newRedefinedMethodDeclaration));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<MethodDeclaration> getRedefinitions() {
		if (redefinitions == null) {
			redefinitions = new EObjectWithInverseResolvingEList<MethodDeclaration>(
					MethodDeclaration.class,
					this,
					JavaPackage.METHOD_DECLARATION__REDEFINITIONS,
					JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION);
		}
		return redefinitions;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION:
			if (redefinedMethodDeclaration != null)
				msgs = ((InternalEObject) redefinedMethodDeclaration)
						.eInverseRemove(this,
								JavaPackage.METHOD_DECLARATION__REDEFINITIONS,
								MethodDeclaration.class, msgs);
			return basicSetRedefinedMethodDeclaration(
					(MethodDeclaration) otherEnd, msgs);
		case JavaPackage.METHOD_DECLARATION__REDEFINITIONS:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getRedefinitions())
					.basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case JavaPackage.METHOD_DECLARATION__RETURN_TYPE:
			return basicSetReturnType(null, msgs);
		case JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION:
			return basicSetRedefinedMethodDeclaration(null, msgs);
		case JavaPackage.METHOD_DECLARATION__REDEFINITIONS:
			return ((InternalEList<?>) getRedefinitions()).basicRemove(
					otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case JavaPackage.METHOD_DECLARATION__EXTRA_ARRAY_DIMENSIONS:
			return getExtraArrayDimensions();
		case JavaPackage.METHOD_DECLARATION__RETURN_TYPE:
			return getReturnType();
		case JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION:
			if (resolve)
				return getRedefinedMethodDeclaration();
			return basicGetRedefinedMethodDeclaration();
		case JavaPackage.METHOD_DECLARATION__REDEFINITIONS:
			return getRedefinitions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case JavaPackage.METHOD_DECLARATION__EXTRA_ARRAY_DIMENSIONS:
			setExtraArrayDimensions((Integer) newValue);
			return;
		case JavaPackage.METHOD_DECLARATION__RETURN_TYPE:
			setReturnType((TypeAccess) newValue);
			return;
		case JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION:
			setRedefinedMethodDeclaration((MethodDeclaration) newValue);
			return;
		case JavaPackage.METHOD_DECLARATION__REDEFINITIONS:
			getRedefinitions().clear();
			getRedefinitions().addAll(
					(Collection<? extends MethodDeclaration>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case JavaPackage.METHOD_DECLARATION__EXTRA_ARRAY_DIMENSIONS:
			setExtraArrayDimensions(EXTRA_ARRAY_DIMENSIONS_EDEFAULT);
			return;
		case JavaPackage.METHOD_DECLARATION__RETURN_TYPE:
			setReturnType((TypeAccess) null);
			return;
		case JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION:
			setRedefinedMethodDeclaration((MethodDeclaration) null);
			return;
		case JavaPackage.METHOD_DECLARATION__REDEFINITIONS:
			getRedefinitions().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case JavaPackage.METHOD_DECLARATION__EXTRA_ARRAY_DIMENSIONS:
			return extraArrayDimensions != EXTRA_ARRAY_DIMENSIONS_EDEFAULT;
		case JavaPackage.METHOD_DECLARATION__RETURN_TYPE:
			return returnType != null;
		case JavaPackage.METHOD_DECLARATION__REDEFINED_METHOD_DECLARATION:
			return redefinedMethodDeclaration != null;
		case JavaPackage.METHOD_DECLARATION__REDEFINITIONS:
			return redefinitions != null && !redefinitions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (extraArrayDimensions: "); //$NON-NLS-1$
		result.append(extraArrayDimensions);
		result.append(')');
		return result.toString();
	}

	public EList<AbstractMethodInvocation> getUsages() {
		// no usage references
		return null;
	}

	public EList<MethodRef> getUsagesInDocComments() {
		// no usage references
		return null;
	}

	public EList<ImportDeclaration> getUsagesInImports() {
		// no usage references
		return null;
	}

} // MethodDeclarationImpl
