/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.queries.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.AbstractVariablesContainer;
import org.eclipse.gmt.modisco.java.Annotation;
import org.eclipse.gmt.modisco.java.ArrayAccess;
import org.eclipse.gmt.modisco.java.ArrayCreation;
import org.eclipse.gmt.modisco.java.ArrayInitializer;
import org.eclipse.gmt.modisco.java.ArrayLengthAccess;
import org.eclipse.gmt.modisco.java.Assignment;
import org.eclipse.gmt.modisco.java.BooleanLiteral;
import org.eclipse.gmt.modisco.java.CastExpression;
import org.eclipse.gmt.modisco.java.CharacterLiteral;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.ClassInstanceCreation;
import org.eclipse.gmt.modisco.java.ConditionalExpression;
import org.eclipse.gmt.modisco.java.ConstructorDeclaration;
import org.eclipse.gmt.modisco.java.FieldAccess;
import org.eclipse.gmt.modisco.java.InfixExpression;
import org.eclipse.gmt.modisco.java.InstanceofExpression;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.MethodInvocation;
import org.eclipse.gmt.modisco.java.NullLiteral;
import org.eclipse.gmt.modisco.java.NumberLiteral;
import org.eclipse.gmt.modisco.java.ParenthesizedExpression;
import org.eclipse.gmt.modisco.java.PostfixExpression;
import org.eclipse.gmt.modisco.java.PrefixExpression;
import org.eclipse.gmt.modisco.java.PrimitiveTypeBoolean;
import org.eclipse.gmt.modisco.java.PrimitiveTypeChar;
import org.eclipse.gmt.modisco.java.PrimitiveTypeDouble;
import org.eclipse.gmt.modisco.java.PrimitiveTypeFloat;
import org.eclipse.gmt.modisco.java.PrimitiveTypeInt;
import org.eclipse.gmt.modisco.java.SingleVariableAccess;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;
import org.eclipse.gmt.modisco.java.StringLiteral;
import org.eclipse.gmt.modisco.java.SuperFieldAccess;
import org.eclipse.gmt.modisco.java.SuperMethodInvocation;
import org.eclipse.gmt.modisco.java.ThisExpression;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.TypeLiteral;
import org.eclipse.gmt.modisco.java.UnresolvedItemAccess;
import org.eclipse.gmt.modisco.java.VariableDeclarationFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTypeRef
implements IJavaModelQuery<ASTNode, Type> {
    public Type evaluate(ASTNode context, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        Type result = null;
        if (context instanceof AbstractVariablesContainer) {
            AbstractVariablesContainer contextCasted = (AbstractVariablesContainer)context;
            result = this.getType(contextCasted);
        } else if (context instanceof Annotation) {
            Annotation contextCasted = (Annotation)context;
            result = this.getType(contextCasted);
        } else if (context instanceof ArrayAccess) {
            ArrayAccess contextCasted = (ArrayAccess)context;
            result = this.getType(contextCasted);
        } else if (context instanceof ArrayCreation) {
            ArrayCreation contextCasted = (ArrayCreation)context;
            result = this.getType(contextCasted);
        } else if (!(context instanceof ArrayInitializer)) {
            if (context instanceof ArrayLengthAccess) {
                ArrayLengthAccess contextCasted = (ArrayLengthAccess)context;
                result = this.getType(contextCasted);
            } else if (context instanceof Assignment) {
                Assignment contextCasted = (Assignment)context;
                result = this.getType(contextCasted);
            } else if (context instanceof BooleanLiteral) {
                BooleanLiteral contextCasted = (BooleanLiteral)context;
                result = this.getType(contextCasted);
            } else if (context instanceof CastExpression) {
                CastExpression contextCasted = (CastExpression)context;
                result = this.getType(contextCasted);
            } else if (context instanceof CharacterLiteral) {
                CharacterLiteral contextCasted = (CharacterLiteral)context;
                result = this.getType(contextCasted);
            } else if (context instanceof ClassInstanceCreation) {
                ClassInstanceCreation contextCasted = (ClassInstanceCreation)context;
                result = this.getType(contextCasted);
            } else if (!(context instanceof ConditionalExpression) && !(context instanceof InfixExpression)) {
                if (context instanceof InstanceofExpression) {
                    InstanceofExpression contextCasted = (InstanceofExpression)context;
                    result = this.getType(contextCasted);
                } else if (context instanceof FieldAccess) {
                    FieldAccess contextCasted = (FieldAccess)context;
                    result = this.getType(contextCasted);
                } else if (context instanceof MethodInvocation) {
                    MethodInvocation contextCasted = (MethodInvocation)context;
                    result = this.getType(contextCasted);
                } else if (context instanceof NumberLiteral) {
                    NumberLiteral contextCasted = (NumberLiteral)context;
                    result = this.getType(contextCasted);
                } else if (!(context instanceof NullLiteral)) {
                    if (context instanceof ParenthesizedExpression) {
                        ParenthesizedExpression contextCasted = (ParenthesizedExpression)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof PostfixExpression) {
                        PostfixExpression contextCasted = (PostfixExpression)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof PrefixExpression) {
                        PrefixExpression contextCasted = (PrefixExpression)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof SingleVariableAccess) {
                        SingleVariableAccess contextCasted = (SingleVariableAccess)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof SuperFieldAccess) {
                        SuperFieldAccess contextCasted = (SuperFieldAccess)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof StringLiteral) {
                        StringLiteral contextCasted = (StringLiteral)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof SuperMethodInvocation) {
                        SuperMethodInvocation contextCasted = (SuperMethodInvocation)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof ThisExpression) {
                        ThisExpression contextCasted = (ThisExpression)context;
                        result = this.getType(contextCasted);
                    } else if (context instanceof TypeAccess) {
                        TypeAccess contextCasted = (TypeAccess)context;
                        if (contextCasted.getType() != null) {
                            result = contextCasted.getType();
                        }
                    } else if (context instanceof TypeLiteral) {
                        TypeLiteral contextCasted = (TypeLiteral)context;
                        result = this.getType(contextCasted);
                    } else if (!(context instanceof UnresolvedItemAccess)) {
                        throw new ModelQueryExecutionException("Unexpected context type: " + context.getClass().getSimpleName() + " expected: AbstractVariablesContainer or Expression in " + this.getClass().getSimpleName());
                    }
                }
            }
        }
        return result;
    }

    private Type getType(AbstractVariablesContainer contextCasted) {
        Type result = null;
        if (contextCasted.getType() != null) {
            result = contextCasted.getType().getType();
        }
        return result;
    }

    private Type getType(Annotation contextCasted) {
        Type result = null;
        if (contextCasted.getType() != null) {
            result = contextCasted.getType().getType();
        }
        return result;
    }

    private Type getType(ArrayAccess contextCasted) throws ModelQueryExecutionException {
        Type result = null;
        if (contextCasted.getArray() != null) {
            result = this.evaluate((ASTNode)contextCasted.getArray(), null);
        }
        return result;
    }

    private Type getType(ArrayCreation contextCasted) {
        Type result = null;
        if (contextCasted.getType() != null) {
            result = contextCasted.getType().getType();
        }
        return result;
    }

    private Type getType(ArrayLengthAccess contextCasted) {
        Type result = null;
        List<PrimitiveTypeInt> candidates = this.retrieveType(contextCasted.eResource(), "int", PrimitiveTypeInt.class);
        if (!candidates.isEmpty()) {
            result = (Type)candidates.get(0);
        }
        return result;
    }

    private Type getType(Assignment contextCasted) throws ModelQueryExecutionException {
        Type result = null;
        if (contextCasted.getRightHandSide() != null) {
            result = this.evaluate((ASTNode)contextCasted.getRightHandSide(), null);
        }
        return result;
    }

    private Type getType(BooleanLiteral contextCasted) {
        Type result = null;
        List<PrimitiveTypeBoolean> candidates = this.retrieveType(contextCasted.eResource(), "boolean", PrimitiveTypeBoolean.class);
        if (!candidates.isEmpty()) {
            result = (Type)candidates.get(0);
        }
        return result;
    }

    private Type getType(CastExpression contextCasted) {
        Type result = null;
        if (contextCasted.getType() != null) {
            result = contextCasted.getType().getType();
        }
        return result;
    }

    private Type getType(CharacterLiteral contextCasted) {
        Type result = null;
        List<PrimitiveTypeChar> candidates = this.retrieveType(contextCasted.eResource(), "char", PrimitiveTypeChar.class);
        if (!candidates.isEmpty()) {
            result = (Type)candidates.get(0);
        }
        return result;
    }

    private Type getType(ClassInstanceCreation contextCasted) {
        Type result = null;
        if (contextCasted.getType() != null) {
            result = contextCasted.getType().getType();
        }
        return result;
    }

    private Type getType(FieldAccess contextCasted) {
        Type result = null;
        if (contextCasted.getField() != null) {
            result = this.getType(contextCasted.getField());
        }
        return result;
    }

    private Type getType(InstanceofExpression contextCasted) {
        Type result = null;
        List<PrimitiveTypeBoolean> candidates = this.retrieveType(contextCasted.eResource(), "boolean", PrimitiveTypeBoolean.class);
        if (!candidates.isEmpty()) {
            result = (Type)candidates.get(0);
        }
        return result;
    }

    private Type getType(MethodInvocation contextCasted) {
        AbstractTypeDeclaration result = null;
        if (contextCasted.getMethod() != null) {
            if (contextCasted.getMethod() instanceof MethodDeclaration && ((MethodDeclaration)contextCasted.getMethod()).getReturnType() != null) {
                result = ((MethodDeclaration)contextCasted.getMethod()).getReturnType().getType();
            } else if (contextCasted.getMethod() instanceof ConstructorDeclaration) {
                result = ((ConstructorDeclaration)contextCasted.getMethod()).getAbstractTypeDeclaration();
            }
        }
        return result;
    }

    private Type getType(NumberLiteral contextCasted) {
        Type result = null;
        try {
            Integer.parseInt(contextCasted.getTokenValue());
            List<PrimitiveTypeInt> candidates = this.retrieveType(contextCasted.eResource(), "int", PrimitiveTypeInt.class);
            if (!candidates.isEmpty()) {
                result = (Type)candidates.get(0);
            }
        }
        catch (NumberFormatException e) {
            List<PrimitiveTypeDouble> candidates = this.retrieveType(contextCasted.eResource(), "double", PrimitiveTypeDouble.class);
            if (candidates.isEmpty()) {
                List<PrimitiveTypeFloat> candidates2 = this.retrieveType(contextCasted.eResource(), "float", PrimitiveTypeFloat.class);
                if (!candidates2.isEmpty()) {
                    result = (Type)candidates2.get(0);
                }
            }
            result = (Type)candidates.get(0);
        }
        return result;
    }

    private Type getType(ParenthesizedExpression contextCasted) throws ModelQueryExecutionException {
        Type result = null;
        if (contextCasted.getExpression() != null) {
            result = this.evaluate((ASTNode)contextCasted.getExpression(), null);
        }
        return result;
    }

    private Type getType(PostfixExpression contextCasted) throws ModelQueryExecutionException {
        Type result = null;
        if (contextCasted.getOperand() != null) {
            result = this.evaluate((ASTNode)contextCasted.getOperand(), null);
        }
        return result;
    }

    private Type getType(PrefixExpression contextCasted) throws ModelQueryExecutionException {
        Type result = null;
        if (contextCasted.getOperand() != null) {
            result = this.evaluate((ASTNode)contextCasted.getOperand(), null);
        }
        return result;
    }

    private Type getType(SingleVariableAccess contextCasted) {
        Type result = null;
        if (contextCasted.getVariable() != null) {
            if (contextCasted.getVariable() instanceof SingleVariableDeclaration) {
                if (((SingleVariableDeclaration)contextCasted.getVariable()).getType() != null) {
                    result = ((SingleVariableDeclaration)contextCasted.getVariable()).getType().getType();
                }
            } else if (contextCasted.getVariable() instanceof VariableDeclarationFragment) {
                result = this.getType(((VariableDeclarationFragment)contextCasted.getVariable()).getVariablesContainer());
            }
        }
        return result;
    }

    private Type getType(StringLiteral contextCasted) {
        ClassDeclaration result = null;
        List<ClassDeclaration> candidates = this.retrieveType(contextCasted.eResource(), "String", ClassDeclaration.class);
        for (ClassDeclaration aCandidate : candidates) {
            if (aCandidate.getPackage() == null || !aCandidate.getPackage().getName().equals("lang")) continue;
            result = aCandidate;
        }
        return result;
    }

    private Type getType(SuperFieldAccess contextCasted) {
        Type result = null;
        if (contextCasted.getField() != null) {
            result = this.getType(contextCasted.getField());
        }
        return result;
    }

    private Type getType(SuperMethodInvocation contextCasted) {
        AbstractTypeDeclaration result = null;
        if (contextCasted.getMethod() != null) {
            if (contextCasted.getMethod() instanceof MethodDeclaration && ((MethodDeclaration)contextCasted.getMethod()).getReturnType() != null) {
                result = ((MethodDeclaration)contextCasted.getMethod()).getReturnType().getType();
            } else if (contextCasted.getMethod() instanceof ConstructorDeclaration) {
                result = ((ConstructorDeclaration)contextCasted.getMethod()).getAbstractTypeDeclaration();
            }
        }
        return result;
    }

    private Type getType(ThisExpression contextCasted) {
        Type result = null;
        if (contextCasted.getQualifier() != null) {
            result = contextCasted.getQualifier().getType();
        } else {
            EObject container = contextCasted.eContainer();
            while (!(container instanceof AbstractTypeDeclaration)) {
                container = container.eContainer();
            }
            result = (AbstractTypeDeclaration)container;
        }
        return result;
    }

    private Type getType(TypeLiteral contextCasted) {
        ClassDeclaration result = null;
        List<ClassDeclaration> candidates = this.retrieveType(contextCasted.eResource(), "Class", ClassDeclaration.class);
        for (ClassDeclaration aCandidate : candidates) {
            if (aCandidate.getPackage() == null || !aCandidate.getPackage().getName().equals("lang")) continue;
            result = aCandidate;
        }
        return result;
    }

    private <T> List<T> retrieveType(Resource aResource, String name, Class<T> type) {
        ArrayList<EObject> types = new ArrayList<EObject>();
        TreeIterator content = aResource.getAllContents();
        while (content.hasNext()) {
            EObject eObject = (EObject)content.next();
            if (!type.isInstance(eObject) || !(eObject instanceof Type) || !((Type)eObject).getName().equals(name)) continue;
            types.add(eObject);
        }
        return types;
    }
}

