/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.common;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.Messages;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.ControllerServices;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.ModelplexTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.common.TransformationTreeComposite;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.data.ElementDisplay;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AdditionalButtonsComposite
extends Composite {
    private final ControllerServices controller;
    private final ModelplexTransformation modelplexTransformation;
    private final TransformationTreeComposite transformationTreeComposite;
    private Button newButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private Button upButton = null;
    private Button downButton = null;

    public AdditionalButtonsComposite(Composite parent, int style, TransformationTreeComposite transformationTreeCompositeParameter, ControllerServices controllerParameter, ModelplexTransformation modelplexTransformationParameter) {
        super(parent, style);
        this.transformationTreeComposite = transformationTreeCompositeParameter;
        this.controller = controllerParameter;
        this.modelplexTransformation = modelplexTransformationParameter;
        this.initialize();
    }

    private void initialize() {
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.newButton = new Button((Composite)this, 0);
        this.newButton.setText(Messages.AdditionalButtonsComposite_0);
        this.newButton.setLayoutData((Object)gridData);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.newAdditionalTransformation();
            }
        });
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setText(Messages.AdditionalButtonsComposite_1);
        this.editButton.setLayoutData((Object)gridData4);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.editAdditionalTransformation();
            }
        });
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText(Messages.AdditionalButtonsComposite_2);
        this.removeButton.setLayoutData((Object)gridData3);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.removeAdditionalTransformation();
            }
        });
        this.upButton = new Button((Composite)this, 0);
        this.upButton.setText(Messages.AdditionalButtonsComposite_3);
        this.upButton.setLayoutData((Object)gridData2);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.upAdditionalTransformation();
            }
        });
        this.downButton = new Button((Composite)this, 0);
        this.downButton.setText(Messages.AdditionalButtonsComposite_4);
        this.downButton.setLayoutData((Object)gridData1);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.downAdditionalTransformation();
            }
        });
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 1;
        this.setSize(new Point(63, 202));
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(layoutData);
    }

    private final void newAdditionalTransformation() {
        Object[] elements;
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(null);
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.AdditionalButtonsComposite_5);
        dialog.setMessage(Messages.AdditionalButtonsComposite_6);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return ((IFile)element).getFileExtension().equals("asm");
                }
                return true;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            String additionalTransformationPath = ((IResource)elements[0]).getLocation().toString();
            this.controller.createAdditionalTransformation(additionalTransformationPath, this.modelplexTransformation);
        }
    }

    private final void editAdditionalTransformation() {
        ITreeSelection selection = this.transformationTreeComposite.getSelection();
        if (!selection.isEmpty()) {
            Object[] elements;
            IFile initialSelection;
            AtlTransformation updatedTransformation = null;
            for (Object updated : selection.toList()) {
                if (!(updated instanceof ElementDisplay)) continue;
                updatedTransformation = ((ElementDisplay)updated).getModelElement();
            }
            String location = updatedTransformation.getTransformationPath();
            WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
            WorkbenchContentProvider cp = new WorkbenchContentProvider();
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
            dialog.setValidator(null);
            dialog.setAllowMultiple(false);
            dialog.setTitle(Messages.AdditionalButtonsComposite_8);
            dialog.setMessage(Messages.AdditionalButtonsComposite_9);
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IFile) {
                        return ((IFile)element).getFileExtension().equals("asm");
                    }
                    return true;
                }
            });
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            if (location != null && location.length() != 0 && (initialSelection = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(location))) != null) {
                dialog.setInitialSelection((Object)initialSelection);
            }
            if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
                String additionalTransformationPath = ((IResource)elements[0]).getLocation().toString();
                this.controller.updateAdditionalTransformation(updatedTransformation, this.modelplexTransformation, additionalTransformationPath);
            }
        }
    }

    private final void removeAdditionalTransformation() {
        ITreeSelection selection = this.transformationTreeComposite.getSelection();
        if (!selection.isEmpty()) {
            for (Object removed : selection.toList()) {
                if (!(removed instanceof ElementDisplay)) continue;
                this.controller.deleteAdditionalTransformation(((ElementDisplay)removed).getModelElement(), this.modelplexTransformation);
            }
        }
    }

    private final void upAdditionalTransformation() {
        ITreeSelection selection = this.transformationTreeComposite.getSelection();
        if (!selection.isEmpty()) {
            for (Object upper : selection.toList()) {
                if (!(upper instanceof ElementDisplay)) continue;
                this.controller.upAdditionalTransformation(((ElementDisplay)upper).getModelElement(), this.modelplexTransformation);
            }
        }
    }

    private final void downAdditionalTransformation() {
        ITreeSelection selection = this.transformationTreeComposite.getSelection();
        if (!selection.isEmpty()) {
            for (Object lower : selection.toList()) {
                if (!(lower instanceof ElementDisplay)) continue;
                this.controller.downAdditionalTransformation(((ElementDisplay)lower).getModelElement(), this.modelplexTransformation);
            }
        }
    }
}

