/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.kdmbridge;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.Messages;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.ControllerServices;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.TransformationExporter;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.ModelplexTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.common.AdditionalButtonsComposite;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.common.TransformationTreeComposite;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.kdmbridge.KdmBridgePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class KdmBridgeBodyComposite
extends Composite {
    private Label standardTransformationLabel = null;
    private Button standardTransformationEditButton = null;
    private Label additionalLabel = null;
    private Composite additionalButtonsComposite = null;
    private TransformationTreeComposite additionalTransformationsComposite = null;
    private Label customTransformationLabel = null;
    private Button customTransformationCheckBox = null;
    private Text customTransformationText = null;
    private Button customTransformationButton = null;
    private KdmBridgePage pageValidationConsumer = null;
    private final ControllerServices controllerServices;
    private final ModelplexTransformation model;

    public KdmBridgeBodyComposite(Composite parent, int style, KdmBridgePage consumerParameter, ControllerServices controller) {
        super(parent, style);
        this.pageValidationConsumer = consumerParameter;
        this.controllerServices = controller;
        this.model = this.controllerServices.getModelServices().getDiscoverer().getToKdm();
        this.initialize();
        this.initializeFromModelInformations();
    }

    private final void initializeFromModelInformations() {
        if (this.model.isCustom()) {
            this.customTransformationCheckBox.setSelection(this.model.isCustom());
            this.customTransformationText.setText(this.model.getTransformationPath());
            this.customTransformationText.setEnabled(this.model.isCustom());
            this.customTransformationButton.setEnabled(this.model.isCustom());
        }
    }

    private void initialize() {
        GridData gridData11 = new GridData();
        gridData11.verticalAlignment = 1;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.standardTransformationLabel = new Label((Composite)this, 0);
        this.standardTransformationLabel.setText(Messages.KdmBridgeBodyComposite_0);
        this.standardTransformationEditButton = new Button((Composite)this, 0);
        this.standardTransformationEditButton.setText(Messages.KdmBridgeBodyComposite_1);
        this.standardTransformationEditButton.setLayoutData((Object)gridData1);
        this.standardTransformationEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KdmBridgeBodyComposite.this.exportStandardTransformation();
            }
        });
        this.customTransformationLabel = new Label((Composite)this, 0);
        this.customTransformationLabel.setText(Messages.KdmBridgeBodyComposite_2);
        this.customTransformationCheckBox = new Button((Composite)this, 32);
        this.customTransformationCheckBox.setLayoutData((Object)gridData);
        this.customTransformationCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KdmBridgeBodyComposite.this.customTransformationCheckBoxSelectionChange();
            }
        });
        this.customTransformationText = new Text((Composite)this, 2048);
        this.customTransformationText.setEnabled(false);
        this.customTransformationText.setEditable(false);
        this.customTransformationText.setLayoutData((Object)gridData2);
        this.customTransformationButton = new Button((Composite)this, 0);
        this.customTransformationButton.setText(Messages.KdmBridgeBodyComposite_3);
        this.customTransformationButton.setEnabled(false);
        this.customTransformationButton.setLayoutData((Object)gridData3);
        this.customTransformationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KdmBridgeBodyComposite.this.selectCustomTransformation();
            }
        });
        this.additionalLabel = new Label((Composite)this, 0);
        this.additionalLabel.setText(Messages.KdmBridgeBodyComposite_4);
        Label filler = new Label((Composite)this, 0);
        this.additionalTransformationsComposite = new TransformationTreeComposite(this, 0, this.controllerServices, this.model);
        this.controllerServices.getModelServices().getModelEventsSubscribe().subscribe(this.additionalTransformationsComposite);
        this.additionalButtonsComposite = new AdditionalButtonsComposite(this, 0, this.additionalTransformationsComposite, this.controllerServices, this.model);
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(500, 300));
    }

    final void customTransformationCheckBoxSelectionChange() {
        boolean selection = this.customTransformationCheckBox.getSelection();
        this.customTransformationText.setEnabled(selection);
        this.customTransformationButton.setEnabled(selection);
        this.pageValidationConsumer.pageValidationChanged(this.validatePage());
        this.model.setCustom(selection);
    }

    final void exportStandardTransformation() {
        ((WizardDialog)this.pageValidationConsumer.getWizard().getContainer()).close();
        TransformationExporter exporter = this.controllerServices.getTransformationExporter();
        exporter.exportSpecificToKdmTransformation();
    }

    final void selectCustomTransformation() {
        Object[] elements;
        IFile selection;
        String customTransformation = this.customTransformationText.getText();
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(null);
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.KdmBridgeBodyComposite_5);
        dialog.setMessage(Messages.KdmBridgeBodyComposite_6);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return ((IFile)element).getFileExtension().equals("asm");
                }
                return true;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (customTransformation == null || customTransformation.length() == 0) {
            customTransformation = this.model.getTransformationPath();
        }
        if (customTransformation != null && customTransformation.length() != 0 && (selection = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(customTransformation))) != null) {
            dialog.setInitialSelection((Object)selection);
        }
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            customTransformation = ((IResource)elements[0]).getLocation().toString();
            this.customTransformationText.setText(customTransformation);
            this.pageValidationConsumer.pageValidationChanged(this.validatePage());
            this.model.setCustom(true);
            this.model.setTransformationPath(customTransformation);
        }
    }

    public boolean validatePage() {
        boolean result = true;
        if (this.customTransformationCheckBox.getSelection()) {
            String path = this.customTransformationText.getText();
            if (path != null && !path.equals("")) {
                if (path.endsWith(".asm")) {
                    Path customTransformation = new Path(path);
                    result = customTransformation.toFile().exists();
                } else {
                    result = false;
                }
                if (!result) {
                    this.customTransformationText.forceFocus();
                    this.customTransformationText.selectAll();
                }
            } else {
                result = false;
            }
        }
        return result;
    }
}

