/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gmt.modisco.infra.common.cdo.derby.DerbyCDOServer;
import org.eclipse.gmt.modisco.infra.common.cdo.server.Server;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.discovery.benchmark.Benchmark;
import org.eclipse.modisco.infra.discovery.benchmark.MultiProjectBenchmark;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.modisco.java.discoverer.benchmark.Report;
import org.eclipse.modisco.java.discoverer.benchmark.cdo.client.BenchmarkJavaDiscovererCDO;
import org.eclipse.modisco.java.discoverer.benchmark.cdo.client.nousage.JavaDiscovererCDONoUsages;
import org.eclipse.modisco.java.discoverer.benchmark.cdo.server.DerbyCDOServerNoAudits;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererClassicalEMF;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFMinimalEObject;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFNoUsages;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererIncrementalEMF;
import org.eclipse.modisco.java.discoverer.benchmark.emfstat.DiscoverJavaModelFromJavaProjectEMFStat;
import org.eclipse.modisco.java.discoverer.benchmark.emfstat.Statistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunBenchmark
implements IDiscoverer<IJavaProject> {
    private static final int SERVER_WAITING_INTERVAL = 100;
    private static final int INITIAL_PORT = 2036;
    private int port = 2036;
    protected static final String LAUNCHTYPE = "org.eclipse.pde.ui.RuntimeWorkbench";
    private IProject statProject;

    public Benchmark createReport(IJavaProject source, IProgressMonitor monitor) throws CoreException, IOException {
        this.initStatProject(source);
        this.serverAndDisco(source, DerbyCDOServerNoAudits.class, BenchmarkJavaDiscovererCDO.class, monitor);
        this.serverAndDisco(source, DerbyCDOServerNoAudits.class, JavaDiscovererCDONoUsages.class, monitor);
        this.serverAndDisco(source, DerbyCDOServer.class, BenchmarkJavaDiscovererCDO.class, monitor);
        this.disco(source, JavaDiscovererIncrementalEMF.class, monitor);
        this.disco(source, JavaDiscovererEMFNoUsages.class, monitor);
        this.disco(source, JavaDiscovererEMFMinimalEObject.class, monitor);
        this.disco(source, JavaDiscovererClassicalEMF.class, monitor);
        Statistics.copyLog(this.statProject.getLocation().toFile());
        Report aReport = new Report(this.statProject);
        MultiProjectBenchmark benchmarkModel = aReport.generate();
        return benchmarkModel;
    }

    public IProject getStatProject() {
        return this.statProject;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isApplicableTo(IJavaProject source) {
        return source.getProject().isAccessible();
    }

    public void discoverElement(IJavaProject source, IProgressMonitor monitor) throws DiscoveryException {
        try {
            this.createReport(source, monitor);
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    protected void disco(IJavaProject source, Class<? extends DiscoverJavaModelFromJavaProjectEMFStat> discovererClass, IProgressMonitor monitor) {
        try {
            DiscoverJavaModelFromJavaProjectEMFStat discoverer = discovererClass.newInstance();
            discoverer.setStatProject(this.statProject);
            discoverer.discoverElement(source, monitor);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverAndDisco(IJavaProject source, Class<? extends Server> serverClass, Class<? extends BenchmarkJavaDiscovererCDO> discovererClass, IProgressMonitor monitor) {
        try {
            Status status = new Status(1, "org.eclipse.modisco.java.discoverer.benchmark", "Starting server: " + serverClass.getSimpleName());
            Activator.getDefault().getLog().log((IStatus)status);
            ++this.port;
            Server server = serverClass.newInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            server.start("db" + formatter.format((Object)System.currentTimeMillis()), this.port);
            Server server2 = server;
            synchronized (server2) {
                long before = System.currentTimeMillis();
                while (!server.isStarted()) {
                    server.wait(100L);
                }
                System.out.println("server took " + (System.currentTimeMillis() - before) + " ms to start");
            }
            Status status2 = new Status(1, "org.eclipse.modisco.java.discoverer.benchmark", "Starting discovery");
            Activator.getDefault().getLog().log((IStatus)status2);
            BenchmarkJavaDiscovererCDO discoverer = discovererClass.newInstance();
            discoverer.setStatProject(this.statProject);
            discoverer.setPort(this.port);
            discoverer.setServerDescription(server.getDescription());
            discoverer.discoverElement(source, monitor);
            Status status3 = new Status(1, "org.eclipse.modisco.java.discoverer.benchmark", "Stopping server");
            Activator.getDefault().getLog().log((IStatus)status3);
            server.stop();
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void initStatProject(IJavaProject sourceProject) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.statProject = ws.getRoot().getProject("statistics_" + formatter.format((Object)System.currentTimeMillis()));
        try {
            this.statProject.create((IProgressMonitor)new NullProgressMonitor());
            this.statProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            this.statProject = null;
        }
    }

    public ILaunch launch(String application) throws Exception {
        String name = "";
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCHTYPE);
        ILaunchConfigurationWorkingCopy launchConfiguration = null;
        launchConfiguration = type.newInstance(null, name);
        launchConfiguration = launchConfiguration.getWorkingCopy().getParent().doSave();
        ILaunchConfigurationWorkingCopy copy = launchConfiguration.getWorkingCopy();
        this.initAttribute(copy, "org.eclipse.modisco.java.discoverer.benchmark." + application);
        launchConfiguration = copy.doSave();
        ILaunch iLaunch = launchConfiguration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        return iLaunch;
    }

    protected void initAttribute(ILaunchConfigurationWorkingCopy copy, String application) {
        copy.setAttribute("append.args", true);
        copy.setAttribute("application", application);
        copy.setAttribute("askclear", true);
        copy.setAttribute("automaticAdd", true);
        copy.setAttribute("automaticValidate", false);
        copy.setAttribute("bootstrap", "");
        copy.setAttribute("checked", "[NONE]");
        copy.setAttribute("clearConfig", false);
        copy.setAttribute("clearws", false);
        copy.setAttribute("clearwslog", false);
        copy.setAttribute("configLocation", "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/New_configuration");
        copy.setAttribute("includeOptional", true);
        copy.setAttribute("location", "${workspace_loc}/../runtime-New_configuration");
        copy.setAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", "-os ${target.os} -ws ${target.ws} -arch ${target.arch} -nl ${target.nl} -consoleLog -port " + this.port);
        copy.setAttribute("org.eclipse.jdt.launching.SOURCE_PATH_PROVIDER", "org.eclipse.pde.ui.workbenchClasspathProvider");
        copy.setAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", "-Xms40m -Xmx512m");
        copy.setAttribute("pde.version", "3.3");
        copy.setAttribute("product", "org.eclipse.platform.ide");
        copy.setAttribute("show_selected_only", false);
        copy.setAttribute("templateConfig", "${target_home}\\configuration\\config.ini");
        copy.setAttribute("tracing", false);
        copy.setAttribute("useDefaultConfig", true);
        copy.setAttribute("useDefaultConfigArea", true);
        copy.setAttribute("useProduct", false);
        copy.setAttribute("usefeatures", false);
        copy.setAttribute("default", true);
    }
}

