/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.FileUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.infra.discovery.benchmark.AveragedMultiDiscoveryBenchmark;
import org.eclipse.modisco.infra.discovery.benchmark.AveragedProjectDiscovery;
import org.eclipse.modisco.infra.discovery.benchmark.BenchmarkFactory;
import org.eclipse.modisco.infra.discovery.benchmark.Discovery;
import org.eclipse.modisco.infra.discovery.benchmark.File;
import org.eclipse.modisco.infra.discovery.benchmark.ProjectDiscovery;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.modisco.java.discoverer.benchmark.internal.SystemInfo;
import org.eclipse.modisco.java.discoverer.benchmark.javaBenchmark.JavaBenchmarkFactory;
import org.eclipse.modisco.java.discoverer.benchmark.javaBenchmark.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBenchmarkDiscoverer
extends AbstractModelDiscoverer<IFile> {
    private static final int BYTES_PER_MEBIBYTE = 0x100000;
    private static final double MILLISECONDS_PER_SECOND = 1000.0;
    public static final String INPUT_FILE_NAME = "javabenchconfig.txt";
    public static final String OUTPUT_FILE_NAME = "javabench.xmi";
    private static final Integer FLUSH_LIMIT = 65536;
    private int numberOfIterations = 1;

    @Parameter(name="ITERATIONS", description="The number of iterations to perform.")
    public void setNumberOfIterations(int iterations) {
        this.numberOfIterations = iterations;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public boolean isApplicableTo(IFile source) {
        return source.exists() && INPUT_FILE_NAME.equals(source.getName());
    }

    protected void basicDiscoverElement(IFile source, IProgressMonitor monitor) throws DiscoveryException {
        IProject containingProject = source.getProject();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)containingProject.getFullPath().append(OUTPUT_FILE_NAME).toString(), (boolean)true));
        this.createTargetModel();
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            String[] lines;
            String input = FileUtils.readInputStream((InputStream)source.getContents(), (String)source.getCharset());
            String[] stringArray = lines = input.split("\\r?\\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                    IProject project = workspaceRoot.getProject(line);
                    if (!project.exists()) {
                        throw new DiscoveryException("Project \"" + project.getName() + "\" doesn't exist");
                    }
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (!javaProject.exists()) {
                        throw new DiscoveryException("\"" + project.getName() + "\" is not a valid Java project");
                    }
                    javaProjects.add(javaProject);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new DiscoveryException("Error reading input file", (Throwable)e);
        }
        catch (CoreException e) {
            throw new DiscoveryException("Error reading input file", (Throwable)e);
        }
        AveragedMultiDiscoveryBenchmark benchmark = JavaBenchmarkDiscoverer.benchmarkJavaProjectsDiscovery(monitor, javaProjects, this.numberOfIterations);
        this.getTargetModel().getContents().add((Object)benchmark);
    }

    public static AveragedMultiDiscoveryBenchmark benchmarkJavaProjectsDiscovery(IProgressMonitor monitor, List<IJavaProject> javaProjects, int nIterations) throws DiscoveryException {
        AveragedMultiDiscoveryBenchmark benchmark = BenchmarkFactory.eINSTANCE.createAveragedMultiDiscoveryBenchmark();
        benchmark.setJvmMaxHeapInMiB(Runtime.getRuntime().maxMemory() / 0x100000L);
        try {
            SystemInfo systemInfo = SystemInfo.getInstance();
            benchmark.setOsArchitecture(systemInfo.getArch());
            benchmark.setOsName(systemInfo.getOsName());
            benchmark.setOsVersion(systemInfo.getOsVersion());
            benchmark.setProcessorCacheSize(systemInfo.getProcCacheSize());
            benchmark.setProcessorCount(systemInfo.getnProcessors());
            benchmark.setProcessorDescription(systemInfo.getProcDescription());
            benchmark.setProcessorName(systemInfo.getProcName());
            benchmark.setSystemMemory(systemInfo.getMemory());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Could not get system information for benchmark", (Plugin)Activator.getDefault());
        }
        int nOperationsPerProject = 2;
        monitor.beginTask("Benchmarking java projects discovery", javaProjects.size() * nIterations * 2);
        for (IJavaProject javaProject : javaProjects) {
            JavaBenchmarkDiscoverer.testCanceled(monitor);
            AveragedProjectDiscovery averagedProjectDiscovery = BenchmarkFactory.eINSTANCE.createAveragedProjectDiscovery();
            benchmark.getDiscoveries().add((Object)averagedProjectDiscovery);
            int i = 0;
            while (i < nIterations) {
                JavaBenchmarkDiscoverer.testCanceled(monitor);
                ProjectDiscovery projectDiscovery = BenchmarkFactory.eINSTANCE.createProjectDiscovery();
                projectDiscovery.setName(javaProject.getElementName());
                averagedProjectDiscovery.getOccurrences().add((Object)projectDiscovery);
                JavaProject javaBenchmarkedProject = JavaBenchmarkFactory.eINSTANCE.createJavaProject();
                projectDiscovery.getProjects().add((Object)javaBenchmarkedProject);
                javaBenchmarkedProject.setName(javaProject.getElementName());
                JavaBenchmarkDiscoverer.testCanceled(monitor);
                JavaBenchmarkDiscoverer.discoverJavaFilesInProject(javaProject, monitor, javaBenchmarkedProject, (Discovery)projectDiscovery);
                monitor.worked(1);
                JavaBenchmarkDiscoverer.testCanceled(monitor);
                JavaBenchmarkDiscoverer.benchmarkProjectDiscovery(javaProject, monitor, javaBenchmarkedProject, (Discovery)projectDiscovery);
                monitor.worked(1);
                ++i;
            }
        }
        return benchmark;
    }

    protected static void testCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected static void discoverJavaFilesInProject(IJavaProject javaProject, final IProgressMonitor monitor, final JavaProject javaBenchmarkedProject, Discovery discovery) throws DiscoveryException {
        try {
            monitor.subTask("Visiting " + javaProject.getElementName());
            javaProject.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFile iFile;
                    JavaBenchmarkDiscoverer.testCanceled(monitor);
                    if (resource instanceof IFile && "java".equals((iFile = (IFile)resource).getFileExtension())) {
                        String input;
                        File file = BenchmarkFactory.eINSTANCE.createFile();
                        javaBenchmarkedProject.getFiles().add((Object)file);
                        file.setFilepath(iFile.getFullPath().removeFirstSegments(1).toPortableString());
                        try {
                            input = FileUtils.readInputStream((InputStream)iFile.getContents(), (String)iFile.getCharset());
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", 0, "Error reading file " + iFile.getFullPath().toString(), (Throwable)e));
                        }
                        String[] lines = input.split("\\r?\\n");
                        file.setLines((long)(lines.length + 1));
                        file.setSizeInBytes(iFile.getLocation().toFile().length());
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            throw new DiscoveryException("Error visiting project", (Throwable)e);
        }
    }

    protected static void benchmarkProjectDiscovery(IJavaProject javaProject, IProgressMonitor monitor, JavaProject javaBenchmarkedProject, Discovery discovery) {
        JavaBenchmarkDiscoverer.testCanceled(monitor);
        System.gc();
        long beforeDiscovery = System.currentTimeMillis();
        String error = null;
        DiscoverJavaModelFromJavaProject discoverer = null;
        try {
            discoverer = new DiscoverJavaModelFromJavaProject();
            discoverer.discoverElement((Object)javaProject, monitor);
        }
        catch (Throwable e) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(byteArrayOutputStream, true));
            error = byteArrayOutputStream.toString();
        }
        discovery.setDiscoveryError(error);
        long discoveryTime = System.currentTimeMillis() - beforeDiscovery;
        long totalMemory = Runtime.getRuntime().totalMemory();
        discovery.setDicoveryDate(new Date());
        discovery.setDiscovererClassName(DiscoverJavaModelFromJavaProject.class.getName());
        discovery.setDiscovererId("org.eclipse.modisco.java.discoverer.javaProject v" + Activator.getDefault().getBundle().getVersion().toString());
        discovery.setMaxUsedMemoryInBytes(totalMemory);
        discovery.setTotalExecutionTimeInSeconds((double)discoveryTime / 1000.0);
        if (discoverer != null) {
            Resource targetModel = discoverer.getTargetModel();
            discovery.setNumberOfModelElements(JavaBenchmarkDiscoverer.countModelElements(targetModel));
            IProject project = javaProject.getProject();
            String xmiFilename = String.valueOf(project.getName()) + "_java.xmi";
            IPath targetXMIPath = project.getFullPath().append(xmiFilename);
            targetModel.setURI(URI.createPlatformResourceURI((String)targetXMIPath.toString(), (boolean)true));
            JavaBenchmarkDiscoverer.testCanceled(monitor);
            long beforeSave = System.currentTimeMillis();
            try {
                JavaBenchmarkDiscoverer.save(targetModel);
            }
            catch (Throwable e) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                e.printStackTrace(new PrintWriter(byteArrayOutputStream, true));
                error = byteArrayOutputStream.toString();
                discovery.setDiscoveryError(error);
                return;
            }
            long saveTime = System.currentTimeMillis() - beforeSave;
            java.io.File xmiFile = project.getLocation().append(xmiFilename).toFile();
            discovery.setXmiSizeInBytes(xmiFile.length());
            discovery.setSaveTimeInSeconds((double)saveTime / 1000.0);
        }
    }

    private static void save(Resource targetModel) throws IOException {
        if (targetModel != null) {
            HashMap<String, Constable> options = new HashMap<String, Constable>();
            options.put("FLUSH_THRESHOLD", FLUSH_LIMIT);
            options.put("USE_FILE_BUFFER", Boolean.TRUE);
            try {
                targetModel.save(options);
            }
            catch (Resource.IOWrappedException e) {
                if (e.getCause() != null && e.getCause() instanceof CoreException) {
                    MoDiscoLogger.logWarning((Throwable)e, (String)("XMI serialization has failed on '" + targetModel.getURI() + "'. Trying again without File Buffer."), (Plugin)Activator.getDefault());
                    options.clear();
                    targetModel.save(options);
                    MoDiscoLogger.logInfo((String)("XMI serialization is done for " + targetModel.getURI()), (Plugin)Activator.getDefault());
                }
                throw e;
            }
        }
    }

    protected static long countModelElements(Resource targetModel) {
        TreeIterator allContents = targetModel.getAllContents();
        long nElements = 0L;
        while (allContents.hasNext()) {
            allContents.next();
            ++nElements;
        }
        return nElements;
    }
}

