/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.benchmark.Benchmark;
import org.eclipse.modisco.infra.discovery.core.AbstractDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.modisco.java.discoverer.benchmark.template.html.HtmlReport2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBenchmarkHtmlReportDiscoverer
extends AbstractDiscoverer<IFile> {
    public static final String TARGET_FILENAME = "javaDiscoveryBenchmark.html";

    public boolean isApplicableTo(IFile source) {
        try {
            return source.exists() && "org.eclipse.modisco.infra.discovery.benchmark.contenttype".equals(source.getContentDescription().getContentType().getId());
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return false;
        }
    }

    public static IFile generateBenchmarkReport(Benchmark benchmark, IContainer location, IProgressMonitor monitor) throws IOException, CoreException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(TARGET_FILENAME);
        new HtmlReport2((EObject)benchmark, location.getLocation().toFile(), arguments).doGenerate(null);
        location.refreshLocal(2, monitor);
        return location.getFile((IPath)new Path(TARGET_FILENAME));
    }

    protected void basicDiscoverElement(IFile source, IProgressMonitor monitor) throws DiscoveryException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)source.getFullPath().toString(), (boolean)true), true);
        try {
            resource.load(Collections.emptyMap());
            Benchmark benchmark = (Benchmark)resource.getContents().get(0);
            JavaBenchmarkHtmlReportDiscoverer.generateBenchmarkReport(benchmark, source.getParent(), monitor);
        }
        catch (IOException e) {
            throw new DiscoveryException((Throwable)e);
        }
        catch (CoreException e) {
            throw new DiscoveryException((Throwable)e);
        }
    }
}

