/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.cdo.derby.DerbyCDOServer;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.discovery.benchmark.MultiProjectBenchmark;
import org.eclipse.modisco.java.discoverer.benchmark.AbstractRunBenchmark;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.modisco.java.discoverer.benchmark.Report;
import org.eclipse.modisco.java.discoverer.benchmark.cdo.client.BenchmarkJavaDiscovererCDO;
import org.eclipse.modisco.java.discoverer.benchmark.cdo.client.nousage.JavaDiscovererCDONoUsages;
import org.eclipse.modisco.java.discoverer.benchmark.cdo.server.DerbyCDOServerNoAudits;
import org.eclipse.modisco.java.discoverer.benchmark.cdo.server.H2CDOServer;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererClassicalEMF;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFMinimalEObject;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFNoUsages;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererIncrementalClassicalEMF;
import org.eclipse.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererIncrementalEMF;
import org.eclipse.modisco.java.discoverer.benchmark.emfstat.Statistics;

public class RunBenchmark
extends AbstractRunBenchmark {
    private long before;

    public MultiProjectBenchmark createReport(IJavaProject source, IProgressMonitor monitor) throws CoreException, IOException {
        this.initStatProject(source);
        this.benchmark(source, monitor);
        Statistics.copyLog(this.getStatProject().getLocation().toFile());
        Report report = new Report(this.getStatProject());
        MultiProjectBenchmark benchmarkModel = report.generate();
        try {
            this.getStatProject().refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
        return benchmarkModel;
    }

    private void begin(String name) {
        System.out.println("beginning: " + name);
        this.before = System.currentTimeMillis();
    }

    private void end() {
        System.out.println("took : " + (System.currentTimeMillis() - this.before));
    }

    protected void benchmark(IJavaProject source, IProgressMonitor monitor) {
        this.begin("XMI, incremental");
        this.disco(source, JavaDiscovererIncrementalEMF.class, monitor);
        this.end();
        this.begin("XMI, MinimalEObject");
        this.disco(source, JavaDiscovererEMFMinimalEObject.class, monitor);
        this.end();
        this.begin("XMI, Without usages");
        this.disco(source, JavaDiscovererEMFNoUsages.class, monitor);
        this.end();
        this.begin("Reference discoverer");
        this.disco(source, JavaDiscovererClassicalEMF.class, monitor);
        this.end();
        this.begin("Incremental and classical EMF");
        this.disco(source, JavaDiscovererIncrementalClassicalEMF.class, monitor);
        this.end();
        this.begin("CDO+H2, No audits, With usage");
        this.serverAndDisco(source, H2CDOServer.class, BenchmarkJavaDiscovererCDO.class, monitor);
        this.end();
        this.begin("CDO+H2, No audits, Without usages");
        this.serverAndDisco(source, H2CDOServer.class, JavaDiscovererCDONoUsages.class, monitor);
        this.end();
        this.begin("CDO+Derby, No audits, With usages");
        this.serverAndDisco(source, DerbyCDOServerNoAudits.class, BenchmarkJavaDiscovererCDO.class, monitor);
        this.end();
        this.begin("CDO+Derby, No audits, Without usages");
        this.serverAndDisco(source, DerbyCDOServerNoAudits.class, JavaDiscovererCDONoUsages.class, monitor);
        this.end();
        this.begin("CDO+Derby, with audits, With usages");
        this.serverAndDisco(source, DerbyCDOServer.class, BenchmarkJavaDiscovererCDO.class, monitor);
        this.end();
    }
}

