/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.modisco.java.discoverer.benchmark.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateReportAction
implements IDiscoverer<IProject> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isApplicableTo(IProject source) {
        IProject project = source;
        if (!project.isAccessible()) return false;
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                IResource propertiesFile;
                IFile file;
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && (file = (IFile)resource).getFileExtension().equals("tsv") && (propertiesFile = project.findMember(String.valueOf(file.getName().replaceAll("(.*)\\.tsv", "$1.")) + "txt")) != null) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return false;
    }

    public void discoverElement(IProject source, IProgressMonitor monitor) throws DiscoveryException {
        IProject project = source;
        try {
            new Report(project).generate();
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        try {
            project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MoDiscoLogger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
    }
}

