/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.cdo.client;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.cdo.impl.JavaPackageImpl;
import org.eclipse.gmt.modisco.java.cdo.meta.JavaFactory;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.modisco.java.discoverer.benchmark.Messages;
import org.eclipse.modisco.java.discoverer.benchmark.emfstat.DiscoverJavaModelFromJavaProjectEMFStat;
import org.eclipse.modisco.java.discoverer.benchmark.emfstat.JavaReaderEMFStat;
import org.eclipse.modisco.java.discoverer.cdo.JavaDiscovererCDO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkJavaDiscovererCDO
extends DiscoverJavaModelFromJavaProjectEMFStat {
    private final String cacheType = "LRU_CACHE";
    private Object serverDescription = Messages.serverDescription;
    private int port = 2036;

    protected void endAnalyzeJavaProject(Model model) {
        JavaDiscovererCDO.close((Resource)model.eResource(), (boolean)true);
    }

    protected Resource createTargetModel() {
        String resourceName = "" + System.currentTimeMillis();
        Status status = new Status(1, "org.eclipse.modisco.java.discoverer.benchmark", String.valueOf(Messages.JavaDiscovererCDO_10) + resourceName);
        Activator.getDefault().getLog().log((IStatus)status);
        EPackage ePackage = this.getEFactory().getEPackage();
        if (ePackage == null) {
            throw new RuntimeException("ePackage is null. this.getEFactory()=" + this.getEFactory());
        }
        CDOResource result = JavaDiscovererCDO.getOrCreateCDOResource((String)resourceName, (EPackage)ePackage, (String)"LRU_CACHE", (int)this.port);
        result.getContents().add((Object)this.getEFactory().createModel());
        this.dbInit(result);
        this.setTargetModel((Resource)result);
        return result;
    }

    @Override
    protected Properties getProperties() {
        Properties properties = super.getProperties();
        properties.put("STORAGE_KIND", "CDO");
        properties.put("CDO_VERSION", Platform.getBundle((String)"org.eclipse.emf.cdo").getVersion().toString());
        if ("LRU_CACHE".equals("LRU_CACHE")) {
            properties.put("CDO_CACHE_TYPE", "LRU_CACHE");
            properties.put("CURRENT_LRU_CAPACITY", new Integer(1000).toString());
            properties.put("REVISED_LRU_CAPACITY", new Integer(1000).toString());
        } else if ("DEFAULT_CACHE".equals("LRU_CACHE")) {
            properties.put("CDO_CACHE_TYPE", "DEFAULT_CACHE");
        } else if ("MEM_CACHE".equals("LRU_CACHE")) {
            properties.put("CDO_CACHE_TYPE", "MEM_CACHE");
        } else {
            properties.put("CDO_CACHE_TYPE", "Wrong revision cache type");
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", "Wrong revision cache type", (Throwable)new Exception());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        properties.put("CDO_SERVER_DESCRIPTION", this.serverDescription);
        properties.put("ALGO_VARIANT", Messages.JavaDiscovererCDO_18);
        return properties;
    }

    public org.eclipse.gmt.modisco.java.emf.JavaFactory getEFactory() {
        JavaPackageImpl.init();
        return JavaFactory.eINSTANCE;
    }

    private void dbInit(CDOResource resource) {
        CDOView cdoView;
        if (this.getStatistics() != null) {
            this.getStatistics().beginInit();
        }
        if ((cdoView = resource.cdoView()) instanceof CDOTransaction) {
            CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
            try {
                cdoTransaction.commit();
            }
            catch (CommitException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStatistics() != null) {
            this.getStatistics().endInit();
        }
    }

    @Override
    protected JavaReaderEMFStat getJavaReader(Map<String, Object> elementOptions) {
        JavaReaderEMFStat javaReader = new JavaReaderEMFStat(this.getEFactory(), true){

            protected void reset() {
                CDOObject cdoObject;
                CDOView cdoView;
                if (this.getStatistics() != null) {
                    this.getStatistics().tabValueReport("Begin reset");
                }
                this.getGlobalBindings().resolveBindings(this.getResultModel());
                if (this.getStatistics() != null) {
                    this.getStatistics().tabValueReport("globalBindings resolved");
                }
                if (this.getStatistics() != null) {
                    this.getStatistics().beginSave();
                }
                if (this.getResultModel() instanceof CDOObject && (cdoView = (cdoObject = (CDOObject)this.getResultModel()).cdoView()) instanceof CDOTransaction) {
                    CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
                    try {
                        cdoTransaction.commit();
                    }
                    catch (CommitException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setGlobalBindings(this.getBindingManager());
                if (this.getStatistics() != null) {
                    this.getStatistics().endSave();
                }
                if (this.getStatistics() != null) {
                    this.getStatistics().tabValueReport("End reset");
                }
            }
        };
        javaReader.setStatistics(this.getStatistics());
        return javaReader;
    }

    public void setServerDescription(String serverDescription) {
        this.serverDescription = serverDescription;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

