/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.cdo.server;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.gmt.modisco.infra.common.cdo.server.AbstractCDOServer;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.h2.jdbcx.JdbcDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2CDOServer
extends AbstractCDOServer {
    protected DataSource getDataSource(String dbName) throws Exception {
        JdbcDataSource dataSource = new JdbcDataSource();
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(dbName);
            project.create((IProgressMonitor)new NullProgressMonitor());
            if (!project.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.gmt.modisco.infra.common.cdo.h2", "Failed to create the DB project"));
            }
            dataSource.setURL("jdbc:h2:file:" + project.getLocation().toString() + "/h2DB");
        }
        catch (Exception e) {
            throw new Exception("Failed to use the workspace.", e);
        }
        return dataSource;
    }

    protected Map<String, String> getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "gastro");
        props.put("supportingAudits", Boolean.TRUE.toString());
        return props;
    }

    protected IMappingStrategy getMappingStrategy() {
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("qualifiedNames", "true");
        mappingStrategy.setProperties(properties);
        return mappingStrategy;
    }

    public String getDescription() {
        return "H2, SUPPORTING_AUDITS";
    }

    protected IDBAdapter getDBAdapter() {
        return new H2Adapter();
    }
}

