/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.emfstat;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.java.discoverer.benchmark.emfstat.JavaReaderEMFStat;
import org.eclipse.modisco.java.discoverer.benchmark.emfstat.Statistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverJavaModelFromJavaProjectEMFStat
extends DiscoverJavaModelFromJavaProject {
    public static final int MEGA_BYTES = 0x100000;
    public static final String STORAGE_KIND = "STORAGE_KIND";
    public static final String JAVA_PROJECT_NAME = "JAVA_PROJECT_NAME";
    public static final String DISCOVERER_CLASS_NAME = "DISCOVERER_CLASS_NAME";
    public static final String DISCOVERY_DATE = "DISCOVERY_DATE";
    public static final String XMX = "XMX";
    public static final String MM_VARIANT = "MM_VARIANT";
    public static final String ALGO_VARIANT = "ALGO_VARIANT";
    private Statistics statistics;
    private IJavaProject javaProject;
    private IProject statProject;

    protected void basicDiscoverElement(IJavaProject source, IProgressMonitor monitor) throws DiscoveryException {
        this.javaProject = source;
        this.getStatistics().getProperties().put(JAVA_PROJECT_NAME, this.javaProject.getElementName());
        this.getStatistics().getProperties().put(DISCOVERER_CLASS_NAME, ((Object)((Object)this)).getClass().getName());
        this.getStatistics().getProperties().put(DISCOVERY_DATE, new Date().toString());
        this.getStatistics().getProperties().putAll((Map<?, ?>)this.getProperties());
        this.getStatistics().begin();
        super.basicDiscoverElement(source, monitor);
        this.getStatistics().end();
    }

    protected void saveTargetModel() throws IOException {
        this.getStatistics().beginSave();
        super.saveTargetModel();
        this.getStatistics().endSave();
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.put(STORAGE_KIND, "XMI");
        return properties;
    }

    protected JavaReaderEMFStat getJavaReader(Map<String, Object> elementOptions) {
        JavaReaderEMFStat javaReader = new JavaReaderEMFStat(this.getEFactory(), false);
        javaReader.setStatistics(this.getStatistics());
        return javaReader;
    }

    public void setStatProject(IProject statProject) {
        this.statProject = statProject;
    }

    protected IProject getStatProject() {
        if (this.statProject == null) {
            File projectFile = Statistics.getDefaultStatProject(this.getProject()).getLocation().toFile();
            this.statProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectFile.getName());
        }
        return this.statProject;
    }

    protected Statistics getStatistics() {
        if (this.statistics == null) {
            File statProjectFile = this.getStatProject().getLocation().toFile();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            this.statistics = Statistics.getStatistics(String.valueOf(this.getProject().getName()) + "_" + formatter.format((Object)System.currentTimeMillis()), statProjectFile);
            this.statistics.getProperties().put(JAVA_PROJECT_NAME, this.getProject().getName());
            this.statistics.getProperties().put(DISCOVERER_CLASS_NAME, ((Object)((Object)this)).getClass().getName());
            this.statistics.getProperties().put(DISCOVERY_DATE, new Date().toString());
            this.statistics.getProperties().put(XMX, String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L / 0x100000L) + "MB");
        }
        return this.statistics;
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }
}

