/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.emfstat;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    private static final int DEFAULT_SINCE_BEGIN = 1000;
    private static final int MEGA_BYTES = 1024;
    private static final long GC_SLEEP = 50L;
    private static final String FREE_MEMORY = "FREE_MEMORY (Mo)";
    public static final String MAX_TOTAL_MEMORY = "MAX_TOTAL_MEMORY";
    private static final String MAX_PENDING_SIZE = "MAX_PENDING_SIZE";
    private static final String NB_COMPILATION_UNITS = "NB_COMPILATION_UNITS";
    private static final String CURRENT_PENDING_SIZE = "CURRENT_PENDING_SIZE";
    private static final String NB_LINES = "NB_LINES";
    private static final String MAX_TARGET_SIZE = "NB_LINES";
    private static final String CURRENT_TARGET_SIZE = "CURRENT_TARGET_SIZE";
    public static final String SINCEBEGIN = "SINCEBEGIN (ms)";
    private static final String DEBUG = "DEBUG";
    private static final String NB_ELEMENTS = "NB_ELEMENT";
    public static final String SAVE = "SAVE (ms)";
    private static final String TOTAL_RESOLVE = "TOTAL_RESOLVE";
    private static final String DISCOVERY = "DISCOVERY";
    private static final String FINAL_RESOLVE = "FINAL_RESOLVE";
    public static final String USED_MEMORY = "USED_MEMORY";
    public static final String DEBUG_CODE = "DEBUG_CODE";
    private static final String EXEC_DURATION = "EXEC_DURATION";
    private long nbOfReadLines = 0L;
    private long beginSave = 0L;
    private long beginFinalResolve = 0L;
    private long beginResolve;
    private final String statisticId;
    private PrintStream ps;
    private final HashMap<String, Integer> messageMap = new HashMap();
    private Long end = null;
    private Long beginDiscovery = null;
    private Long begin = null;
    private File statisticsDir;
    private PrintStream txtPrintStream;
    private static Statistics singleton;
    private static HashMap<String, Statistics> instanceMap;
    private static HashMap<String, Object> statisticMap;
    private long beginInit = 0L;
    private File txtFile;
    public static final String INIT_TIME = "INIT_TIME";
    public static final String TSV_FILE_EXT = "tsv";
    public static final String PROPERTIES_FILE_EXT = "txt";
    private static final String DEEP_REMOVE = "DEEP_REMOVE";
    private static final String MESSAGE = "MESSAGE";
    private long beginDeepRemove = 0L;
    private final Properties properties = new Properties();

    static {
        instanceMap = new HashMap();
        statisticMap = new HashMap();
    }

    public Statistics(String id) {
        this.statisticId = id;
        String javaIoTmpdirStr = System.getProperty("java.io.tmpdir");
        File javaIoTmpdir = new File(javaIoTmpdirStr);
        this.setStatisticsDir(new File(javaIoTmpdir, "statistics"));
        this.getStatisticsDir().mkdirs();
        this.initPrinitStream();
    }

    public Statistics(String id, File directory) {
        this.statisticId = id;
        directory.mkdirs();
        this.setStatisticsDir(directory);
        this.initPrinitStream();
    }

    private void initPrinitStream() {
        File tsvFile = new File(this.getStatisticsDir(), String.valueOf(this.statisticId) + "." + TSV_FILE_EXT);
        this.txtFile = new File(this.getStatisticsDir(), String.valueOf(this.statisticId) + "." + PROPERTIES_FILE_EXT);
        Status status = new Status(1, "org.eclipse.modisco.java.discoverer.benchmark", "TSV statistic file= " + tsvFile.toString());
        Activator.getDefault().getLog().log((IStatus)status);
        Status status2 = new Status(1, "org.eclipse.modisco.java.discoverer.benchmark", "TXT statistic file= " + this.txtFile.toString());
        Activator.getDefault().getLog().log((IStatus)status2);
        try {
            this.ps = new PrintStream(tsvFile);
            this.txtPrintStream = new PrintStream(this.txtFile);
        }
        catch (FileNotFoundException e) {
            Status status3 = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status3);
        }
    }

    public static Statistics getStatistics(String key) {
        if (instanceMap.containsKey(key)) {
            return instanceMap.get(key);
        }
        Statistics statistics = new Statistics(key);
        instanceMap.put(key, statistics);
        return statistics;
    }

    public static Statistics getStatistics(String key, File directory) {
        if (instanceMap.containsKey(key)) {
            return instanceMap.get(key);
        }
        Statistics statistics = new Statistics(key, directory);
        instanceMap.put(key, statistics);
        return statistics;
    }

    public void reset() {
        statisticMap.put(FREE_MEMORY, new Long(0L));
        statisticMap.put(MAX_TOTAL_MEMORY, new Long(0L));
        statisticMap.put(MAX_PENDING_SIZE, new Long(0L));
        statisticMap.put(CURRENT_PENDING_SIZE, new Long(0L));
        statisticMap.put(NB_COMPILATION_UNITS, new Long(0L));
        statisticMap.put("NB_LINES", new Long(0L));
        statisticMap.put("NB_LINES", new Long(0L));
        statisticMap.put(CURRENT_TARGET_SIZE, new Long(0L));
        statisticMap.put(SAVE, new Long(0L));
        statisticMap.put(EXEC_DURATION, new Long(0L));
        statisticMap.put(TOTAL_RESOLVE, new Long(0L));
        statisticMap.put(USED_MEMORY, new Long(0L));
        statisticMap.put(DEBUG_CODE, new Long(0L));
        statisticMap.put(DISCOVERY, new Long(0L));
        statisticMap.put(FINAL_RESOLVE, new Long(0L));
        statisticMap.put(NB_ELEMENTS, new Long(0L));
        statisticMap.put(DEEP_REMOVE, new Long(0L));
        statisticMap.put(MESSAGE, "");
        this.nbOfReadLines = 0L;
        this.beginSave = 0L;
        this.beginFinalResolve = 0L;
        this.beginResolve = 0L;
        this.begin = null;
        this.end = null;
        this.beginDiscovery = null;
    }

    private static void recordMemory() {
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        long freememory = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
        statisticMap.put(FREE_MEMORY, freememory);
        long totalmemory = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        Long maxtotalmemory = (Long)statisticMap.get(MAX_TOTAL_MEMORY);
        if (maxtotalmemory == null) {
            maxtotalmemory = new Long(0L);
        }
        maxtotalmemory = Math.max(maxtotalmemory, totalmemory);
        statisticMap.put(MAX_TOTAL_MEMORY, maxtotalmemory);
        statisticMap.put(USED_MEMORY, totalmemory - freememory);
    }

    public static void recordPendingSize(List<Object> list) {
        long currentPendingSize = list.size();
        long maxPendingSize = (Long)statisticMap.get(MAX_PENDING_SIZE);
        statisticMap.put(MAX_PENDING_SIZE, Math.max(maxPendingSize, currentPendingSize));
        statisticMap.put(CURRENT_PENDING_SIZE, currentPendingSize);
    }

    public static void recordTargetSize(Map<Object, Object> map) {
        Long currentTargetSize = new Long(map.size());
        Long maxTargetSize = (Long)statisticMap.get("NB_LINES");
        statisticMap.put("NB_LINES", Math.max(maxTargetSize, currentTargetSize));
        statisticMap.put(CURRENT_TARGET_SIZE, currentTargetSize);
    }

    public String tabKeyReport() {
        Statistics.recordMemory();
        this.sinceBegin();
        this.debug("");
        StringBuffer sbKey = new StringBuffer();
        for (String key : statisticMap.keySet()) {
            sbKey.append(String.valueOf(key) + "\t");
        }
        String result = sbKey.toString();
        this.ps.println(result);
        return result;
    }

    public String tabValueReport(String message) {
        this.debug(message);
        return this.tabValueReport();
    }

    public void sinceBegin() {
        Long result = this.begin != null ? (this.end != null ? Long.valueOf(this.end - this.begin) : Long.valueOf(new Date().getTime() - this.begin)) : new Long(-1000L);
        statisticMap.put(SINCEBEGIN, result);
    }

    public void printProperty(String key, String value) {
        this.txtPrintStream.println(String.valueOf(key) + "=" + value);
    }

    public void debug(String message) {
        int debugCode;
        if (this.messageMap.containsKey(message)) {
            debugCode = this.messageMap.get(message);
        } else {
            int size;
            debugCode = size = this.messageMap.size();
            this.messageMap.put(message, debugCode);
        }
        statisticMap.put(DEBUG, message);
        statisticMap.put(DEBUG_CODE, debugCode);
    }

    public String tabValueReport() {
        Statistics.recordMemory();
        this.sinceBegin();
        StringBuffer sbValue = new StringBuffer();
        for (String key : statisticMap.keySet()) {
            sbValue.append(statisticMap.get(key) + "\t");
        }
        String result = sbValue.toString();
        this.ps.println(result);
        return result;
    }

    public void newCompilationUnit(ITypeRoot cu) {
        Statistics.incCompilationUnits();
        IPath location = cu.getResource().getLocation();
        File file = location.toFile();
        int nbLines = 0;
        try {
            BufferedReader bufferReader = new BufferedReader(new FileReader(file));
            while (bufferReader.readLine() != null) {
                ++nbLines;
            }
            bufferReader.close();
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", "Failed to count the CompilationUnit number of lines: ", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.nbOfReadLines += (long)nbLines;
        statisticMap.put("NB_LINES", this.nbOfReadLines);
        this.tabValueReport("New cu");
    }

    public void countElements(Resource r) {
        this.tabValueReport("begin count elements");
        long nbElements = 0L;
        TreeIterator treeIter = r.getAllContents();
        while (treeIter.hasNext()) {
            treeIter.next();
            ++nbElements;
        }
        statisticMap.put(NB_ELEMENTS, nbElements);
        this.tabValueReport("end count elements");
    }

    public void getMemoryInfo() {
    }

    public void begin() {
        try {
            this.properties.store(this.txtPrintStream, "");
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.reset();
        this.tabKeyReport();
        this.begin = new Date().getTime();
        this.tabValueReport("Begin job");
    }

    public void end() {
        this.end = new Date().getTime();
        this.tabValueReport("end");
        try {
            this.txtPrintStream = new PrintStream(this.txtFile);
            this.properties.store(this.txtPrintStream, "");
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.ps.close();
        this.txtPrintStream.close();
    }

    public void beginDiscovery() {
        this.beginDiscovery = new Date().getTime();
        this.tabValueReport("Ressource created and dicovery begining");
    }

    public void endDiscovery() {
        statisticMap.put(DISCOVERY, new Date().getTime() - this.beginDiscovery);
        this.tabValueReport("Dicovery finished");
    }

    public void beginSave() {
        this.beginSave = new Date().getTime();
        this.tabValueReport("Begin save");
    }

    public void endSave() {
        long save = (Long)statisticMap.get(SAVE);
        statisticMap.put(SAVE, save + (new Date().getTime() - this.beginSave));
        this.tabValueReport("End save");
    }

    public void beginFinalResolve() {
        this.beginFinalResolve = new Date().getTime();
        this.tabValueReport("beginFinalResolve");
    }

    public void endFinalResolve() {
        long endFinalResolve = new Date().getTime();
        Long finalResolve = (Long)statisticMap.get(FINAL_RESOLVE);
        statisticMap.put(FINAL_RESOLVE, finalResolve + (endFinalResolve - this.beginFinalResolve));
        this.tabValueReport("endFinalResolve");
    }

    public void beginResolve() {
        this.beginResolve = new Date().getTime();
    }

    public void endResolve() {
        Long endResolve = new Date().getTime();
        Long totalResolv = (Long)statisticMap.get(TOTAL_RESOLVE);
        statisticMap.put(TOTAL_RESOLVE, totalResolv + (endResolve - this.beginResolve));
    }

    public static void incCompilationUnits() {
        Long nbCu = (Long)statisticMap.get(NB_COMPILATION_UNITS);
        nbCu = nbCu + 1L;
        statisticMap.put(NB_COMPILATION_UNITS, nbCu);
    }

    public static Statistics getSingleton() {
        if (singleton == null) {
            singleton = Statistics.getStatistics("org.eclipse.modisco.java.discoverer.benchmark_" + System.currentTimeMillis());
        }
        return singleton;
    }

    public static void resetSingleton() {
        singleton = Statistics.getStatistics("org.eclipse.modisco.java.discoverer.benchmark_" + System.currentTimeMillis());
    }

    public void newPackage(IPackageFragment parent) {
    }

    public void sendMessage(Object message) {
        String[] message2;
        if (message instanceof String) {
            String stringMessage = (String)message;
            if (stringMessage.equals("Begin deep remove")) {
                this.beginDeepRemove();
            }
        } else if (message instanceof String[] && (message2 = (String[])message)[0].equals("End deep remove")) {
            this.endDeepRemove(message2[1]);
        }
    }

    private void beginDeepRemove() {
        this.beginDeepRemove = new Date().getTime();
    }

    private void endDeepRemove(String objectDescription) {
        long deepRemove = (Long)statisticMap.get(DEEP_REMOVE);
        statisticMap.put(MESSAGE, objectDescription);
        statisticMap.put(DEEP_REMOVE, deepRemove + (new Date().getTime() - this.beginDeepRemove));
        this.tabValueReport("Deep remove");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void beginInit() {
        this.beginInit = new Date().getTime();
    }

    public void endInit() {
        this.properties.put(INIT_TIME, new Long(new Date().getTime() - this.beginInit).toString());
    }

    public void setStatisticsDir(File statisticsDir) {
        this.statisticsDir = statisticsDir;
    }

    public File getStatisticsDir() {
        return this.statisticsDir;
    }

    public void copyLog() {
        Statistics.copyLog(this.statisticsDir);
    }

    public static void copyLog(File statDir) {
        File platformLogFile = Platform.getLogFileLocation().toFile();
        File localLogFile = new File(statDir, "log.log");
        Reader reader = null;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(localLogFile), "UTF-8");
            reader = new InputStreamReader((InputStream)new FileInputStream(platformLogFile), "UTF-8");
            Statistics.copy(reader, writer);
        }
        catch (Exception ex) {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e1) {
                MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copy(Reader input, Writer output) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            try {
                reader = new BufferedReader(input);
                writer = new BufferedWriter(output);
                String line = reader.readLine();
                while (reader.ready()) {
                    if (line == null) {
                        return;
                    }
                    writer.write(line);
                    writer.newLine();
                    line = reader.readLine();
                }
                return;
            }
            catch (IOException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer == null) return;
                    writer.close();
                    return;
                }
                catch (IOException e1) {
                    MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
                    return;
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
            }
        }
    }

    public static IProject getDefaultStatProject(IProject sourceProject) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        IProject localStatProject = ws.getRoot().getProject("statistics_" + formatter.format((Object)System.currentTimeMillis()) + "_" + sourceProject.getName());
        try {
            localStatProject.create((IProgressMonitor)new NullProgressMonitor());
            localStatProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            localStatProject = null;
        }
        return localStatProject;
    }
}

