/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemInfo {
    private static SystemInfo instance;
    private String procName;
    private String procDescription;
    private String procCacheSize;
    private String memory;
    private String osName;
    private String osVersion;
    private String arch;
    private int nProcessors;

    private SystemInfo() throws IOException {
        this.computeInfo();
    }

    public String getArch() {
        return this.arch;
    }

    public String getMemory() {
        return this.memory;
    }

    public int getnProcessors() {
        return this.nProcessors;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getProcDescription() {
        return this.procDescription;
    }

    public String getProcCacheSize() {
        return this.procCacheSize;
    }

    public String getProcName() {
        return this.procName;
    }

    public static synchronized SystemInfo getInstance() throws IOException {
        if (instance == null) {
            instance = new SystemInfo();
        }
        return instance;
    }

    private void computeInfo() throws IOException {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        this.osName = bean.getName();
        this.osVersion = bean.getVersion();
        this.arch = bean.getArch();
        this.nProcessors = bean.getAvailableProcessors();
        this.procName = "";
        this.procDescription = "";
        this.procCacheSize = "";
        this.memory = "";
        if (this.osName.contains("Windows")) {
            String nl = System.getProperty("line.separator");
            StringBuilder script = new StringBuilder();
            script.append("On Error Resume Next" + nl);
            script.append("Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")" + nl);
            script.append("Set colItems = objWMIService.ExecQuery(\"Select * from Win32_Processor\",,48)" + nl);
            script.append("For Each objItem in colItems" + nl);
            script.append("Wscript.Echo \"Name: \" & objItem.Name" + nl);
            script.append("Wscript.Echo \"Description: \" & objItem.Description" + nl);
            script.append("Wscript.Echo \"L2CacheSize: \" & objItem.L2CacheSize" + nl);
            script.append("Next" + nl);
            script.append("Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")" + nl);
            script.append("Wscript.Echo \"memory\"" + nl);
            script.append("Set colItems2 = objWMIService.ExecQuery(\"Select * from Win32_PhysicalMemory\",,48)" + nl);
            script.append("For Each objItem in colItems2" + nl);
            script.append("Wscript.Echo \"Capacity: \" & objItem.Capacity" + nl);
            script.append("Next" + nl);
            File scriptFile = File.createTempFile("systemInfoScript", ".vbs");
            scriptFile.deleteOnExit();
            BufferedWriter writer = new BufferedWriter(new FileWriter(scriptFile));
            try {
                writer.write(script.toString());
            }
            finally {
                ((Writer)writer).close();
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("cscript.exe", scriptFile.getPath());
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            String result = SystemInfo.readStream(inputStream);
            this.procName = SystemInfo.getInfo("Name", result);
            this.procDescription = SystemInfo.getInfo("Description", result);
            this.procCacheSize = SystemInfo.getInfo("L2CacheSize", result);
            List<String> infos = SystemInfo.getInfos("Capacity", result);
            long mem = 0L;
            for (String info : infos) {
                mem += Long.parseLong(info);
            }
            this.memory = "" + mem;
        } else {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("cat", "/proc/cpuinfo");
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            String result = SystemInfo.readStream(inputStream);
            this.procName = SystemInfo.getInfo("model name", result);
            this.procDescription = SystemInfo.getInfo("flags", result);
            this.procCacheSize = SystemInfo.getInfo("cache size", result);
            processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command("cat", "/proc/meminfo");
            process = processBuilder.start();
            inputStream = process.getInputStream();
            result = SystemInfo.readStream(inputStream);
            this.memory = SystemInfo.getInfo("MemTotal", result);
        }
    }

    private static String getInfo(String name, String result) {
        List<String> infos = SystemInfo.getInfos(name, result);
        if (infos.size() > 0) {
            return infos.get(0);
        }
        return "";
    }

    private static List<String> getInfos(String name, String result) {
        Pattern patternName = Pattern.compile(String.valueOf(name) + "\\s*:\\s*(.*)");
        Matcher matcher = patternName.matcher(result);
        ArrayList<String> infos = new ArrayList<String>();
        while (matcher.find()) {
            infos.add(matcher.group(1).trim());
        }
        return infos;
    }

    private static String readStream(InputStream inputStream) throws IOException {
        StringBuilder builder = new StringBuilder();
        try {
            int n;
            int bufferSize = 65536;
            char[] buffer = new char[65536];
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((n = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
        return builder.toString();
    }
}

