/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.infra.discovery.benchmark.AveragedMultiDiscoveryBenchmark;
import org.eclipse.modisco.infra.discovery.benchmark.Benchmark;
import org.eclipse.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.modisco.java.discoverer.benchmark.JavaBenchmarkDiscoverer;
import org.eclipse.modisco.java.discoverer.benchmark.JavaBenchmarkHtmlReportDiscoverer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class BenchmarkAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator iterator = structuredSelection.iterator();
            final ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)object;
                    javaProjects.add(javaProject);
                    continue;
                }
                if (!(object instanceof IProject)) continue;
                IProject project = (IProject)object;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (!javaProject.exists()) {
                    throw new ExecutionException("Not a Java project : " + project.getName());
                }
                javaProjects.add(javaProject);
            }
            if (javaProjects.isEmpty()) {
                return null;
            }
            InputDialog inputDialog = new InputDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Iterations", "Number of iterations:", "3", new IInputValidator(){

                public String isValid(String newText) {
                    try {
                        int value = Integer.parseInt(newText);
                        if (value < 1) {
                            return "Please enter a positive number";
                        }
                    }
                    catch (NumberFormatException e) {
                        return "You must enter a valid number";
                    }
                    return null;
                }
            });
            if (inputDialog.open() == 1) {
                return null;
            }
            final int nIterations = Integer.parseInt(inputDialog.getValue());
            Job job = new Job("Benchmark Java Projects"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("javaBenchmark_" + System.currentTimeMillis());
                        try {
                            project.create((IProgressMonitor)new NullProgressMonitor());
                            project.open((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.modisco.java.discoverer.benchmark", "Couldn't create a project for benchmark results", (Throwable)e));
                        }
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        Resource resource = resourceSet.createResource(URI.createURI((String)("memory:/javaBenchmark/" + System.currentTimeMillis())));
                        AveragedMultiDiscoveryBenchmark benchmark = JavaBenchmarkDiscoverer.benchmarkJavaProjectsDiscovery(monitor, javaProjects, nIterations);
                        resource.getContents().add((Object)benchmark);
                        final IFile benchmarkReportFile = JavaBenchmarkHtmlReportDiscoverer.generateBenchmarkReport((Benchmark)benchmark, (IContainer)project, monitor);
                        resource.setURI(URI.createPlatformResourceURI((String)benchmarkReportFile.getProject().getFile("javabench.xmi").getFullPath().toString(), (boolean)true));
                        resource.save(Collections.EMPTY_MAP);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                try {
                                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)benchmarkReportFile);
                                }
                                catch (PartInitException e) {
                                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }
}

