/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.template.html;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.NumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.impl.LabelBlockImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.modisco.infra.discovery.benchmark.AveragedMultiDiscoveryBenchmark;
import org.eclipse.modisco.infra.discovery.benchmark.AveragedProjectDiscovery;
import org.eclipse.modisco.infra.discovery.benchmark.Project;
import org.eclipse.modisco.infra.discovery.benchmark.ProjectDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BirtGraphHelper {
    private static final double CHART_UNIT_SPACING = 0.1;
    public static final double MEBIBYTE = 1048576.0;

    private BirtGraphHelper() {
    }

    public static void createBirtGraph(AveragedMultiDiscoveryBenchmark benchmark, File targetFolder) throws ChartException {
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        chart.setUnitSpacing(0.1);
        chart.getPlot().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getLegend().setVisible(false);
        chart.getTitle().getLabel().getCaption().setValue("Discovery time as function of project size");
        Axis xAxis = chart.getPrimaryBaseAxes()[0];
        xAxis.setType(AxisType.LINEAR_LITERAL);
        xAxis.setFormatSpecifier((FormatSpecifier)NumberFormatSpecifierImpl.create());
        xAxis.getTitle().getCaption().setValue("Project size (MiB)");
        xAxis.getTitle().setVisible(true);
        ArrayList<Point> dataPoints = new ArrayList<Point>();
        for (AveragedProjectDiscovery discovery : benchmark.getDiscoveries()) {
            EList projects = ((ProjectDiscovery)discovery.getOccurrences().get(0)).getProjects();
            long totalSizeInBytes = 0L;
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                totalSizeInBytes += project.getTotalSizeInBytes();
            }
            dataPoints.add(new Point((double)totalSizeInBytes / 1048576.0, discovery.getAverageExecutionTimeInSeconds()));
        }
        Collections.sort(dataPoints, new Comparator<Point>(){

            @Override
            public int compare(Point o1, Point o2) {
                if (o1.x == o2.x) {
                    return 0;
                }
                if (o1.x < o2.x) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList<Double> xAxisValues = new ArrayList<Double>();
        for (Point dataPoint : dataPoints) {
            xAxisValues.add(dataPoint.x);
        }
        NumberDataSet xAxisDataSet = NumberDataSetImpl.create(xAxisValues);
        Series xAxisSeries = SeriesImpl.create();
        xAxisSeries.setDataSet((DataSet)xAxisDataSet);
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xSeriesDefinition.getSeries().add((Object)xAxisSeries);
        xAxis.getSeriesDefinitions().add((Object)xSeriesDefinition);
        Axis yAxis = chart.getPrimaryOrthogonalAxis(xAxis);
        yAxis.setType(AxisType.LINEAR_LITERAL);
        yAxis.setFormatSpecifier((FormatSpecifier)NumberFormatSpecifierImpl.create());
        yAxis.getTitle().setVisible(true);
        yAxis.getTitle().getCaption().setValue("Discovery time (seconds)");
        ScatterSeries lineSeries = (ScatterSeries)ScatterSeriesImpl.create();
        ArrayList<Double> yAxisValues = new ArrayList<Double>();
        for (Point dataPoint : dataPoints) {
            yAxisValues.add(dataPoint.y);
        }
        NumberDataSet dataSet = NumberDataSetImpl.create(yAxisValues);
        lineSeries.setDataSet((DataSet)dataSet);
        LineAttributes lineAttr = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        lineAttr.setVisible(false);
        lineSeries.setLineAttributes(lineAttr);
        Point[] linearRegression = BirtGraphHelper.computeLinearRegression(dataPoints);
        LineSeries linearRegressionSeries = (LineSeries)LineSeriesImpl.create();
        ArrayList<Double> regressionYAxisValues = new ArrayList<Double>();
        Point[] pointArray = linearRegression;
        int n = linearRegression.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            regressionYAxisValues.add(point.y);
            ++n2;
        }
        NumberDataSet linearRegressionDataSet = NumberDataSetImpl.create(regressionYAxisValues);
        linearRegressionSeries.setDataSet((DataSet)linearRegressionDataSet);
        linearRegressionSeries.getMarkers().clear();
        LineAttributes lineAttr2 = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.DASHED_LITERAL, (int)1);
        lineAttr2.setVisible(true);
        linearRegressionSeries.setLineAttributes(lineAttr2);
        Point lastPoint = linearRegression[linearRegression.length - 1];
        LabelBlock labelBlock = (LabelBlock)LabelBlockImpl.create();
        Label label = LabelImpl.create();
        label.setCaption(TextImpl.create((String)String.format("%.3f s/MiB", lastPoint.y / lastPoint.x)));
        labelBlock.setLabel(label);
        labelBlock.setAnchor(Anchor.NORTH_EAST_LITERAL);
        chart.getPlot().add((Block)labelBlock);
        SeriesDefinition ySeriesDefinition = SeriesDefinitionImpl.create();
        ySeriesDefinition.getSeries().add((Object)lineSeries);
        ySeriesDefinition.getSeries().add((Object)linearRegressionSeries);
        yAxis.getSeriesDefinitions().add((Object)ySeriesDefinition);
        PluginSettings ps = PluginSettings.instance();
        IDeviceRenderer render = ps.getDevice("dv.PNG");
        render.setProperty("device.file.identifier", (Object)new File(targetFolder, "executionTimeByProjectSize.png"));
        int width = 800;
        int height = 400;
        Bounds bounds = BoundsImpl.create((double)0.0, (double)0.0, (double)800.0, (double)400.0);
        Generator generator = Generator.instance();
        GeneratedChartState state = generator.build(render.getDisplayServer(), (Chart)chart, bounds, null, null, null);
        generator.render(render, state);
    }

    private static Point[] computeLinearRegression(List<Point> dataPoints) {
        double size = dataPoints.size();
        if ((int)size == 0) {
            return new Point[0];
        }
        if ((int)size == 1) {
            Point point = dataPoints.get(0);
            return new Point[]{new Point(point.x, point.y)};
        }
        double sumXY = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        for (Point point : dataPoints) {
            sumX += point.x;
            sumXX += point.x * point.x;
            sumY += point.y;
            sumXY += point.x * point.y;
        }
        double a = (size * sumXY - sumX * sumY) / (size * sumXX - sumX * sumX);
        double b = (sumY - a * sumX) / size;
        ArrayList<Point> resultPoints = new ArrayList<Point>();
        for (Point point : dataPoints) {
            resultPoints.add(new Point(point.x, a * point.x + b));
        }
        return resultPoints.toArray(new Point[resultPoints.size()]);
    }
}

