/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.template.html;

import java.util.Collection;
import org.eclipse.modisco.infra.discovery.benchmark.Discovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlReportServices {
    private static final int UNIT_0 = 0;
    private static final int UNIT_1 = 1;
    private static final int UNIT_2 = 2;
    private static final int UNIT_3 = 3;
    private static final int UNIT_4 = 4;
    private static final int UNIT_5 = 5;
    private static final double SECONDS_PER_MINUTE = 60.0;

    private HtmlReportServices() {
    }

    public static double maxExecutionTime(Collection<Discovery> discoveries) {
        double maxExecutionTime = 0.0;
        for (Discovery discovery : discoveries) {
            maxExecutionTime = Math.max(discovery.getTotalExecutionTimeInSeconds(), maxExecutionTime);
        }
        return maxExecutionTime;
    }

    public static double maxSaveTime(Collection<Discovery> discoveries) {
        double maxSaveTime = 0.0;
        for (Discovery discovery : discoveries) {
            maxSaveTime = Math.max(discovery.getSaveTimeInSeconds(), maxSaveTime);
        }
        return maxSaveTime;
    }

    public static String lfToBr(String str) {
        return str.replaceAll("\\n", "<br/>");
    }

    public static String sizeWithUnit(Double value) {
        double unitChange = 1024.0;
        double result = value;
        int unit = 0;
        while (result > 1024.0) {
            result /= 1024.0;
            ++unit;
        }
        if (unit > 0) {
            return String.valueOf(String.format("%.1f", result)) + " " + HtmlReportServices.unitName(unit);
        }
        return String.valueOf((int)result) + " " + HtmlReportServices.unitName(unit);
    }

    private static String unitName(int unit) {
        switch (unit) {
            case 0: {
                return "bytes";
            }
            case 1: {
                return "KiB";
            }
            case 2: {
                return "MiB";
            }
            case 3: {
                return "GiB";
            }
            case 4: {
                return "TiB";
            }
            case 5: {
                return "PiB";
            }
        }
        throw new IllegalArgumentException("" + unit);
    }

    public static String timeWithUnit(Double seconds) {
        Double remainder = seconds;
        int minutes = 0;
        while (remainder > 60.0) {
            remainder = remainder - 60.0;
            ++minutes;
        }
        if (minutes > 0) {
            return String.valueOf(minutes) + "m " + remainder.intValue() + "s";
        }
        return String.valueOf(String.format("%.2f", remainder)) + "s";
    }
}

