/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.customization.OverlayIconImageInfo;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.AttributeItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ColorProvider;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTreePainter {
    private static final int MAX_ALPHA = 255;
    private final AppearanceConfiguration appearanceConfiguration;
    private final Tree fTree;
    private int mouseX;
    private int mouseY;
    private boolean hovering = false;

    public CustomTreePainter(final Tree tree, AppearanceConfiguration appearanceConfiguration) {
        this.fTree = tree;
        this.appearanceConfiguration = appearanceConfiguration;
        this.setupTreeCustomPaint(tree);
        tree.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tree.redraw();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                CustomTreePainter.this.mouseX = e.x;
                CustomTreePainter.this.mouseY = e.y;
                if (CustomTreePainter.this.hovering) {
                    CustomTreePainter.this.hovering = false;
                    tree.redraw();
                }
            }
        });
        tree.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                if (CustomTreePainter.this.hovering) {
                    CustomTreePainter.this.mouseX = 0;
                    CustomTreePainter.this.mouseY = 0;
                    CustomTreePainter.this.hovering = false;
                    tree.redraw();
                }
            }
        });
        tree.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.hovering = true;
                tree.redraw();
            }
        });
    }

    private boolean isOrderedReference(Object object) {
        if (this.appearanceConfiguration.isSortInstances()) {
            return false;
        }
        if (object instanceof LinkItem) {
            LinkItem linkItemProvider = (LinkItem)object;
            EReference reference = linkItemProvider.getReference();
            return reference.isMany() && reference.isOrdered();
        }
        return false;
    }

    private boolean isOrderingEnabled() {
        return this.appearanceConfiguration.isShowOrdering();
    }

    private void handleMeasureItem(Event event) {
        int maxX;
        ModelElementItem modelElementItem;
        EObject eObject;
        List<StickerToPaint> stickersToPaint;
        if (event.item.getData("dataLoaded") == Boolean.FALSE) {
            return;
        }
        TreeItem item = (TreeItem)event.item;
        Object data = item.getData();
        if (this.isOrderingEnabled() && this.isOrderedReference(data)) {
            int leftMargin = 5;
            event.width += 5 + event.height / 2 + 1;
        }
        if (data instanceof ModelElementItem && !(stickersToPaint = this.getStickersToPaintFor(eObject = (modelElementItem = (ModelElementItem)data).getEObject(), event.x, event.width, event.y, event.height, maxX = this.fTree.getClientArea().width + this.fTree.getHorizontalBar().getSelection())).isEmpty()) {
            Rectangle lastStickerBounds = stickersToPaint.get(stickersToPaint.size() - 1).getBounds();
            event.width = lastStickerBounds.x + lastStickerBounds.width;
        }
    }

    private void handlePaintItem(Event event) {
        if (event.item.getData("dataLoaded") == Boolean.FALSE) {
            return;
        }
        TreeItem item = (TreeItem)event.item;
        Object data = item.getData();
        if (this.isOrderingEnabled() && this.isOrderedReference(data)) {
            this.paintOrderArrow(event);
        }
        if (this.isModelElementWithNoResource(data)) {
            this.paintNoResourceDecoration(event);
        }
        if (this.isModelElementNotInFirstResource(data)) {
            this.paintNotInFirstResourceDecoration(event);
        }
        this.paintCustomization(data, event);
        this.paintStickerIcons(data, event);
    }

    private boolean isModelElementWithNoResource(Object element) {
        if (element instanceof ModelElementItem) {
            ModelElementItem elementItem = (ModelElementItem)element;
            EObject eObject = elementItem.getEObject();
            return eObject.eResource() == null;
        }
        return false;
    }

    private boolean isModelElementNotInFirstResource(Object element) {
        ModelElementItem elementItem;
        EObject eObject;
        return element instanceof ModelElementItem && !EMFUtil.isInFirstResource(eObject = (elementItem = (ModelElementItem)element).getEObject());
    }

    private void paintNoResourceDecoration(Event event) {
        event.gc.setForeground(ColorProvider.getInstance().getNullResourceColor());
        event.gc.setLineWidth(2);
        event.gc.drawLine(event.x + 1, event.y + 2, event.x + 14, event.y + event.height - 4);
    }

    private void paintNotInFirstResourceDecoration(Event event) {
        Image shortcutIcon = ImageProvider.getInstance().getShortcutIcon();
        event.gc.drawImage(shortcutIcon, event.x, event.y + event.height - shortcutIcon.getBounds().height - 1);
    }

    public List<StickerToPaint> getStickersToPaintFor(EObject eObject, int posX, int width, int posY, int height, int maxX) {
        int rightX = posX + width;
        int margin = 8;
        int offset = 8;
        int spacing = 5;
        int overlayIconWidth = 8;
        int overlayIconHeight = 8;
        int normalIconWidth = 16;
        int normalIconHeight = 16;
        ArrayList<StickerToPaint> stickersToPaint = new ArrayList<StickerToPaint>();
        int lastX = 0;
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Rectangle itemBounds = new Rectangle(posX, posY, width, height);
        EClass eClass = eObject.eClass();
        Image stickerIcon = customizationEngine.getStickerIcon(eObject, eClass);
        if (stickerIcon != null) {
            int iconWidth = stickerIcon.getBounds().width;
            int iconHeight = stickerIcon.getBounds().height;
            if (iconWidth > 16) {
                iconWidth = 16;
            }
            if (iconHeight > 16) {
                iconHeight = 16;
            }
            int additionalOffsetX = (16 - iconWidth) / 2;
            int additionalOffsetY = (16 - iconHeight) / 2;
            Rectangle targetBounds = new Rectangle(rightX + offset + additionalOffsetX, posY + additionalOffsetY, iconWidth, iconHeight);
            offset += 21;
            stickersToPaint.add(new StickerToPaint(targetBounds, itemBounds, null, stickerIcon, false));
            lastX = targetBounds.x + targetBounds.width;
        }
        for (Facet facet : this.appearanceConfiguration.getFacetContext().getFacets(eObject)) {
            Image mainIcon;
            Image facetStickerIcon;
            OverlayIconImageInfo facetOverlayIcon = customizationEngine.getFacetOverlayIcon(eObject, (EClass)facet);
            if (facetOverlayIcon != null) {
                Point overlayIconOffset = this.getOverlayIconOffset(facetOverlayIcon);
                Rectangle targetBounds = new Rectangle(posX + overlayIconOffset.x, posY + overlayIconOffset.y, 8, 8);
                stickersToPaint.add(new StickerToPaint(targetBounds, itemBounds, facet, facetOverlayIcon.getImage(), true));
            }
            if ((facetStickerIcon = customizationEngine.getStickerIcon(eObject, (EClass)facet)) == null && ((mainIcon = customizationEngine.getFacetMainIcon(eObject, (EClass)facet)) != null || (facetStickerIcon = customizationEngine.getTypeIcon(eObject, (EClass)facet)) == null)) continue;
            int iconWidth = facetStickerIcon.getBounds().width;
            int iconHeight = facetStickerIcon.getBounds().height;
            if (iconWidth > 16) {
                iconWidth = 16;
            }
            if (iconHeight > 16) {
                iconHeight = 16;
            }
            int additionalOffsetX = (16 - iconWidth) / 2;
            int additionalOffsetY = (16 - iconHeight) / 2;
            Rectangle targetBounds = new Rectangle(rightX + offset + additionalOffsetX, posY + additionalOffsetY, iconWidth, iconHeight);
            offset += 21;
            stickersToPaint.add(new StickerToPaint(targetBounds, itemBounds, facet, facetStickerIcon, false));
            lastX = targetBounds.x + targetBounds.width;
        }
        if (lastX > maxX) {
            int shift = lastX - maxX;
            ListIterator stickersToPaintIterator = stickersToPaint.listIterator();
            while (stickersToPaintIterator.hasNext()) {
                StickerToPaint stickerToPaint = (StickerToPaint)stickersToPaintIterator.next();
                if (stickerToPaint.isOverlay()) continue;
                stickerToPaint.getBounds().x -= shift;
                int minVisibleText = 50;
                if (stickerToPaint.getBounds().x < posX + 50) {
                    stickersToPaintIterator.remove();
                    continue;
                }
                int overlapWithText = rightX - stickerToPaint.getBounds().x;
                if (overlapWithText <= 0) continue;
                int minAlpha = 128;
                int multiplicator = 3;
                int alpha = Math.max(255 - overlapWithText * 3, 128);
                stickerToPaint.setAlpha(alpha);
            }
        }
        return stickersToPaint;
    }

    private Point getOverlayIconOffset(OverlayIconImageInfo facetOverlayIcon) {
        int step = 8;
        switch (facetOverlayIcon.getIconPosition()) {
            case TopLeft: {
                return new Point(0, 0);
            }
            case TopMiddle: {
                return new Point(8, 0);
            }
            case TopRight: {
                return new Point(16, 0);
            }
            case BottomLeft: {
                return new Point(0, 8);
            }
            case BottomMiddle: {
                return new Point(8, 8);
            }
            case BottomRight: {
                return new Point(16, 8);
            }
        }
        MoDiscoLogger.logError((String)"Unhandled overlay icon position", (Plugin)Activator.getDefault());
        return null;
    }

    private void paintStickerIcons(Object data, Event event) {
        if (data instanceof ModelElementItem) {
            int maxX;
            ModelElementItem modelElementItem = (ModelElementItem)data;
            EObject eObject = modelElementItem.getEObject();
            List<StickerToPaint> stickersToPaint = this.getStickersToPaintFor(eObject, event.x, event.width, event.y, event.height, maxX = this.fTree.getClientArea().width + this.fTree.getHorizontalBar().getSelection());
            if (stickersToPaint.isEmpty()) {
                this.fTree.setToolTipText(null);
                return;
            }
            this.fTree.setToolTipText("");
            boolean showStickers = !this.hovering || !this.hoveringOnTextLeftOfFacets(stickersToPaint);
            for (StickerToPaint stickerToPaint : stickersToPaint) {
                Image customizedIcon = stickerToPaint.getImage();
                if (customizedIcon == null) continue;
                Rectangle bounds = customizedIcon.getBounds();
                Rectangle target = stickerToPaint.getBounds();
                if (!stickerToPaint.isOverlay()) {
                    if (!showStickers) continue;
                    boolean hoveringOverFacet = this.hovering && stickerToPaint.getBounds().contains(this.mouseX, this.mouseY);
                    int alpha = stickerToPaint.getAlpha();
                    if (hoveringOverFacet) {
                        alpha = 255;
                    }
                    event.gc.setAlpha(alpha);
                }
                event.gc.drawImage(customizedIcon, 0, 0, bounds.width, bounds.height, target.x, target.y, target.width, target.height);
            }
        }
    }

    private boolean hoveringOnTextLeftOfFacets(List<StickerToPaint> stickersToPaint) {
        if (stickersToPaint.size() == 0) {
            return false;
        }
        if (stickersToPaint.get(0).getAlpha() == 255) {
            return false;
        }
        StickerToPaint first = stickersToPaint.get(0);
        return first.getItemBounds().contains(this.mouseX, this.mouseY) && this.mouseX < first.getBounds().x;
    }

    private void paintCustomization(Object element, Event event) {
        int y;
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        boolean underlined = false;
        boolean struckthrough = false;
        if (element instanceof ModelElementItem) {
            ModelElementItem elementItem = (ModelElementItem)element;
            EObject eObject = elementItem.getEObject();
            underlined = customizationEngine.isTypeUnderlined(eObject.eClass(), eObject);
            struckthrough = customizationEngine.isTypeStruckthrough(eObject.eClass(), eObject);
        } else if (element instanceof AttributeItem) {
            AttributeItem attributeItem = (AttributeItem)element;
            EObject parent = attributeItem.getParent();
            underlined = customizationEngine.isAttributeUnderlined(attributeItem.facetOrParentClass(), attributeItem.getAttribute().getName(), parent);
            struckthrough = customizationEngine.isAttributeStruckthrough(attributeItem.facetOrParentClass(), attributeItem.getAttribute().getName(), parent);
        } else if (element instanceof LinkItem) {
            LinkItem linkItem = (LinkItem)element;
            EObject parent = linkItem.getParent();
            underlined = customizationEngine.isReferenceUnderlined(linkItem.facetOrParentClass(), linkItem.getReference().getName(), parent);
            struckthrough = customizationEngine.isReferenceStruckthrough(linkItem.facetOrParentClass(), linkItem.getReference().getName(), parent);
        }
        int leftMargin = 23;
        int rightMargin = 2;
        if (underlined) {
            y = event.y + event.height - 2;
            event.gc.drawLine(event.x + 23, y, event.x + event.width - 2, y);
        }
        if (struckthrough) {
            y = event.y + event.height / 2 + 1;
            event.gc.drawLine(event.x + 23, y, event.x + event.width - 2, y);
        }
    }

    private void paintOrderArrow(Event event) {
        int left;
        int horizontalDivs = 4;
        int leftMargin = 5;
        int three = 3;
        int arrowSize = event.height / 2;
        arrowSize -= arrowSize % 4;
        int top = event.y + event.height / 4;
        int x0 = left = event.x + event.width + 5;
        int x1 = left + arrowSize / 4;
        int x2 = left + arrowSize / 2;
        int x3 = left + arrowSize / 4 * 3;
        int x4 = left + arrowSize;
        int y0 = top;
        int y1 = top + arrowSize / 2;
        int y2 = top + arrowSize;
        event.gc.drawPolygon(new int[]{x1, y0, x3, y0, x3, y1, x4, y1, x2, y2, x0, y1, x1, y1});
    }

    private void setupTreeCustomPaint(Tree tree) {
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.handleMeasureItem(event);
            }
        });
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.handlePaintItem(event);
            }
        });
    }

    public void dispose() {
    }

    public static class StickerToPaint {
        private static final int INITIAL_ALPHA = 255;
        private final Rectangle bounds;
        private final Facet facet;
        private int alpha = 255;
        private final Rectangle itemBounds;
        private final Image image;
        private final boolean overlay;

        public StickerToPaint(Rectangle bounds, Rectangle itemBounds, Facet facet, Image image, boolean overlay) {
            this.bounds = bounds;
            this.itemBounds = itemBounds;
            this.facet = facet;
            this.image = image;
            this.overlay = overlay;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public Rectangle getItemBounds() {
            return this.itemBounds;
        }

        public Facet getFacet() {
            return this.facet;
        }

        public Image getImage() {
            return this.image;
        }

        public boolean isOverlay() {
            return this.overlay;
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }

        public int getAlpha() {
            return this.alpha;
        }
    }
}

