/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.modisco.infra.discovery.benchmark.AveragedProjectDiscovery;
import org.eclipse.modisco.infra.discovery.benchmark.BenchmarkPackage;
import org.eclipse.modisco.infra.discovery.benchmark.ProjectDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AveragedProjectDiscoveryImpl
extends EObjectImpl
implements AveragedProjectDiscovery {
    protected static final double AVERAGE_EXECUTION_TIME_IN_SECONDS_EDEFAULT = 0.0;
    protected static final double AVERAGE_SAVE_TIME_IN_SECONDS_EDEFAULT = 0.0;
    protected static final double EXECUTION_TIME_STANDARD_DEVIATION_EDEFAULT = 0.0;
    protected static final double SAVE_TIME_STANDARD_DEVIATION_EDEFAULT = 0.0;
    protected EList<ProjectDiscovery> occurrences;

    protected AveragedProjectDiscoveryImpl() {
    }

    protected EClass eStaticClass() {
        return BenchmarkPackage.Literals.AVERAGED_PROJECT_DISCOVERY;
    }

    private static double rounded(double value) {
        return (double)((int)(value * 1000.0)) / 1000.0;
    }

    @Override
    public double getAverageExecutionTimeInSeconds() {
        if (this.getOccurrences().isEmpty()) {
            return 0.0;
        }
        double totalExecutionTime = 0.0;
        for (ProjectDiscovery discovery : this.getOccurrences()) {
            totalExecutionTime += discovery.getTotalExecutionTimeInSeconds();
        }
        return AveragedProjectDiscoveryImpl.rounded(totalExecutionTime / (double)this.getOccurrences().size());
    }

    @Override
    public double getAverageSaveTimeInSeconds() {
        if (this.getOccurrences().isEmpty()) {
            return 0.0;
        }
        double totalSaveTime = 0.0;
        for (ProjectDiscovery discovery : this.getOccurrences()) {
            totalSaveTime += discovery.getSaveTimeInSeconds();
        }
        return AveragedProjectDiscoveryImpl.rounded(totalSaveTime / (double)this.getOccurrences().size());
    }

    @Override
    public double getExecutionTimeStandardDeviation() {
        if (this.getOccurrences().isEmpty()) {
            return 0.0;
        }
        double squareDiffsSum = 0.0;
        double average = this.getAverageExecutionTimeInSeconds();
        for (ProjectDiscovery discovery : this.getOccurrences()) {
            double diff = discovery.getTotalExecutionTimeInSeconds() - average;
            squareDiffsSum += diff * diff;
        }
        double variance = squareDiffsSum / (double)this.getOccurrences().size();
        return AveragedProjectDiscoveryImpl.rounded(Math.sqrt(variance));
    }

    @Override
    public double getSaveTimeStandardDeviation() {
        if (this.getOccurrences().isEmpty()) {
            return 0.0;
        }
        double squareDiffsSum = 0.0;
        double average = this.getAverageSaveTimeInSeconds();
        for (ProjectDiscovery discovery : this.getOccurrences()) {
            double diff = discovery.getSaveTimeInSeconds() - average;
            squareDiffsSum += diff * diff;
        }
        double variance = squareDiffsSum / (double)this.getOccurrences().size();
        return AveragedProjectDiscoveryImpl.rounded(Math.sqrt(variance));
    }

    @Override
    public EList<ProjectDiscovery> getOccurrences() {
        if (this.occurrences == null) {
            this.occurrences = new EObjectContainmentEList(ProjectDiscovery.class, (InternalEObject)this, 4);
        }
        return this.occurrences;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getOccurrences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAverageExecutionTimeInSeconds();
            }
            case 1: {
                return this.getAverageSaveTimeInSeconds();
            }
            case 2: {
                return this.getExecutionTimeStandardDeviation();
            }
            case 3: {
                return this.getSaveTimeStandardDeviation();
            }
            case 4: {
                return this.getOccurrences();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.getOccurrences().clear();
                this.getOccurrences().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.getOccurrences().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getAverageExecutionTimeInSeconds() != 0.0;
            }
            case 1: {
                return this.getAverageSaveTimeInSeconds() != 0.0;
            }
            case 2: {
                return this.getExecutionTimeStandardDeviation() != 0.0;
            }
            case 3: {
                return this.getSaveTimeStandardDeviation() != 0.0;
            }
            case 4: {
                return this.occurrences != null && !this.occurrences.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

