/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.util.emf.core.IBrowserRegistry;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.core.internal.catalog.DiscovererRegistry;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.dialogs.GenericParametersDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoDiscoMenuSelectionListener
implements SelectionListener {
    private final DiscovererDescription fDiscovererDesc;
    private final Object[] fSources;
    private final Shell shell;

    public MoDiscoMenuSelectionListener(DiscovererDescription discoverer, Object[] sourceParameter, Shell shell) {
        this.fDiscovererDesc = discoverer;
        this.fSources = sourceParameter;
        this.shell = shell;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object[] sources;
        final IDiscoverer discoverer = IDiscoveryManager.INSTANCE.createDiscovererImpl(this.fDiscovererDesc);
        Object[] objectArray = sources = this.fSources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            final Object source = objectArray[n2];
            final ParamsDialogResult paramsDialogResult = this.chooseParameters(discoverer, source);
            if (paramsDialogResult.isCancelled()) {
                return;
            }
            String name = this.getDiscoverer().getId();
            Job job = new Job(NLS.bind((String)Messages.MoDiscoMenuSelectionListener_modiscoDiscovererJobLabel, (Object)name)){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.MoDiscoMenuSelectionListener_discovering, sources.length * 2);
                    Map<DiscovererParameter, Object> parameterValues = paramsDialogResult.getParameterValues();
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    MoDiscoMenuSelectionListener.this.discovererElement(source, parameterValues, discoverer, monitor);
                    monitor.worked(1);
                    if (paramsDialogResult.isOpenModel()) {
                        MoDiscoMenuSelectionListener.openModelEditor(discoverer);
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.setUser(true);
            job.schedule();
            ++n2;
        }
    }

    protected static void openModelEditor(IDiscoverer<?> discoverer) {
        AbstractModelDiscoverer modelDiscoverer;
        Resource targetModel;
        if (discoverer instanceof AbstractModelDiscoverer && (targetModel = (modelDiscoverer = (AbstractModelDiscoverer)discoverer).getTargetModel()) != null) {
            if (targetModel.getURI() == null) {
                DiscovererDescription discovererDescription = IDiscoveryManager.INSTANCE.getDiscovererDescription(discoverer);
                targetModel.setURI(URI.createURI((String)("temp:/" + discovererDescription.getId() + "/" + System.currentTimeMillis())));
            }
            IBrowserRegistry.INSTANCE.browseResource(targetModel);
        }
    }

    private ParamsDialogResult chooseParameters(IDiscoverer<?> discoverer, Object source) {
        List<DiscovererParameter> inParameters = MoDiscoMenuSelectionListener.getExpectedInputParameters(this.fDiscovererDesc);
        if (inParameters.isEmpty()) {
            return new ParamsDialogResult(new HashMap<DiscovererParameter, Object>(), true, false);
        }
        LaunchConfiguration configurationModel = this.getLaunchConfigurationModel(source);
        boolean showOpenModelCheckbox = discoverer instanceof AbstractModelDiscoverer;
        GenericParametersDialog genericParametersDialog = new GenericParametersDialog(this.shell, inParameters, this.getDiscoverer().getId(), showOpenModelCheckbox, configurationModel);
        int result = genericParametersDialog.open();
        if (result == 0) {
            Object[] parameterValues = genericParametersDialog.getParameterValues();
            assert (parameterValues.length == inParameters.size());
            HashMap<DiscovererParameter, Object> parameterValuesMap = new HashMap<DiscovererParameter, Object>();
            int i = 0;
            while (i < inParameters.size()) {
                DiscovererParameter parameter = inParameters.get(i);
                parameterValuesMap.put(parameter, parameterValues[i]);
                ++i;
            }
            this.saveParameters(parameterValuesMap, genericParametersDialog.isOpenModel());
            return new ParamsDialogResult(parameterValuesMap, genericParametersDialog.isOpenModel(), false);
        }
        return new ParamsDialogResult(null, false, true);
    }

    private void saveParameters(Map<DiscovererParameter, Object> parameterValuesMap, boolean openModel) {
        if (this.fSources.length != 1) {
            return;
        }
        Object source = this.fSources[0];
        LaunchConfiguration launchConfiguration = this.getLaunchConfigurationModel(source);
        IResource iResource = MoDiscoMenuSelectionListener.getIResourceFromSource(source);
        if (iResource == null) {
            return;
        }
        launchConfiguration.setDiscoverer(this.fDiscovererDesc);
        launchConfiguration.setSource((Object)iResource);
        launchConfiguration.setOpenModelAfterDiscovery(openModel);
        launchConfiguration.getParameterValues().clear();
        for (Map.Entry<DiscovererParameter, Object> entry : parameterValuesMap.entrySet()) {
            ParameterValue parameterValue = LaunchFactory.eINSTANCE.createParameterValue();
            parameterValue.setParameter(entry.getKey());
            parameterValue.setValue(entry.getValue());
            launchConfiguration.getParameterValues().add((Object)parameterValue);
        }
        try {
            launchConfiguration.eResource().save(Collections.emptyMap());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private LaunchConfiguration getLaunchConfigurationModel(Object source) {
        if (this.fDiscovererDesc == null || this.fDiscovererDesc.getId() == null) {
            return null;
        }
        IResource iresource = MoDiscoMenuSelectionListener.getIResourceFromSource(source);
        IPath stateLocation = Activator.getDefault().getStateLocation();
        IPath launchParametersFile = stateLocation.append("launchParameters");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI resourceURI = URI.createFileURI((String)launchParametersFile.toOSString());
        Resource resource = new File(launchParametersFile.toOSString()).exists() ? resourceSet.getResource(resourceURI, true) : resourceSet.createResource(resourceURI);
        EList registryResources = DiscovererRegistry.INSTANCE.getResourceSet().getResources();
        if (!registryResources.contains((Object)resource)) {
            registryResources.add((Object)resource);
        }
        if (iresource != null) {
            EList contents = resource.getContents();
            for (EObject eObject : contents) {
                if (eObject instanceof LaunchConfiguration) {
                    LaunchConfiguration launchConfiguration = (LaunchConfiguration)eObject;
                    DiscovererDescription discoverer = launchConfiguration.getDiscoverer();
                    if (discoverer == null) continue;
                    String discovererID = discoverer.getId();
                    if (this.fDiscovererDesc.getId() != discovererID || !iresource.equals(launchConfiguration.getSource())) continue;
                    return launchConfiguration;
                }
                MoDiscoLogger.logError((String)("expected " + LaunchConfiguration.class.getSimpleName()), (Plugin)Activator.getDefault());
            }
        }
        LaunchConfiguration launchConfiguration = LaunchFactory.eINSTANCE.createLaunchConfiguration();
        launchConfiguration.setOpenModelAfterDiscovery(true);
        resource.getContents().add((Object)launchConfiguration);
        EList parameters = this.fDiscovererDesc.getParameterDefinitions();
        for (DiscovererParameter parameter : parameters) {
            if (!IDiscoveryManager.INSTANCE.hasInitialValue(parameter, this.fDiscovererDesc)) continue;
            try {
                Object initialValue = IDiscoveryManager.INSTANCE.getInitialValue(parameter, this.fDiscovererDesc, source);
                ParameterValue parameterValue = LaunchFactory.eINSTANCE.createParameterValue();
                parameterValue.setParameter(parameter);
                parameterValue.setValue(initialValue);
                launchConfiguration.getParameterValues().add((Object)parameterValue);
            }
            catch (DiscoveryException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return launchConfiguration;
    }

    private static IResource getIResourceFromSource(Object source) {
        IResource iresource = null;
        iresource = source instanceof IResource ? (IResource)source : (IResource)Platform.getAdapterManager().getAdapter(source, IResource.class);
        if (iresource == null) {
            return null;
        }
        return iresource;
    }

    protected void discovererElement(Object element, Map<DiscovererParameter, Object> parameterValues, IDiscoverer<?> discoverer, IProgressMonitor monitor) {
        try {
            for (Map.Entry<DiscovererParameter, Object> paramEntry : parameterValues.entrySet()) {
                DiscovererParameter parameter = paramEntry.getKey();
                Object value = paramEntry.getValue();
                if (value == null) continue;
                IDiscoveryManager.INSTANCE.setValue(parameter, discoverer, value);
            }
            IDiscoverer<?> objectDiscoverer = discoverer;
            DiscovererDescription discovererDescription = IDiscoveryManager.INSTANCE.getDiscovererDescription(discoverer);
            String name = discovererDescription != null ? discovererDescription.getId() : discoverer.getClass().getName();
            monitor.beginTask(NLS.bind((String)Messages.MoDiscoMenuSelectionListener_discoveringModel, (Object)name), -1);
            objectDiscoverer.discoverElement(element, monitor);
        }
        catch (DiscoveryException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error in discovery", (Plugin)Activator.getDefault());
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)MoDiscoMenuSelectionListener.this.shell, (String)Messages.MoDiscoMenuSelectionListener_discoveryError, (String)NLS.bind((String)Messages.MoDiscoMenuSelectionListener_errorInDiscovery, (Object)e.getLocalizedMessage()));
                }
            });
        }
    }

    protected DiscovererDescription getDiscoverer() {
        return this.fDiscovererDesc;
    }

    protected static List<DiscovererParameter> getExpectedInputParameters(DiscovererDescription discoverer) {
        ArrayList<DiscovererParameter> inParameters = new ArrayList<DiscovererParameter>();
        EList params = discoverer.getParameterDefinitions();
        for (DiscovererParameter param : params) {
            if (param.getDirection() != DirectionKind.IN && param.getDirection() != DirectionKind.INOUT) continue;
            inParameters.add(param);
        }
        return inParameters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParamsDialogResult {
        private final Map<DiscovererParameter, Object> parameterValues;
        private final boolean openModel;
        private final boolean cancelled;

        public ParamsDialogResult(Map<DiscovererParameter, Object> parameterValues, boolean openModel, boolean cancelled) {
            this.parameterValues = parameterValues;
            this.openModel = openModel;
            this.cancelled = cancelled;
        }

        public Map<DiscovererParameter, Object> getParameterValues() {
            return this.parameterValues;
        }

        public boolean isOpenModel() {
            return this.openModel;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

