/**
 * Copyright (c) 2009, 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 *     Gregoire DUPE (Mia-Software) - Bug 341752 - Extract report metamodel from the benchmark plug-in to avoid Acceleo troubles.
 *     Nicolas Bros (Mia-Software)
 * 
 */
package org.eclipse.modisco.infra.discovery.benchmark.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.modisco.infra.discovery.benchmark.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.modisco.infra.discovery.benchmark.BenchmarkPackage
 * @generated
 */
public class BenchmarkSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static BenchmarkPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BenchmarkSwitch() {
		if (modelPackage == null) {
			modelPackage = BenchmarkPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case BenchmarkPackage.BENCHMARK: {
				Benchmark benchmark = (Benchmark)theEObject;
				T result = caseBenchmark(benchmark);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.DISCOVERY: {
				Discovery discovery = (Discovery)theEObject;
				T result = caseDiscovery(discovery);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.PROJECT: {
				Project project = (Project)theEObject;
				T result = caseProject(project);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.FILE: {
				File file = (File)theEObject;
				T result = caseFile(file);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.MULTI_PROJECT_BENCHMARK: {
				MultiProjectBenchmark multiProjectBenchmark = (MultiProjectBenchmark)theEObject;
				T result = caseMultiProjectBenchmark(multiProjectBenchmark);
				if (result == null) result = caseBenchmark(multiProjectBenchmark);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.MULTI_DISCOVERY_BENCHMARK: {
				MultiDiscoveryBenchmark multiDiscoveryBenchmark = (MultiDiscoveryBenchmark)theEObject;
				T result = caseMultiDiscoveryBenchmark(multiDiscoveryBenchmark);
				if (result == null) result = caseBenchmark(multiDiscoveryBenchmark);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.PROJECT_DISCOVERY: {
				ProjectDiscovery projectDiscovery = (ProjectDiscovery)theEObject;
				T result = caseProjectDiscovery(projectDiscovery);
				if (result == null) result = caseDiscovery(projectDiscovery);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.DISCOVERED_PROJECT: {
				DiscoveredProject discoveredProject = (DiscoveredProject)theEObject;
				T result = caseDiscoveredProject(discoveredProject);
				if (result == null) result = caseProject(discoveredProject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.AVERAGED_MULTI_DISCOVERY_BENCHMARK: {
				AveragedMultiDiscoveryBenchmark averagedMultiDiscoveryBenchmark = (AveragedMultiDiscoveryBenchmark)theEObject;
				T result = caseAveragedMultiDiscoveryBenchmark(averagedMultiDiscoveryBenchmark);
				if (result == null) result = caseBenchmark(averagedMultiDiscoveryBenchmark);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BenchmarkPackage.AVERAGED_PROJECT_DISCOVERY: {
				AveragedProjectDiscovery averagedProjectDiscovery = (AveragedProjectDiscovery)theEObject;
				T result = caseAveragedProjectDiscovery(averagedProjectDiscovery);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Benchmark</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Benchmark</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBenchmark(Benchmark object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Discovery</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Discovery</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDiscovery(Discovery object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Project</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Project</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProject(Project object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>File</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>File</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFile(File object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Multi Project Benchmark</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Multi Project Benchmark</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMultiProjectBenchmark(MultiProjectBenchmark object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Multi Discovery Benchmark</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Multi Discovery Benchmark</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMultiDiscoveryBenchmark(MultiDiscoveryBenchmark object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Project Discovery</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Project Discovery</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProjectDiscovery(ProjectDiscovery object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Discovered Project</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Discovered Project</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDiscoveredProject(DiscoveredProject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Averaged Multi Discovery Benchmark</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Averaged Multi Discovery Benchmark</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAveragedMultiDiscoveryBenchmark(AveragedMultiDiscoveryBenchmark object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Averaged Project Discovery</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Averaged Project Discovery</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAveragedProjectDiscovery(AveragedProjectDiscovery object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //BenchmarkSwitch
