/**
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fabien Giquel (Mia-Software) - design and implementation
 * 
 */
package org.eclipse.modisco.infra.discovery.launch.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.modisco.infra.discovery.launch.*;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializationRegistry;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializer;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.Activator;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.LaunchPackage;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class LaunchFactoryImpl extends EFactoryImpl implements LaunchFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public static LaunchFactory init() {
		try {
			LaunchFactory theLaunchFactory = (LaunchFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/MoDisco/Discovery/0.1.incubation/discovery/launch"); 
			if (theLaunchFactory != null) {
				return theLaunchFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new LaunchFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public LaunchFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case LaunchPackage.LAUNCH_CONFIGURATION: return createLaunchConfiguration();
			case LaunchPackage.PARAMETER_VALUE: return createParameterValue();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LaunchConfiguration createLaunchConfiguration() {
		LaunchConfigurationImpl launchConfiguration = new LaunchConfigurationImpl();
		return launchConfiguration;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ParameterValue createParameterValue() {
		ParameterValueImpl parameterValue = new ParameterValueImpl();
		return parameterValue;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Object createValueDataTypeFromString(final EDataType eDataType,
			final String initialValue) {
		try {
			if ("null".equals(initialValue)) {
				return null;
			}

			int colonPos = initialValue.indexOf(':');
			if (colonPos == -1) {
				throw new IllegalArgumentException(
						"invalid serialization format");
			}
			String type = initialValue.substring(0, colonPos);
			String strValue = initialValue.substring(colonPos + 1);

			ISerializer<?> serializer = ISerializationRegistry.INSTANCE
					.getSerializerFor(type);
			if (serializer != null) {
				Object value = serializer.deserialize(strValue);
				return value;
			}

			MoDiscoLogger.logError("deserialization of type " + type
					+ " is not implemented.", Activator.getDefault());
		} catch (Exception e) {
			MoDiscoLogger.logError(e, "Error deserializing: " + initialValue,
					Activator.getDefault());
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public String convertValueDataTypeToString(final EDataType eDataType,
			final Object instanceValue) {

		if (instanceValue == null) {
			return "null";
		}

		ISerializer serializer = ISerializationRegistry.INSTANCE
				.getSerializerFor(instanceValue.getClass());
		if (serializer != null) {
			return serializer.getType().getName() + ":"
					+ serializer.serialize(instanceValue);
		}

		MoDiscoLogger.logError(
				"serialization of type " + instanceValue.getClass().getName()
						+ " is not implemented.", Activator.getDefault());
		return "null";
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LaunchPackage getLaunchPackage() {
		return (LaunchPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static LaunchPackage getPackage() {
		return LaunchPackage.eINSTANCE;
	}

} // LaunchFactoryImpl
