/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.benchmark.javaBenchmark.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.modisco.infra.discovery.benchmark.File;
import org.eclipse.modisco.infra.discovery.benchmark.Project;
import org.eclipse.modisco.java.discoverer.benchmark.javaBenchmark.JavaBenchmarkPackage;
import org.eclipse.modisco.java.discoverer.benchmark.javaBenchmark.JavaProject;
import org.eclipse.modisco.java.discoverer.benchmark.javaBenchmark.impl.AbstractJavaProjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectImpl
extends AbstractJavaProjectImpl
implements JavaProject {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final long TOTAL_LINES_EDEFAULT = 0L;
    protected EList<File> files;
    protected static final long AVERAGE_FILE_SIZE_IN_BYTES_EDEFAULT = 0L;
    protected static final long AVERAGE_LINES_PER_FILE_EDEFAULT = 0L;
    protected static final long TOTAL_SIZE_IN_BYTES_EDEFAULT = 0L;

    protected JavaProjectImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return JavaBenchmarkPackage.Literals.JAVA_PROJECT;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    public long getTotalLines() {
        long lines = 0L;
        for (File file : this.getFiles()) {
            lines += file.getLines();
        }
        return lines;
    }

    public EList<File> getFiles() {
        if (this.files == null) {
            this.files = new EObjectContainmentEList(File.class, (InternalEObject)this, 3);
        }
        return this.files;
    }

    public long getAverageFileSizeInBytes() {
        return this.getFiles().size() != 0 ? this.getTotalSizeInBytes() / (long)this.getFiles().size() : 0L;
    }

    public long getAverageLinesPerFile() {
        return this.getFiles().size() != 0 ? this.getTotalLines() / (long)this.getFiles().size() : 0L;
    }

    public long getTotalSizeInBytes() {
        long totalSize = 0L;
        for (File file : this.getFiles()) {
            totalSize += file.getSizeInBytes();
        }
        return totalSize;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getTotalLines();
            }
            case 3: {
                return this.getFiles();
            }
            case 4: {
                return this.getAverageFileSizeInBytes();
            }
            case 5: {
                return this.getAverageLinesPerFile();
            }
            case 6: {
                return this.getTotalSizeInBytes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getFiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.getTotalLines() != 0L;
            }
            case 3: {
                return this.files != null && !this.files.isEmpty();
            }
            case 4: {
                return this.getAverageFileSizeInBytes() != 0L;
            }
            case 5: {
                return this.getAverageLinesPerFile() != 0L;
            }
            case 6: {
                return this.getTotalSizeInBytes() != 0L;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == Project.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == Project.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

