/*
 * Decompiled with CFR 0.152.
 */
package prefuse.activity;

import java.util.HashMap;
import prefuse.activity.Activity;
import prefuse.activity.ActivityManager;

public class ActivityMap {
    private HashMap m_map = new HashMap();
    private ActivityMap m_parent;

    public ActivityMap() {
        this(null);
    }

    public ActivityMap(ActivityMap parent) {
        this.m_parent = parent;
    }

    public void clear() {
        this.m_map.clear();
    }

    public int size() {
        return this.m_map.size();
    }

    public Activity get(String key) {
        Activity a = (Activity)this.m_map.get(key);
        return a == null && this.m_parent != null ? this.m_parent.get(key) : a;
    }

    public Activity runAt(String key, long time) {
        Activity a = this.get(key);
        if (a != null) {
            ActivityManager.scheduleAt(a, time);
        }
        return a;
    }

    public Activity run(String key) {
        Activity a = this.get(key);
        if (a != null) {
            ActivityManager.scheduleNow(a);
        }
        return a;
    }

    public Activity runAfter(String beforeKey, String afterKey) {
        Activity before = this.get(beforeKey);
        Activity after = this.get(afterKey);
        if (before != null && after != null) {
            ActivityManager.scheduleAfter(before, after);
        }
        return after;
    }

    public Activity alwaysRunAfter(String beforeKey, String afterKey) {
        Activity before = this.get(beforeKey);
        Activity after = this.get(afterKey);
        if (before != null && after != null) {
            ActivityManager.alwaysScheduleAfter(before, after);
        }
        return after;
    }

    public Activity cancel(String key) {
        Activity a = this.get(key);
        if (a != null) {
            a.cancel();
        }
        return a;
    }

    public Activity put(String key, Activity activity) {
        return this.m_map.put(key, activity);
    }

    public void remove(Object key) {
        this.m_map.remove(key);
    }

    public Object[] keys() {
        return this.m_map.keySet().toArray();
    }

    public Object[] allKeys() {
        Object[] a2;
        Object[] a1 = this.m_map.keySet().toArray();
        if (this.m_parent != null && (a2 = this.m_parent.allKeys()) != null && a2.length > 0) {
            Object[] o = new Object[a1.length + a2.length];
            System.arraycopy(a1, 0, o, 0, a1.length);
            System.arraycopy(a2, 0, o, a1.length, a2.length);
            return o;
        }
        return a1;
    }

    public void setParent(ActivityMap parent) {
        this.m_parent = parent;
    }

    public ActivityMap getParent() {
        return this.m_parent;
    }
}

