/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class DoubleParser
implements DataParser {
    private boolean m_blockExplicitFloats = true;

    public Class getType() {
        return Double.TYPE;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)value).doubleValue());
    }

    public boolean canParse(String text) {
        block3: {
            try {
                if (!this.m_blockExplicitFloats || !text.endsWith("f")) break block3;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        Double.parseDouble(text);
        return true;
    }

    public Object parse(String text) throws DataParseException {
        return new Double(DoubleParser.parseDouble(text));
    }

    public static double parseDouble(String text) throws DataParseException {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

