/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.impl.FeatureCallExpImpl;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCallExpImpl
extends FeatureCallExpImpl
implements OperationCallExp {
    protected EList<OCLExpression<EClassifier>> argument;
    protected EOperation referredOperation;
    protected static final int OPERATION_CODE_EDEFAULT = 0;
    private int operationCode = -1;

    protected OperationCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return EcorePackage.Literals.OPERATION_CALL_EXP;
    }

    public EList<OCLExpression<EClassifier>> getArgument() {
        if (this.argument == null) {
            this.argument = new EObjectContainmentEList(OCLExpression.class, (InternalEObject)this, 16);
        }
        return this.argument;
    }

    public EOperation getReferredOperation() {
        if (this.referredOperation != null && this.referredOperation.eIsProxy()) {
            InternalEObject oldReferredOperation = (InternalEObject)this.referredOperation;
            this.referredOperation = (EOperation)this.eResolveProxy(oldReferredOperation);
            if (this.referredOperation != oldReferredOperation && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 17, (Object)oldReferredOperation, (Object)this.referredOperation));
            }
        }
        return this.referredOperation;
    }

    public EOperation basicGetReferredOperation() {
        return this.referredOperation;
    }

    public void setReferredOperation(EOperation newReferredOperation) {
        EOperation oldReferredOperation = this.referredOperation;
        this.referredOperation = newReferredOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldReferredOperation, (Object)this.referredOperation));
        }
    }

    public int getOperationCode() {
        if (this.operationCode < 0) {
            if (this.getSource() != null && this.getReferredOperation() != null) {
                Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this.getSource());
                EClassifier type = (EClassifier)this.getSource().getType();
                String operName = env.getUMLReflection().getName((Object)this.getReferredOperation());
                if (type instanceof PredefinedType) {
                    this.operationCode = OCLStandardLibraryUtil.getOperationCode((String)operName);
                } else if (TypeUtil.isOclAnyOperation((Environment)env, (Object)this.getReferredOperation())) {
                    this.operationCode = OCLStandardLibraryUtil.getOclAnyOperationCode((String)operName);
                }
            } else {
                this.operationCode = 0;
            }
        }
        return this.operationCode;
    }

    public void setOperationCode(int newOperationCode) {
        this.operationCode = newOperationCode;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 16: {
                return ((InternalEList)this.getArgument()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getArgument();
            }
            case 17: {
                if (resolve) {
                    return this.getReferredOperation();
                }
                return this.basicGetReferredOperation();
            }
            case 18: {
                return new Integer(this.getOperationCode());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.getArgument().clear();
                this.getArgument().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.setReferredOperation((EOperation)newValue);
                return;
            }
            case 18: {
                this.setOperationCode((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.getArgument().clear();
                return;
            }
            case 17: {
                this.setReferredOperation(null);
                return;
            }
            case 18: {
                this.setOperationCode(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.argument != null && !this.argument.isEmpty();
            }
            case 17: {
                return this.referredOperation != null;
            }
            case 18: {
                return this.getOperationCode() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == org.eclipse.ocl.expressions.OperationCallExp.class) {
            switch (derivedFeatureID) {
                case 16: {
                    return 6;
                }
                case 17: {
                    return 7;
                }
                case 18: {
                    return 8;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == org.eclipse.ocl.expressions.OperationCallExp.class) {
            switch (baseFeatureID) {
                case 6: {
                    return 16;
                }
                case 7: {
                    return 17;
                }
                case 8: {
                    return 18;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public <T, U extends Visitor<T, ?, ?, ?, ?, ?, ?, ?, ?, ?>> T accept(U v) {
        return (T)v.visitOperationCallExp((org.eclipse.ocl.expressions.OperationCallExp)this);
    }
}

