/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.impl.LiteralExpImpl;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionLiteralExpImpl<C>
extends LiteralExpImpl<C>
implements CollectionLiteralExp<C> {
    protected static final CollectionKind KIND_EDEFAULT = CollectionKind.SET_LITERAL;
    protected CollectionKind kind = KIND_EDEFAULT;
    protected EList<CollectionLiteralPart<C>> part;
    protected static final boolean SIMPLE_RANGE_EDEFAULT = false;

    protected CollectionLiteralExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ExpressionsPackage.Literals.COLLECTION_LITERAL_EXP;
    }

    @Override
    public CollectionKind getKind() {
        return this.kind;
    }

    @Override
    public void setKind(CollectionKind newKind) {
        CollectionKind oldKind = this.kind;
        CollectionKind collectionKind = this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldKind, (Object)this.kind));
        }
    }

    @Override
    public EList<CollectionLiteralPart<C>> getPart() {
        if (this.part == null) {
            this.part = new EObjectContainmentEList(CollectionLiteralPart.class, (InternalEObject)this, 3);
        }
        return this.part;
    }

    @Override
    public boolean isSimpleRange() {
        EList<CollectionLiteralPart<C>> partsList = this.getPart();
        int size = partsList.size();
        if (size == 1) {
            CollectionLiteralPart part = (CollectionLiteralPart)partsList.get(0);
            return part instanceof CollectionRange;
        }
        return false;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getPart()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getKind();
            }
            case 3: {
                return this.getPart();
            }
            case 4: {
                return this.isSimpleRange() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setKind((CollectionKind)((Object)newValue));
                return;
            }
            case 3: {
                this.getPart().clear();
                this.getPart().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setKind(KIND_EDEFAULT);
                return;
            }
            case 3: {
                this.getPart().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.kind != KIND_EDEFAULT;
            }
            case 3: {
                return this.part != null && !this.part.isEmpty();
            }
            case 4: {
                return this.isSimpleRange();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <T, U extends Visitor<T, ?, ?, ?, ?, ?, ?, ?, ?, ?>> T accept(U v) {
        return v.visitCollectionLiteralExp(this);
    }
}

