/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.internal.parser.OCLParser;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.util.UnicodeSupport;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
implements Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static int generatorInt = 0;
    private AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent;
    private PK contextPackage;
    private O contextOperation;
    private P contextProperty;
    private List<VariableEntry> namedElements = new ArrayList<VariableEntry>();
    private Variable<C, PM> selfVariable;
    private Map<O, CT> operationBodies = new HashMap<O, CT>();
    private Map<P, CT> propertyInitializers = new HashMap<P, CT>();
    private Map<P, CT> propertyDerivations = new HashMap<P, CT>();

    protected AbstractEnvironment() {
    }

    protected AbstractEnvironment(AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent) {
        this.parent = parent;
    }

    private synchronized String generateName() {
        return "temp" + ++generatorInt;
    }

    @Override
    public AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getParent() {
        return this.parent;
    }

    @Override
    protected void setParent(AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent) {
        this.parent = parent;
    }

    @Override
    public PK getContextPackage() {
        if (this.contextPackage != null) {
            return this.contextPackage;
        }
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getContextPackage();
        }
        return null;
    }

    protected void setContextPackage(PK contextPackage) {
        this.contextPackage = contextPackage;
    }

    @Override
    public C getContextClassifier() {
        return this.getSelfVariable().getType();
    }

    @Override
    public O getContextOperation() {
        if (this.contextOperation != null) {
            return this.contextOperation;
        }
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getContextOperation();
        }
        return null;
    }

    protected void setContextOperation(O contextOperation) {
        this.contextOperation = contextOperation;
    }

    @Override
    public P getContextProperty() {
        if (this.contextProperty != null) {
            return this.contextProperty;
        }
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getContextProperty();
        }
        return null;
    }

    protected void setContextProperty(P contextProperty) {
        this.contextProperty = contextProperty;
    }

    protected Resource getResource() {
        return this.getTypeResolver().getResource();
    }

    @Override
    public boolean isEmpty() {
        return this.namedElements.isEmpty();
    }

    @Override
    public Collection<Variable<C, PM>> getVariables() {
        ArrayList<Variable<C, PM>> result = new ArrayList<Variable<C, PM>>();
        int i = 0;
        while (i < this.namedElements.size()) {
            VariableEntry elem = this.namedElements.get(i);
            if (elem.isExplicit) {
                result.add(elem.variable);
            }
            ++i;
        }
        if (this.getParent() != null) {
            for (Variable<C, PM> parentVar : ((AbstractEnvironment)this.getParent()).getVariables()) {
                if (this.lookupLocal(parentVar.getName()) != null) continue;
                result.add(parentVar);
            }
        }
        return result;
    }

    @Override
    public boolean addElement(String name, Variable<C, PM> elem, boolean isExplicit) {
        if (name == null) {
            name = this.generateName();
            while (this.lookup(name) != null) {
                name = this.generateName();
            }
        } else if (this.lookupLocal(name) != null) {
            return false;
        }
        this.getUMLReflection().setName(elem, name);
        VariableEntry newelem = new VariableEntry(name, elem, isExplicit);
        this.namedElements.add(newelem);
        this.addedVariable(name, elem, isExplicit);
        return true;
    }

    protected void addedVariable(String name, Variable<C, PM> variable, boolean isExplicit) {
        this.getResource().getContents().add(variable);
    }

    @Override
    public void deleteElement(String name) {
        Iterator<VariableEntry> iter = this.namedElements.iterator();
        while (iter.hasNext()) {
            VariableEntry elem = iter.next();
            if (!elem.name.equals(name)) continue;
            iter.remove();
            this.removedVariable(name, elem.variable, elem.isExplicit);
        }
    }

    protected void removedVariable(String name, Variable<C, PM> variable, boolean isExplicit) {
        this.getResource().getContents().remove(variable);
    }

    @Override
    public void setSelfVariable(Variable<C, PM> var) {
        C contextClassifier;
        this.selfVariable = var;
        if (this.getContextPackage() == null && (contextClassifier = this.getContextClassifier()) != null) {
            this.setContextPackage(this.getUMLReflection().getPackage(contextClassifier));
        }
    }

    @Override
    public Variable<C, PM> getSelfVariable() {
        Variable<C, PM> result = this.selfVariable;
        if (result == null && this.getParent() != null) {
            result = ((AbstractEnvironment)this.getParent()).getSelfVariable();
        }
        return result;
    }

    protected void addProperty(C owner, P property) {
        if (this.getParent() != null) {
            ((AbstractEnvironment)this.getParent()).addProperty(owner, property);
        } else {
            this.getTypeResolver().resolveAdditionalAttribute(owner, property);
        }
    }

    @Override
    public List<P> getAdditionalAttributes(C classifier) {
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getAdditionalAttributes(classifier);
        }
        ArrayList result = null;
        TypeResolver res = this.getTypeResolver();
        List additionals = res.getAdditionalAttributes(classifier);
        if (!additionals.isEmpty()) {
            result = new ArrayList(additionals);
        }
        for (Object general : this.getUMLReflection().getAllSupertypes(classifier)) {
            additionals = res.getAdditionalAttributes(general);
            if (additionals.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList(additionals);
                continue;
            }
            result.addAll(additionals);
        }
        return result;
    }

    protected void addOperation(C owner, O operation) {
        if (this.getParent() != null) {
            ((AbstractEnvironment)this.getParent()).addOperation(owner, operation);
        } else {
            this.getTypeResolver().resolveAdditionalOperation(owner, operation);
        }
    }

    @Override
    public List<O> getAdditionalOperations(C classifier) {
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getAdditionalOperations(classifier);
        }
        ArrayList result = null;
        TypeResolver res = this.getTypeResolver();
        List additionals = res.getAdditionalOperations(classifier);
        if (!additionals.isEmpty()) {
            result = new ArrayList(additionals);
        }
        for (Object general : this.getUMLReflection().getAllSupertypes(classifier)) {
            additionals = res.getAdditionalOperations(general);
            if (additionals.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList(additionals);
                continue;
            }
            result.addAll(additionals);
        }
        return result;
    }

    @Override
    public void setInitConstraint(P property, CT constraint) {
        if (this.getParent() != null) {
            ((AbstractEnvironment)this.getParent()).setInitConstraint(property, constraint);
        } else {
            this.propertyInitializers.put(property, constraint);
        }
    }

    @Override
    public CT getInitConstraint(P property) {
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getInitConstraint(property);
        }
        return this.propertyInitializers.get(property);
    }

    @Override
    public void setDeriveConstraint(P property, CT constraint) {
        if (this.getParent() != null) {
            ((AbstractEnvironment)this.getParent()).setDeriveConstraint(property, constraint);
        } else {
            this.propertyDerivations.put(property, constraint);
        }
    }

    @Override
    public CT getDeriveConstraint(P property) {
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getDeriveConstraint(property);
        }
        return this.propertyDerivations.get(property);
    }

    @Override
    public void setBodyCondition(O operation, CT constraint) {
        if (this.getParent() != null) {
            ((AbstractEnvironment)this.getParent()).setBodyCondition(operation, constraint);
        } else {
            this.operationBodies.put(operation, constraint);
        }
    }

    @Override
    public CT getBodyCondition(O operation) {
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).getBodyCondition(operation);
        }
        return this.operationBodies.get(operation);
    }

    @Override
    public Variable<C, PM> lookupLocal(String name) {
        Variable<C, PM> result = this.doLookupLocal(name);
        if (result == null && OCLParser.isEscaped(name)) {
            result = this.doLookupLocal(OCLParser.unescape(name));
        }
        return result;
    }

    private Variable<C, PM> doLookupLocal(String name) {
        int i = 0;
        while (i < this.namedElements.size()) {
            VariableEntry elem = this.namedElements.get(i);
            if (elem.name.equals(name)) {
                return elem.variable;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookup(String name) {
        Variable<C, PM> elem = this.lookupLocal(name);
        if (elem != null) {
            return elem;
        }
        if (this.getParent() != null) {
            return ((AbstractEnvironment)this.getParent()).lookup(name);
        }
        return null;
    }

    @Override
    public O lookupOperation(C owner, String name, List<? extends TypedElement<C>> args) {
        O result = this.doLookupOperation(owner, name, args);
        if (result == null && OCLParser.isEscaped(name)) {
            result = this.doLookupOperation(owner, OCLParser.unescape(name), args);
        }
        return result;
    }

    private O doLookupOperation(C owner, String name, List<? extends TypedElement<C>> args) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForOperation(name, args);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        return TypeUtil.findOperationMatching(this, owner, name, args);
    }

    @Override
    public P lookupProperty(C owner, String name) {
        P result = this.doLookupProperty(owner, name);
        if (result == null && OCLParser.isEscaped(name)) {
            result = this.doLookupProperty(owner, OCLParser.unescape(name));
        }
        return result;
    }

    private P doLookupProperty(C owner, String name) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForProperty(name);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        List properties = TypeUtil.getAttributes(this, owner);
        for (Object property : properties) {
            if (!name.equals(this.getUMLReflection().getName(property))) continue;
            return property;
        }
        return null;
    }

    @Override
    public C lookupAssociationClassReference(C owner, String name) {
        C result = this.doLookupAssociationClassReference(owner, name);
        if (result == null && OCLParser.isEscaped(name)) {
            result = this.doLookupAssociationClassReference(owner, OCLParser.unescape(name));
        }
        return result;
    }

    private C doLookupAssociationClassReference(C owner, String name) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForAssociationClass(name);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        C result = null;
        List properties = this.getUMLReflection().getAttributes(owner);
        Iterator iter = properties.iterator();
        while (result == null && iter.hasNext()) {
            Object next = iter.next();
            Object assocClass = this.getUMLReflection().getAssociationClass(next);
            if (assocClass == null || !name.equals(this.initialLower(assocClass))) continue;
            result = assocClass;
        }
        return result;
    }

    @Override
    public C lookupSignal(C owner, String name, List<? extends TypedElement<C>> args) {
        C result = this.doLookupSignal(owner, name, args);
        if (result == null && OCLParser.isEscaped(name)) {
            result = this.doLookupSignal(owner, OCLParser.unescape(name), args);
        }
        return result;
    }

    private C doLookupSignal(C owner, String name, List<? extends TypedElement<C>> args) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForSignal(name, args);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        return TypeUtil.findSignalMatching(this, owner, this.getUMLReflection().getSignals(owner), name, args);
    }

    @Override
    public S lookupState(C owner, List<String> path) throws SemanticException {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForState(path);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        int lastIndex = path.size() - 1;
        String lastName = path.get(lastIndex);
        List states = this.getStates(owner, path.subList(0, lastIndex));
        S result = null;
        for (Object next : states) {
            String nextName = this.getUMLReflection().getName(next);
            boolean matched = lastName.equals(nextName);
            if (!matched && OCLParser.isEscaped(lastName)) {
                matched = OCLParser.unescape(lastName).equals(nextName);
            }
            if (!matched) continue;
            if (result == null) {
                result = next;
                continue;
            }
            String msg = OCLMessages.bind(OCLMessages.AmbiguousState_ERROR_, path, this.getUMLReflection().getQualifiedName(owner));
            throw new SemanticException(msg);
        }
        return result;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<C>> args) {
        O eop;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            O eop2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            if (!element.isExplicit && (eop2 = this.lookupOperation(vdcl.getType(), name, args)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (eop = this.lookupOperation(vdcl.getType(), name, args)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForProperty(String name) {
        P property;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            P property2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            if (!element.isExplicit && (property2 = this.lookupProperty(vdcl.getType(), name)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (property = this.lookupProperty(vdcl.getType(), name)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForAssociationClass(String name) {
        Object ac;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            Object ac2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            if (!element.isExplicit && (ac2 = this.lookupAssociationClassReference(vdcl.getType(), name)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (ac = this.lookupAssociationClassReference(vdcl.getType(), name)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForSignal(String name, List<? extends TypedElement<C>> args) {
        Object owner;
        Object sig;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            Object sig2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            Object owner2 = vdcl.getType();
            if (!element.isExplicit && (sig2 = this.lookupSignal(owner2, name, args)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (sig = this.lookupSignal(owner = vdcl.getType(), name, args)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForState(List<String> path) throws SemanticException {
        S state;
        Object owner;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            S state2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            Object owner2 = vdcl.getType();
            if (!element.isExplicit && owner2 != null && (state2 = this.lookupState(owner2, path)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = vdcl.getType()) != null && (state = this.lookupState(owner, path)) != null) {
            return vdcl;
        }
        return null;
    }

    protected String initialLower(Object element) {
        StringBuffer result = new StringBuffer(this.getUMLReflection().getName(element));
        if (result.length() > 0) {
            UnicodeSupport.setCodePointAt(result, 0, UnicodeSupport.toLowerCase(UnicodeSupport.codePointAt(result, 0)));
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class VariableEntry {
        final String name;
        final Variable<C, PM> variable;
        final boolean isExplicit;

        VariableEntry(String name, Variable<C, PM> variable, boolean isExplicit) {
            this.name = name;
            this.variable = variable;
            this.isExplicit = isExplicit;
        }

        public String toString() {
            return "VariableEntry[" + this.name + ", " + (this.isExplicit ? "explicit, " : "implicit, ") + this.variable + "]";
        }
    }
}

