/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.AbstractEnvironment;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.uml.TypeResolverImpl;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.UMLReflectionImpl;
import org.eclipse.ocl.uml.internal.OCLFactoryImpl;
import org.eclipse.ocl.uml.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.uml.internal.UMLForeignMethods;
import org.eclipse.ocl.uml.util.OCLUMLUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterEffectKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLEnvironment
extends AbstractEnvironment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> {
    private static OCLStandardLibraryImpl standardLibrary;
    private UMLReflection<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint> reflection;
    private ResourceSet resourceSet;
    private EPackage.Registry registry;
    private EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> factory;
    private TypeResolver<Classifier, Operation, Property> typeResolver;
    private Package umlMetamodel;
    private Map<List<String>, Classifier> classifierCache = new HashMap<List<String>, Classifier>();
    private Map<List<String>, Package> packageCache = new HashMap<List<String>, Package>();

    protected UMLEnvironment(EPackage.Registry registry, ResourceSet rset) {
        this.registry = registry;
        this.resourceSet = rset;
    }

    protected UMLEnvironment(EPackage.Registry registry, ResourceSet rset, Resource resource) {
        this(registry, rset);
        this.typeResolver = new TypeResolverImpl(this, resource);
    }

    protected UMLEnvironment(Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> parent) {
        super((AbstractEnvironment)((UMLEnvironment)parent));
        UMLEnvironment uparent = (UMLEnvironment)parent;
        if (uparent != null) {
            this.registry = uparent.registry;
            this.resourceSet = uparent.resourceSet;
            this.typeResolver = uparent.getTypeResolver();
        } else {
            this.registry = EPackage.Registry.INSTANCE;
            this.resourceSet = new ResourceSetImpl();
        }
    }

    public EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        if (this.getParent() != null) {
            this.factory = this.getParent().getFactory();
            if (this.factory != null) {
                return this.factory;
            }
        }
        this.factory = new UMLEnvironmentFactory(this.getResourceSet());
        return this.factory;
    }

    protected void setFactory(EnvironmentFactory<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> factory) {
        this.factory = factory;
    }

    public void setParent(Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> env) {
        super.setParent((AbstractEnvironment)((UMLEnvironment)env));
    }

    public OCLStandardLibrary<Classifier> getOCLStandardLibrary() {
        if (standardLibrary == null) {
            standardLibrary = OCLStandardLibraryImpl.INSTANCE;
        }
        return standardLibrary;
    }

    protected final ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected Package getUMLMetamodel() {
        if (this.umlMetamodel == null) {
            this.umlMetamodel = this.getFactory() instanceof UMLEnvironmentFactory ? ((UMLEnvironmentFactory)this.getFactory()).getUMLMetamodel() : OCLUMLUtil.getUMLMetamodel(this.getResourceSet());
        }
        return this.umlMetamodel;
    }

    public TypeResolver<Classifier, Operation, Property> getTypeResolver() {
        if (this.typeResolver == null) {
            this.typeResolver = this.createTypeResolver();
        }
        return this.typeResolver;
    }

    public OCLFactory getOCLFactory() {
        return OCLFactoryImpl.INSTANCE;
    }

    public UMLReflection<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        if (this.reflection == null) {
            this.reflection = this.getParent() != null ? this.getParent().getUMLReflection() : new UMLReflectionImpl(this.registry);
        }
        return this.reflection;
    }

    protected TypeResolver<Classifier, Operation, Property> createTypeResolver() {
        return new TypeResolverImpl(this);
    }

    public Package lookupPackage(List<String> path) {
        Package tryCache = this.packageCache.get(path);
        if (tryCache != null) {
            return tryCache;
        }
        Package pkg = null;
        Package currPkg = (Package)this.getContextPackage();
        if (currPkg != null) {
            List<String> lookup = path;
            while (currPkg != null) {
                pkg = currPkg;
                int i = 0;
                while (i < lookup.size()) {
                    String name = lookup.get(i);
                    if ((pkg = UMLForeignMethods.getNestedPackage(pkg, name)) == null) break;
                    ++i;
                }
                if (pkg != null) {
                    this.packageCache.put(path, pkg);
                    return pkg;
                }
                if (currPkg == this.getContextPackage() && lookup.size() > 0 && UMLForeignMethods.isNamed(lookup.get(0), (NamedElement)currPkg)) {
                    lookup = lookup.subList(1, lookup.size());
                    continue;
                }
                lookup = path;
                currPkg = currPkg.getNestingPackage();
            }
        }
        Package result = OCLUMLUtil.findPackage(path, this.getResourceSet());
        this.packageCache.put(path, result);
        return result;
    }

    public Classifier lookupClassifier(List<String> names) {
        Classifier tryCache = this.classifierCache.get(names);
        if (tryCache != null) {
            return tryCache;
        }
        Namespace ns = null;
        Namespace currNs = (Namespace)this.getContextPackage();
        if (names.size() > 1) {
            List<String> newNames;
            Classifier member;
            List<String> lookup = names;
            if (currNs != null) {
                while (currNs != null) {
                    String name;
                    ns = currNs;
                    int last = lookup.size() - 1;
                    int i = 0;
                    while (i < last) {
                        String name2 = lookup.get(i);
                        if ((ns = (Namespace)UMLForeignMethods.getMember(ns, name2, UMLPackage.Literals.NAMESPACE)) == null) break;
                        ++i;
                    }
                    if (ns != null && (member = (Classifier)UMLForeignMethods.getMember(ns, name = lookup.get(last), UMLPackage.Literals.CLASSIFIER)) != null) {
                        this.classifierCache.put(names, member);
                        return member;
                    }
                    if (currNs == this.getContextPackage() && lookup.size() > 1 && UMLForeignMethods.isNamed(lookup.get(0), (NamedElement)currNs)) {
                        lookup = lookup.subList(1, lookup.size());
                        continue;
                    }
                    lookup = names;
                    currNs = currNs.getNamespace();
                }
            }
            if ((ns = OCLUMLUtil.findNamespace(newNames = names.subList(0, names.size() - 1), this.getResourceSet())) == null) {
                return null;
            }
            String name = names.get(names.size() - 1);
            member = (Classifier)UMLForeignMethods.getMember(ns, name, UMLPackage.Literals.CLASSIFIER);
            if (member != null) {
                this.classifierCache.put(names, member);
                return member;
            }
            return member;
        }
        if (this.getContextPackage() != null) {
            String name = names.get(0);
            Classifier result = null;
            while (currNs != null) {
                result = (Classifier)UMLForeignMethods.getMember(currNs, name, UMLPackage.Literals.CLASSIFIER);
                if (result != null) {
                    this.classifierCache.put(names, result);
                    return result;
                }
                currNs = currNs.getNamespace();
            }
        }
        return null;
    }

    public Property lookupProperty(Classifier owner, String name) {
        Property result = (Property)super.lookupProperty((Object)owner, name);
        if (result == null) {
            result = this.lookupNonNavigableProperty(owner, name);
        }
        return result;
    }

    private Property lookupNonNavigableProperty(Classifier owner, String name) {
        Property result = null;
        if (owner == null) {
            Variable vdcl = this.lookupImplicitSourceForProperty(name);
            if (vdcl == null) {
                return null;
            }
            owner = (Classifier)vdcl.getType();
        }
        EList associations = owner.getAssociations();
        for (Association next : associations) {
            result = next.getMemberEnd(name, null);
            if (result != null) break;
        }
        return result;
    }

    public List<State> getStates(Classifier owner, List<String> pathPrefix) {
        BasicEList.FastCompare result = new BasicEList.FastCompare();
        this.collectStates(owner, pathPrefix, (List<State>)result);
        for (Classifier general : owner.allParents()) {
            this.collectStates(general, pathPrefix, (List<State>)result);
        }
        HashSet<State> redefinitions = new HashSet<State>();
        for (State s : result) {
            State redef = s.getRedefinedState();
            while (redef != null) {
                redefinitions.add(redef);
                redef = redef.getRedefinedState();
            }
        }
        result.removeAll(redefinitions);
        return result;
    }

    private void collectStates(Classifier owner, List<String> pathPrefix, List<State> states) {
        if (owner instanceof BehavioredClassifier) {
            EList behaviors = ((BehavioredClassifier)owner).getOwnedBehaviors();
            for (Behavior b : behaviors) {
                if (!(b instanceof StateMachine)) continue;
                this.collectStates((StateMachine)b, pathPrefix, states);
            }
        }
    }

    private void collectStates(StateMachine machine, List<String> pathPrefix, List<State> states) {
        if (pathPrefix.isEmpty()) {
            for (Region r : machine.getRegions()) {
                this.collectStates(r, pathPrefix, states);
            }
        } else {
            String firstName = pathPrefix.get(0);
            if (UMLForeignMethods.isNamed(firstName, (NamedElement)machine)) {
                pathPrefix = pathPrefix.subList(1, pathPrefix.size());
            }
            for (Region r : machine.getRegions()) {
                this.collectStates(r, pathPrefix, states);
            }
        }
    }

    private void collectStates(Region region, List<String> pathPrefix, List<State> states) {
        block3: {
            State state;
            block2: {
                if (!pathPrefix.isEmpty()) break block2;
                for (Vertex v : region.getSubvertices()) {
                    if (!(v instanceof State)) continue;
                    states.add((State)v);
                }
                break block3;
            }
            String firstName = pathPrefix.get(0);
            Vertex v = UMLForeignMethods.getSubvertex(region, firstName);
            if (!(v instanceof State) || !(state = (State)v).isComposite()) break block3;
            pathPrefix = pathPrefix.subList(1, pathPrefix.size());
            for (Region r : state.getRegions()) {
                this.collectStates(r, pathPrefix, states);
            }
        }
    }

    public Property defineAttribute(Classifier owner, Variable<Classifier, Parameter> variable, Constraint constraint) {
        String name = variable.getName();
        Classifier type = (Classifier)variable.getType();
        Property result = UMLFactory.eINSTANCE.createProperty();
        result.addKeyword("OclHelper");
        result.setName(name);
        result.setType((Type)type);
        owner.getOwnedRules().add((Object)constraint);
        this.addProperty(owner, result);
        return result;
    }

    public Operation defineOperation(Classifier owner, String name, Classifier type, List<Variable<Classifier, Parameter>> params, Constraint constraint) {
        Operation result = UMLFactory.eINSTANCE.createOperation();
        result.addKeyword("OclHelper");
        result.setName(name);
        result.setType((Type)(type == null ? (Classifier)this.getOCLStandardLibrary().getOclVoid() : type));
        result.setIsQuery(true);
        for (Variable<Classifier, Parameter> next : params) {
            Parameter param = UMLFactory.eINSTANCE.createParameter();
            param.setName(next.getName());
            param.setType((Type)(next.getType() == null ? (Classifier)this.getOCLStandardLibrary().getOclVoid() : (Classifier)next.getType()));
            param.setDirection(ParameterDirectionKind.IN_LITERAL);
            param.setEffect(ParameterEffectKind.READ_LITERAL);
            result.getOwnedParameters().add((Object)param);
        }
        owner.getOwnedRules().add((Object)constraint);
        this.addOperation(owner, result);
        return result;
    }

    public void undefine(Object feature) {
        Constraint definition = this.getDefinition(feature);
        if (definition == null) {
            throw new IllegalArgumentException("not an additional feature: " + feature);
        }
        EcoreUtil.remove((EObject)((EObject)feature));
        EcoreUtil.remove((EObject)definition);
        definition.getConstrainedElements().clear();
    }

    public Constraint getDefinition(Object feature) {
        Classifier shadowed;
        Constraint result = null;
        Feature umlFeature = (Feature)feature;
        Classifier owner = (Classifier)umlFeature.getOwner();
        if (owner instanceof Class && (shadowed = ((TypeResolverImpl)this.getTypeResolver()).getShadowedClassifier(owner)) != null) {
            owner = shadowed;
        }
        if (owner != null) {
            for (Constraint ct : owner.getOwnedRules()) {
                if (!ct.getKeywords().contains((Object)"definition") || !ct.getConstrainedElements().contains((Object)umlFeature)) continue;
                result = ct;
                break;
            }
        }
        return result;
    }

    public boolean isInPostcondition(OCLExpression<Classifier> exp) {
        Constraint constraint = null;
        EObject parent = exp;
        while (parent != null) {
            if (parent instanceof Constraint) {
                constraint = (Constraint)parent;
                break;
            }
            parent = parent.eContainer();
        }
        return constraint != null && !constraint.getKeywords().isEmpty() && "postcondition".equals(constraint.getKeywords().get(0));
    }
}

