/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.examples.interpreter.console;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ocl.examples.interpreter.console.text.OCLDocument;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.util.ToStringVisitor;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLResource
extends XMIResourceImpl {
    private static Map<String, Object> saveOptions = new HashMap<String, Object>();

    static {
        saveOptions.put("SAVE_TYPE_INFORMATION", true);
    }

    public OCLResource(URI uri) {
        super(uri);
    }

    protected boolean useIDs() {
        return true;
    }

    protected boolean useUUIDs() {
        return true;
    }

    public static String load(String path) throws IOException {
        String result = null;
        ResourceSetImpl rset = new ResourceSetImpl();
        OCLResource res = new OCLResource(URI.createFileURI((String)path));
        rset.getResources().add((Object)res);
        res.load(Collections.EMPTY_MAP);
        OCLExpression<Object> expr = res.getOCLExpression();
        if (expr != null) {
            result = (String)expr.accept((Visitor)ToStringVisitor.getInstance(expr));
        }
        return result;
    }

    public static void save(String path, OCLDocument document, String expression) throws IOException, ParserException {
        OCLResource res = new OCLResource(URI.createFileURI((String)path));
        OCL ocl = document.getOCLFactory().createOCL((Resource)res);
        OCLHelper helper = ocl.createOCLHelper();
        ConstraintKind kind = document.getModelingLevel().setContext(helper, document.getOCLContext(), document.getOCLFactory());
        OCLExpression parsed = null;
        switch (document.getModelingLevel()) {
            case M2: {
                parsed = helper.createQuery(expression);
                break;
            }
            case M1: {
                Object constraint = helper.createConstraint(kind, expression);
                parsed = ocl.getEnvironment().getUMLReflection().getSpecification(constraint).getBodyExpression();
            }
        }
        res.setOCLExpression(parsed);
        res.save(saveOptions);
    }

    public void setOCLExpression(OCLExpression<Object> expr) {
        this.getContents().add(0, expr);
    }

    public OCLExpression<Object> getOCLExpression() {
        OCLExpression result = null;
        if (!this.getContents().isEmpty()) {
            result = (OCLExpression)this.getContents().get(0);
        }
        return result;
    }
}

