/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.l10n.OCLMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationEnvironment<C, O, P, CLS, E>
implements EvaluationEnvironment<C, O, P, CLS, E> {
    private final EvaluationEnvironment<C, O, P, CLS, E> parent;
    private final Map<String, Object> map = new HashMap<String, Object>();

    protected AbstractEvaluationEnvironment() {
        this(null);
    }

    protected AbstractEvaluationEnvironment(EvaluationEnvironment<C, O, P, CLS, E> parent) {
        this.parent = parent;
    }

    protected EvaluationEnvironment<C, O, P, CLS, E> getParent() {
        return this.parent;
    }

    @Override
    public Object getValueOf(String name) {
        return this.map.get(name);
    }

    @Override
    public void replace(String name, Object value) {
        this.map.put(name, value);
    }

    @Override
    public void add(String name, Object value) {
        if (this.map.containsKey(name)) {
            String message = OCLMessages.bind(OCLMessages.BindingExist_ERROR_, name, this.map.get(name));
            throw new IllegalArgumentException(message);
        }
        this.map.put(name, value);
    }

    @Override
    public Object remove(String name) {
        return this.map.remove(name);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean overrides(O operation, int opcode) {
        return this.getParent() != null ? this.getParent().overrides(operation, opcode) : false;
    }

    @Override
    public Object callOperation(O operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        if (this.getParent() != null) {
            return this.getParent().callOperation(operation, opcode, source, args);
        }
        Method method = this.getJavaMethodFor(operation, source);
        if (method != null) {
            try {
                Class<?>[] parmTypes = method.getParameterTypes();
                int i = 0;
                while (i < parmTypes.length) {
                    if (EList.class.isAssignableFrom(parmTypes[i])) {
                        if (args[i] == null) {
                            args[i] = ECollections.EMPTY_ELIST;
                        } else if (!(args[i] instanceof Collection)) {
                            BasicEList.FastCompare list = new BasicEList.FastCompare(1);
                            list.add(args[i]);
                            args[i] = list;
                        } else if (!(args[i] instanceof EList)) {
                            args[i] = new BasicEList.FastCompare((Collection)args[i]);
                        }
                    }
                    ++i;
                }
                return method.invoke(source, args);
            }
            catch (Exception e) {
                OCLPlugin.catching(this.getClass(), "callOperation", e);
                OCLPlugin.log(4, 10, OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, "calloperation", e.getLocalizedMessage()), e);
                return this.getInvalidResult();
            }
        }
        throw new IllegalArgumentException();
    }

    protected abstract Method getJavaMethodFor(O var1, Object var2);

    protected abstract Object getInvalidResult();
}

