/**
* <copyright>
*
* Copyright (c) 2005, 2007 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*
* </copyright>
*
* $Id: OCLParserprs.java,v 1.1 2007/10/11 23:05:00 cdamus Exp $
*/

package org.eclipse.ocl.parser;

@SuppressWarnings("nls")
public class OCLParserprs implements lpg.lpgjavaruntime.ParseTable, OCLParsersym {

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,1,1,1,1,1,
            1,1,1,1,1,0,0,0,0,0,
            0,1,1,0,1,1,1,1,1,1,
            1,1,1,0,0,0,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,0,
            0,0,0,1,1,1,0,1,0,1,
            0,0,1,0,0,1,1,1,1,0,
            0,0,0,0,0,0,0,0,0,1,
            1,1,1,1,1,1,1,1,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,6,8,0,1,1,
            3,0,1,1,1,1,1,3,3,1,
            1,3,3,3,3,3,3,1,1,3,
            3,3,3,1,1,3,3,3,3,3,
            3,3,3,1,1,1,1,3,3,3,
            3,1,1,3,3,3,3,1,1,2,
            2,1,2,2,4,6,1,1,1,1,
            3,2,2,5,5,1,1,1,1,1,
            1,1,1,1,1,1,1,1,3,0,
            1,1,1,1,1,1,1,3,3,4,
            1,1,1,1,1,0,1,1,3,1,
            1,3,2,3,1,1,1,1,1,4,
            1,1,1,1,1,1,1,1,2,2,
            2,2,1,1,4,4,4,4,4,4,
            4,4,4,4,4,1,3,5,6,8,
            1,3,5,3,0,1,1,1,1,1,
            4,4,0,1,1,3,1,1,3,3,
            1,1,5,5,5,5,5,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,5,5,5,2,2,5,0,1,
            0,1,1,3,5,0,1,2,3,7,
            5,5,0,1,1,3,1,1,3,1,
            1,1,1,1,1,0,1,2,4,1,
            0,1,1,2,1,1,1,7,4,4,
            0,1,3,0,1,5,5,5,3,3,
            1,2,4,4,4,-118,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-124,0,0,
            -2,-3,0,0,-154,-13,-97,0,0,-38,
            0,0,-41,0,0,0,0,-126,0,0,
            -25,-4,0,0,0,0,-12,-5,-6,0,
            0,-128,0,0,0,0,-271,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-127,0,0,-218,0,0,0,
            0,0,0,0,0,0,-9,-14,-129,0,
            0,0,0,-272,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-10,0,0,0,
            0,0,-11,-16,0,0,-17,0,0,-18,
            -19,-20,-7,0,0,0,0,0,0,0,
            -125,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-46,0,-153,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -149,0,-155,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-152,0,-156,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-222,0,-157,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-259,0,
            -158,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-278,0,-159,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -308,0,-160,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-310,0,-161,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-26,0,-162,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-27,0,-28,0,
            -163,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-29,0,-35,0,-164,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-36,0,
            -37,0,-165,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-42,0,-69,0,-166,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -70,0,-72,0,-167,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-73,0,-74,0,
            -168,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-75,0,-76,0,-169,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-77,0,
            -78,0,-170,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-81,0,-82,0,-171,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -84,0,-86,0,-179,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-87,0,-88,0,
            -182,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-39,0,-89,0,-245,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-90,-93,
            -94,-95,-96,0,0,0,0,-98,-99,-100,
            -8,0,0,-101,-102,-103,0,0,-253,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-104,0,-260,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-105,-106,0,-107,
            0,-261,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-108,-109,0,-110,0,-262,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -111,-112,0,-113,0,-263,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-114,-115,0,
            -116,0,-264,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-117,-120,0,-123,0,-265,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-132,-145,0,-146,0,-266,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-150,-151,
            0,-172,0,-267,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-173,-176,0,-177,0,
            -268,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-178,-180,0,-181,0,-269,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-183,
            -184,0,-185,0,-270,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-192,-193,0,-194,
            0,-280,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-195,0,-196,0,-281,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-197,
            0,-198,0,-121,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-199,0,-122,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-200,
            0,-257,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-40,0,-313,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-201,-202,-203,
            -204,-205,-207,-208,-209,-210,-211,-212,-213,0,
            0,-30,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-31,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-32,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-33,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-34,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-43,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-49,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-85,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-92,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-174,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-206,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-215,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-221,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-243,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-244,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-247,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-249,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-301,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-302,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-309,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-311,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-319,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-320,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-141,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-142,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-143,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -144,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-135,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-136,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-137,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -138,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-139,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-140,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-133,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-134,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-130,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-131,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-47,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-48,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-175,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-1,-304,0,-50,
            0,0,-214,-219,-220,-223,-224,-225,-21,0,
            0,-226,-315,0,-227,0,0,-228,-45,-229,
            -230,-231,-232,-23,-15,0,-233,0,0,-83,
            -234,-44,0,-91,0,0,-24,-235,-236,-237,
            0,0,-238,-239,0,0,0,0,0,0,
            0,-240,0,-147,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-22,0,0,-119,0,0,-216,0,-148,
            0,0,0,0,-312,0,-217,0,0,-241,
            0,0,0,0,0,0,0,0,-246,-51,
            -242,-248,-52,-252,0,-53,-54,-55,-56,-57,
            -58,-59,-60,-254,-61,0,-62,-63,0,0,
            -64,0,-65,0,0,0,0,-66,-67,-68,
            0,0,0,0,-71,-79,0,0,0,-80,
            -186,0,0,0,0,0,-187,0,0,0,
            0,0,0,0,0,0,0,-188,0,0,
            -189,0,0,-190,0,-191,-250,-251,-307,0,
            0,0,-255,-256,-258,-273,0,0,-274,-275,
            -276,0,0,-277,-279,-282,-283,-284,0,-285,
            -286,-287,-288,-289,-290,-291,-292,-293,-294,0,
            -295,-296,0,-297,-298,0,-299,0,0,0,
            0,-300,-303,-305,-306,-314,-316,-317,-318,-321,
            0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            73,5,5,5,5,5,5,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,6,6,95,95,74,75,57,57,
            59,59,50,50,39,39,40,41,40,41,
            37,38,37,37,37,38,38,38,35,36,
            35,36,35,36,33,34,33,34,33,34,
            33,34,33,34,29,29,31,30,31,30,
            31,30,27,28,27,28,27,28,9,25,
            9,9,10,10,10,10,10,11,11,11,
            11,11,12,12,12,12,2,2,2,1,
            1,1,1,1,1,1,1,1,3,3,
            78,78,13,13,13,13,13,13,14,14,
            15,4,4,4,4,4,79,79,80,80,
            60,60,61,61,61,17,17,17,17,17,
            16,20,21,22,23,24,24,18,19,76,
            76,76,76,82,82,83,83,83,83,83,
            83,83,83,83,83,83,46,46,46,84,
            84,44,44,44,63,58,58,47,47,47,
            47,49,48,85,85,86,86,81,81,81,
            81,62,62,62,62,7,7,7,7,7,
            7,7,7,7,7,7,7,7,7,7,
            7,7,7,7,8,7,64,64,64,42,
            42,45,45,43,43,26,87,87,88,88,
            32,77,77,65,65,66,66,55,55,55,
            73,73,73,73,73,73,73,90,90,69,
            89,91,91,70,70,51,51,51,54,68,
            68,71,71,52,72,72,67,67,92,92,
            53,93,93,56,56,56,1,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,1936,1455,35,979,96,
            2030,334,800,22,118,1202,321,1143,3878,341,
            1084,96,109,1084,96,1500,128,130,764,96,
            4044,479,995,22,4041,192,151,152,891,1065,
            96,33,1084,96,2351,1892,1937,161,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,1407,41,1499,37,237,1455,35,480,
            152,3907,191,3877,823,96,4044,3,1085,22,
            4046,192,235,467,1889,1890,248,1036,331,1084,
            96,2352,4084,4087,161,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,237,1455,35,149,154,191,254,
            255,256,257,321,1083,4061,3894,1088,348,235,
            1108,1111,1114,1065,96,33,150,153,154,4092,
            4087,406,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            54,55,1363,65,1409,49,1407,41,1499,37,
            223,1455,35,481,2033,690,2031,406,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,1407,41,1499,37,223,1455,35,327,
            2033,690,3876,406,96,4020,1315,1087,4016,3870,
            89,90,72,3900,82,87,88,112,113,114,
            115,116,117,135,136,137,138,139,73,79,
            1361,67,54,55,1363,65,1409,49,1407,41,
            1499,37,223,1455,35,186,2033,690,3882,406,
            96,4020,1315,1087,4016,3870,89,90,72,3900,
            82,87,88,112,113,114,115,116,117,135,
            136,137,138,139,73,79,1361,67,54,55,
            1363,65,1409,49,1407,41,1499,37,223,1455,
            35,228,2033,690,3885,406,96,4020,1315,1087,
            4016,3870,89,90,72,3900,82,87,88,112,
            113,114,115,116,117,135,136,137,138,139,
            73,79,1361,67,54,55,1363,65,1409,49,
            1407,41,1499,37,223,1455,35,229,2033,690,
            3888,406,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            54,55,1363,65,1409,49,1407,41,1499,37,
            223,1455,35,4067,2033,690,3890,406,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,1407,41,1499,37,223,1455,35,31,
            2033,690,3891,406,96,4020,1315,1087,4016,3870,
            89,90,72,3900,82,87,88,112,113,114,
            115,116,117,135,136,137,138,139,73,79,
            1361,67,54,55,1363,65,1409,49,1407,41,
            1499,37,223,1455,35,4097,2033,690,3892,406,
            96,4020,1315,1087,4016,3870,89,90,72,3900,
            82,87,88,112,113,114,115,116,117,135,
            136,137,138,139,73,79,1361,67,54,55,
            1363,65,1409,49,1407,41,1499,37,223,1455,
            35,4099,2033,323,3893,406,96,4020,1315,1087,
            4016,3870,89,90,72,3900,82,87,88,112,
            113,114,115,116,117,135,136,137,138,139,
            73,79,1361,67,54,55,1363,65,1409,49,
            1407,41,1499,37,223,1455,35,721,2033,74,
            3897,406,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            54,55,1363,65,1409,49,1407,41,1499,37,
            223,1455,35,332,2033,1116,3901,406,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,1407,41,1499,37,223,1455,35,1117,
            2033,550,3908,406,96,4020,1315,1087,4016,3870,
            89,90,72,3900,82,87,88,112,113,114,
            115,116,117,135,136,137,138,139,73,79,
            1361,67,54,55,1363,65,1409,49,1407,41,
            1499,37,223,1455,35,156,2033,883,3909,406,
            96,4020,1315,1087,4016,3870,89,90,72,3900,
            82,87,88,112,113,114,115,116,117,135,
            136,137,138,139,73,79,1361,67,54,55,
            1363,65,1409,49,1407,41,1499,37,223,1455,
            35,885,2033,243,3910,406,96,4020,1315,1087,
            4016,3870,89,90,72,3900,82,87,88,112,
            113,114,115,116,117,135,136,137,138,139,
            73,79,1361,67,54,55,1363,65,1409,49,
            1407,41,1499,37,223,1455,35,938,2033,1085,
            3913,406,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            54,55,1363,65,1409,49,1407,41,1499,37,
            223,1455,35,1113,2033,1115,3914,406,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,1407,41,1499,37,223,1455,35,1118,
            2033,1126,3922,406,96,4020,1315,1087,4016,3870,
            89,90,72,3900,82,87,88,112,113,114,
            115,116,117,135,136,137,138,139,73,79,
            1361,67,54,55,1363,65,1409,49,1407,41,
            1499,37,223,1455,35,1127,2033,695,3970,406,
            96,4020,1315,1087,4016,3870,89,90,72,3900,
            82,87,88,112,113,114,115,116,117,135,
            136,137,138,139,73,79,1361,67,54,55,
            1363,65,1409,49,1407,41,1499,37,223,1455,
            35,964,2033,859,3981,406,96,4020,1315,1087,
            4016,3870,89,90,72,3900,82,87,88,112,
            113,114,115,116,117,135,136,137,138,139,
            73,79,1361,67,54,55,1363,65,1409,49,
            1407,41,1499,37,223,1455,35,68,2033,911,
            3982,406,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            54,55,1363,65,1409,49,1407,41,1499,37,
            223,1455,35,402,2033,1067,3984,81,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,1407,41,1499,37,1936,1455,35,907,
            939,1131,1142,1130,254,255,256,257,1145,895,
            950,1065,96,33,1148,1150,1152,129,130,406,
            96,4020,1315,1087,4016,3870,89,90,72,3900,
            82,87,88,112,113,114,115,116,117,135,
            136,137,138,139,73,79,1361,67,54,55,
            1363,65,1409,49,1407,41,1499,37,223,1455,
            35,482,2033,1155,4065,477,96,4020,1315,1087,
            4016,3870,89,90,72,3900,82,87,88,112,
            113,114,115,116,117,135,136,137,138,139,
            73,79,1361,67,54,55,1363,65,1409,49,
            1407,41,1499,37,166,1455,35,1157,1159,4070,
            1163,4068,477,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,166,1455,35,1167,1169,4070,1171,4072,477,
            96,4020,1315,1087,4016,3870,89,90,72,3900,
            82,87,88,112,113,114,115,116,117,135,
            136,137,138,139,73,79,1361,67,54,55,
            1363,65,1409,49,1407,41,1499,37,166,1455,
            35,1173,1175,4070,1177,4073,477,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,166,1455,35,1180,1185,
            4070,1188,4074,477,96,4020,1315,1087,4016,3870,
            89,90,72,3900,82,87,88,112,113,114,
            115,116,117,135,136,137,138,139,73,79,
            1361,67,54,55,1363,65,1409,49,1407,41,
            1499,37,166,1455,35,1190,1197,4070,1199,4075,
            477,96,4020,1315,1087,4016,3870,89,90,72,
            3900,82,87,88,112,113,114,115,116,117,
            135,136,137,138,139,73,79,1361,67,54,
            55,1363,65,1409,49,1407,41,1499,37,166,
            1455,35,25,1161,4070,983,4076,477,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,1407,41,1499,37,166,1455,35,1146,
            1183,4070,80,4077,477,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,166,1455,35,1192,1203,4070,653,
            4078,477,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            54,55,1363,65,1409,49,1407,41,1499,37,
            166,1455,35,1082,284,4070,996,4079,477,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,1499,37,166,1455,35,
            936,1206,4070,1207,4081,477,96,4020,1315,1087,
            4016,3870,89,90,72,3900,82,87,88,112,
            113,114,115,116,117,135,136,137,138,139,
            73,79,1361,67,54,55,1363,65,1409,49,
            1407,41,1499,37,166,1455,35,1209,1211,4070,
            1213,4082,406,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,223,1455,35,1215,2033,1217,4094,406,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,1499,37,223,1455,35,
            1220,2033,1222,4095,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,223,1455,35,1224,1984,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,1499,37,223,1455,35,
            1226,1986,335,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,223,1455,35,1051,4066,248,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,237,1455,35,1228,1230,
            1232,1234,1236,997,1031,928,1035,972,234,236,
            272,236,335,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,260,1455,35,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,259,1455,35,335,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,275,1455,35,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,1499,37,274,1455,35,
            335,96,4020,1315,1087,4016,3870,89,90,72,
            3900,82,87,88,112,113,114,115,116,117,
            135,136,137,138,139,73,79,1361,67,54,
            55,1363,65,1409,49,1407,41,1499,37,273,
            1455,35,335,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,173,1455,35,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,1508,1455,35,335,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,1842,1455,35,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,1499,37,266,1455,35,
            335,96,4020,1315,1087,4016,3870,89,90,72,
            3900,82,87,88,112,113,114,115,116,117,
            135,136,137,138,139,73,79,1361,67,54,
            55,1363,65,1409,49,1407,41,1499,37,133,
            1455,35,335,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,4056,1455,35,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,269,1455,35,335,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,225,1455,35,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,1499,37,134,1455,35,
            335,96,4020,1315,1087,4016,3870,89,90,72,
            3900,82,87,88,112,113,114,115,116,117,
            135,136,137,138,139,73,79,1361,67,54,
            55,1363,65,1409,49,1407,41,1499,37,132,
            1455,35,335,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,174,1455,35,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,224,1455,35,335,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,4096,1455,35,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,1499,37,268,1455,35,
            335,96,4020,1315,1087,4016,3870,89,90,72,
            3900,82,87,88,112,113,114,115,116,117,
            135,136,137,138,139,73,79,1361,67,54,
            55,1363,65,1409,49,1407,41,1499,37,4098,
            1455,35,335,96,4020,1315,1087,4016,3870,89,
            90,72,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,73,79,1361,
            67,54,55,1363,65,1409,49,1407,41,1499,
            37,167,1455,35,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,1407,
            41,1499,37,4100,1455,35,335,96,4020,1315,
            1087,4016,3870,89,90,72,3900,82,87,88,
            112,113,114,115,116,117,135,136,137,138,
            139,73,79,1361,67,54,55,1363,65,1409,
            49,1407,41,1499,37,168,1455,35,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,1409,49,1407,41,2357,39,335,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,54,55,1363,65,
            1409,49,2358,47,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,54,55,1363,65,1409,49,2359,
            46,335,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            54,55,1363,65,1409,49,3873,45,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,54,55,1363,
            65,2355,53,335,96,4020,1315,1087,4016,3870,
            89,90,72,3900,82,87,88,112,113,114,
            115,116,117,135,136,137,138,139,73,79,
            1361,67,54,55,1363,65,2356,51,335,96,
            4020,1315,1087,4016,3870,89,90,72,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,73,79,1361,67,62,63,1363,
            65,335,96,4020,1315,1087,4016,3870,89,90,
            72,3900,82,87,88,112,113,114,115,116,
            117,135,136,137,138,139,73,79,1361,67,
            60,61,1363,65,335,96,4020,1315,1087,4016,
            3870,89,90,72,3900,82,87,88,112,113,
            114,115,116,117,135,136,137,138,139,73,
            79,1361,67,58,59,1363,65,335,96,4020,
            1315,1087,4016,3870,89,90,72,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,73,79,1361,67,56,57,1363,65,
            548,96,4020,1315,1087,4016,3870,89,90,72,
            3900,82,87,88,112,113,114,115,116,117,
            135,136,137,138,139,73,79,2353,71,548,
            96,4020,1315,1087,4016,3870,89,90,72,3900,
            82,87,88,112,113,114,115,116,117,135,
            136,137,138,139,73,79,2354,69,548,96,
            4020,1315,1087,4016,3870,89,90,76,3900,82,
            87,88,112,113,114,115,116,117,135,136,
            137,138,139,77,79,548,96,4020,1315,1087,
            4016,3870,89,90,74,3900,82,87,88,112,
            113,114,115,116,117,135,136,137,138,139,
            75,79,697,96,4020,1315,1087,4016,3870,89,
            90,81,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,697,96,4020,
            1315,1087,4016,3870,89,90,80,3900,82,87,
            88,112,113,114,115,116,117,135,136,137,
            138,139,617,96,4020,1315,1087,4016,3870,89,
            90,80,3900,82,87,88,112,113,114,115,
            116,117,135,136,137,138,139,1046,1030,177,
            825,947,949,325,1238,1241,1244,1245,1248,1065,
            96,33,1249,1030,177,1250,947,949,1253,684,
            1254,1257,1258,1261,619,912,177,1262,947,949,
            70,1265,912,177,889,947,949,688,1266,1269,
            1270,245,1509,1273,1274,176,178,179,253,255,
            256,257,1279,243,912,177,27,947,949,995,
            176,178,179,185,417,342,247,418,348,467,
            321,26,903,178,179,253,255,256,257,1501,
            178,179,1065,96,33,1193,240,347,912,177,
            1201,947,949,271,1453,912,177,1201,947,949,
            1280,407,178,179,1502,1503,83,84,1843,1193,
            825,1283,1284,825,1287,1041,825,825,825,825,
            825,825,825,825,1290,825,267,825,825,188,
            2304,825,1039,825,30,4059,178,179,825,825,
            825,30,239,178,179,76,78,3874,187,3875,
            245,825,1510,190,4060,1514,3875,825,1515,1516,
            1563,1607,1608,1610,1654,1655,1939,1657,825,1701,
            1702,825,189,1704,247,1748,825,825,825,825,
            1749,1751,1795,1292,1294,1296,1288,1796,93,1298,
            1299,1081,1798,3994,1300,1303,1064,1050,1304,4053,
            1066,1034,1307,1308,1311,1312,1316,1317,1320,1321,
            1796,1325,1326,4054,1329,1330,4055,1332,217,95,
            94,218,1333,1334,1336,1337,228,371,1340,430,
            1341,4103,4103
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,0,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,27,28,29,
            30,31,32,33,34,35,0,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,0,68,0,
            70,4,5,0,1,0,1,0,1,0,
            0,1,82,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,27,28,29,
            30,31,32,33,34,35,92,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,72,68,72,
            70,0,83,0,85,0,87,88,81,80,
            0,1,82,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,27,28,29,
            30,31,32,33,34,35,0,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,0,68,76,
            70,76,79,0,79,0,0,4,5,4,
            5,90,0,1,0,0,0,0,1,89,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,25,26,27,28,29,30,31,32,
            33,34,35,0,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,72,68,72,70,72,36,
            0,94,0,3,0,81,4,81,4,5,
            0,0,1,0,0,1,89,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,75,25,
            26,27,28,29,30,31,32,33,34,35,
            0,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,0,68,73,70,0,1,74,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            25,26,27,28,29,30,31,32,33,34,
            35,71,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,0,68,73,70,0,1,0,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            71,25,26,27,28,29,30,31,32,33,
            34,35,0,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,0,68,67,70,0,1,0,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,25,26,27,28,29,30,31,32,
            33,34,35,0,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,0,68,0,1,0,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            91,25,26,27,28,29,30,31,32,33,
            34,35,0,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,0,0,67,3,0,36,0,
            0,73,3,6,0,1,0,1,82,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,26,27,28,29,30,31,32,33,
            34,35,80,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,0,77,78,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,67,25,26,
            27,28,29,30,31,32,33,34,35,0,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,0,24,0,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,25,26,27,
            28,29,30,31,32,33,34,35,0,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,0,0,2,0,4,5,6,0,0,
            0,3,34,35,0,1,72,16,17,18,
            19,20,21,22,23,0,0,26,27,28,
            0,0,22,23,3,34,35,36,7,8,
            9,10,11,12,13,14,15,0,18,19,
            20,21,26,27,28,0,1,0,0,1,
            29,30,31,32,33,18,19,20,21,0,
            1,69,71,69,73,74,75,76,77,78,
            79,80,24,0,83,84,85,86,87,88,
            59,0,91,92,93,94,95,96,0,16,
            17,3,0,1,6,7,8,9,10,11,
            12,13,14,15,0,0,0,26,27,28,
            22,23,67,25,67,0,24,29,30,31,
            32,33,16,17,0,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,0,
            0,36,3,0,0,0,7,8,9,10,
            11,12,13,14,15,0,16,17,3,0,
            0,6,18,19,20,21,6,24,29,30,
            31,32,33,0,0,0,0,3,74,36,
            75,7,8,9,10,11,12,13,14,15,
            0,0,0,0,0,4,3,0,59,25,
            7,8,9,10,11,12,13,14,15,36,
            67,36,22,23,71,24,24,0,25,74,
            0,24,0,0,0,0,0,0,73,74,
            71,76,77,78,79,0,0,77,78,0,
            0,24,2,84,24,90,71,24,75,24,
            24,0,0,2,0,0,2,0,1,0,
            1,0,1,69,0,1,0,1,0,1,
            0,95,0,1,4,36,0,1,0,1,
            0,1,0,1,0,1,0,1,36,0,
            1,69,0,69,0,1,69,0,1,0,
            1,0,0,67,69,3,0,1,0,1,
            0,0,0,3,3,0,0,2,0,1,
            0,1,0,1,0,1,0,1,36,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,36,2,
            0,96,36,0,0,2,2,0,0,0,
            2,2,0,0,2,2,0,0,2,2,
            0,0,2,2,0,0,2,2,0,0,
            2,2,0,0,2,2,36,86,0,0,
            2,2,0,0,2,2,0,0,2,0,
            1,0,1,0,1,0,1,0,0,0,
            2,4,0,0,2,2,0,0,2,2,
            0,0,2,2,67,0,0,2,2,0,
            0,2,2,24,0,0,2,2,0,0,
            2,0,0,0,2,0,0,2,2,0,
            0,2,2,0,0,0,0,0,0,0,
            0,0,0,24,0,0,0,24,0,0,
            0,0,0,0,0,0,0,36,0,0,
            0,0,0,0,0,0,0,0,0,0,
            93,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            126,2614,261,1177,3997,3995,4117,4204,4202,4203,
            4205,4206,4207,4208,4209,4210,4015,3992,3991,3990,
            3989,3988,4118,4119,4103,4200,3987,3986,3983,1271,
            1269,1225,1223,1179,3993,3842,4103,1133,4104,4105,
            4106,4107,4108,4109,4110,4111,4112,4113,4114,4115,
            4116,3792,4001,3998,4003,4008,4010,4009,3980,1131,
            1317,4247,4244,4246,4248,4249,4251,40,535,78,
            2656,3513,3478,4103,3902,142,219,219,22,4103,
            4103,2614,2740,1177,3997,3995,4117,4204,4202,4203,
            4205,4206,4207,4208,4209,4210,4015,3992,3991,3990,
            3989,3988,4118,4119,4103,4200,3987,3986,3983,1271,
            1269,1225,1223,1179,3993,3842,2782,1133,4104,4105,
            4106,4107,4108,4109,4110,4111,4112,4113,4114,4115,
            4116,3792,4001,3998,4003,4008,4010,4009,3980,1131,
            1317,4247,4244,4246,4248,4249,4251,4323,535,5260,
            2656,241,404,4103,338,263,419,352,2174,4223,
            233,2614,2740,1177,3997,3995,4117,4204,4202,4203,
            4205,4206,4207,4208,4209,4210,4015,3992,3991,3990,
            3989,3988,4118,4119,4103,4200,3987,3986,3983,1271,
            1269,1225,1223,1179,3993,3817,4103,1133,4104,4105,
            4106,4107,4108,4109,4110,4111,4112,4113,4114,4115,
            4116,3792,4001,3998,4003,4008,4010,4009,3980,1131,
            1317,4247,4244,4246,4248,4249,4251,4103,535,3952,
            2656,265,3879,44,265,43,4103,3513,3478,3513,
            3478,473,147,23,219,4103,219,4103,2614,4085,
            1177,3997,3995,4117,4204,4202,4203,4205,4206,4207,
            4208,4209,4210,4015,3992,3991,3990,3989,3988,4118,
            4119,4103,4200,3987,3986,3983,1271,1269,1225,1223,
            1179,3993,3817,4103,1133,4104,4105,4106,4107,4108,
            4109,4110,4111,4112,4113,4114,4115,4116,3792,4001,
            3998,4003,4008,4010,4009,3980,1131,1317,4247,4244,
            4246,4248,4249,4251,23,535,4323,2656,4323,3034,
            4103,4333,172,4211,42,2218,2572,2262,3513,3478,
            250,4103,3889,4103,4103,2614,4085,1177,3997,3995,
            4117,4204,4202,4203,4205,4206,4207,4208,4209,4210,
            4015,3992,3991,3990,3989,3988,4118,4119,4047,4200,
            3987,3986,3983,1271,1269,1225,1223,1179,3993,3817,
            4103,1133,4104,4105,4106,4107,4108,4109,4110,4111,
            4112,4113,4114,4115,4116,3792,4001,3998,4003,4008,
            4010,4009,3980,1131,1317,4247,4244,4246,4248,4249,
            4251,252,535,326,2656,221,2614,4102,1177,3997,
            3995,4117,4204,4202,4203,4205,4206,4207,4208,4209,
            4210,4015,3992,3991,3990,3989,3988,4118,4119,4103,
            4200,3987,3986,3983,1271,1269,1225,1223,1179,3993,
            3817,3244,1133,4104,4105,4106,4107,4108,4109,4110,
            4111,4112,4113,4114,4115,4116,3792,4001,3998,4003,
            4008,4010,4009,3980,1131,1317,4247,4244,4246,4248,
            4249,4251,4103,535,326,2656,4103,2614,264,4071,
            3997,3995,4117,4204,4202,4203,4205,4206,4207,4208,
            4209,4210,4015,3992,3991,3990,3989,3988,4118,4119,
            3286,4200,3987,3986,3983,1271,1269,1225,1223,1179,
            3993,3817,4103,1133,4104,4105,4106,4107,4108,4109,
            4110,4111,4112,4113,4114,4115,4116,3792,4001,3998,
            4003,4008,4010,4009,3980,1131,1317,4247,4244,4246,
            4248,4249,4251,4103,535,333,2656,4103,2614,4103,
            1177,3997,3995,4117,4204,4202,4203,4205,4206,4207,
            4208,4209,4210,4015,3992,3991,3990,3989,3988,4118,
            4119,4103,4200,3987,3986,3983,1271,1269,1225,1223,
            1179,3993,3817,4103,1133,4104,4105,4106,4107,4108,
            4109,4110,4111,4112,4113,4114,4115,4116,3792,4001,
            3998,4003,4008,4010,4009,3980,1131,1317,4247,4244,
            4246,4248,4249,4251,4103,535,4103,2614,251,1177,
            3997,3995,4117,4204,4202,4203,4205,4206,4207,4208,
            4209,4210,4015,3992,3991,3990,3989,3988,4118,4119,
            4352,4200,3987,3986,3983,1271,1269,1225,1223,1179,
            3993,3817,4103,1133,4104,4105,4106,4107,4108,4109,
            4110,4111,4112,4113,4114,4115,4116,3792,4001,3998,
            4003,4008,4010,4009,3980,1131,1317,4247,4244,4246,
            4248,4249,4251,183,4103,330,322,4103,3979,4103,
            4103,326,322,349,4103,491,4103,2614,2950,1177,
            3997,3995,4117,4204,4202,4203,4205,4206,4207,4208,
            4209,4210,4015,3992,3991,3990,3989,3988,4118,4119,
            180,4200,3987,3986,3983,1271,1269,1225,1223,1179,
            3993,3817,4243,1133,4104,4105,4106,4107,4108,4109,
            4110,4111,4112,4113,4114,4115,4116,3792,4001,3998,
            4003,4008,4010,4009,3980,1131,1317,4247,4244,4246,
            4248,4249,4251,4103,1511,483,4201,3997,3995,4117,
            4204,4202,4203,4205,4206,4207,4208,4209,4210,4038,
            3992,3991,3990,3989,3988,4118,4119,330,4200,3987,
            3986,3983,4120,4121,4122,4123,4124,3993,4027,171,
            4126,4104,4105,4106,4107,4108,4109,4110,4111,4112,
            4113,4114,4115,4116,4021,4001,3998,4003,4008,4010,
            4009,3980,4103,3895,219,4201,3997,3995,4117,4204,
            4202,4203,4205,4206,4207,4208,4209,4210,4038,3992,
            3991,3990,3989,3988,4118,4119,4103,4200,3987,3986,
            3983,4120,4121,4122,4123,4124,3993,4027,64,4126,
            2077,2350,2349,2348,2216,2260,2172,2170,2126,2124,
            2080,2078,4116,4021,4001,3998,4003,4008,4010,4009,
            3980,22,4103,4323,4103,4323,4323,4323,4103,4103,
            4103,1845,3709,3680,4103,537,4323,4323,4323,4323,
            4323,4323,4323,4323,4323,4103,36,4323,4323,4323,
            48,4103,474,477,4211,4323,4323,4323,4204,4202,
            4203,4205,4206,4207,4208,4209,4210,52,3647,3614,
            3581,3548,3441,3404,3367,119,1519,98,109,3960,
            4224,4225,4226,4227,4228,3647,3614,3581,3548,4103,
            325,276,4323,3955,4323,4323,4323,4323,4323,4323,
            4323,4323,3924,66,4323,4323,4323,4323,4323,4323,
            993,38,4323,4323,4323,4323,4323,4323,4103,3765,
            3738,4201,4103,3967,4117,4204,4202,4203,4205,4206,
            4207,4208,4209,4210,262,4103,70,3441,3404,3367,
            4118,4119,109,4200,108,4103,3958,4120,4121,4122,
            4123,4124,3765,3738,4103,4126,4104,4105,4106,4107,
            4108,4109,4110,4111,4112,4113,4114,4115,4116,175,
            68,3034,4211,98,50,265,4204,4202,4203,4205,
            4206,4207,4208,4209,4210,261,3765,3738,322,4103,
            270,349,3647,3614,3581,3548,349,3895,4224,4225,
            4226,4227,4228,4103,32,4103,34,4201,244,171,
            4048,4204,4202,4203,4205,4206,4207,4208,4209,4210,
            258,171,4103,4103,21,2992,4201,4103,993,4200,
            4204,4202,4203,4205,4206,4207,4208,4209,4210,3034,
            108,857,262,262,171,3895,2362,4103,4200,242,
            4103,2404,20,4103,19,4103,4103,18,326,246,
            3160,264,1511,483,264,17,4103,1511,483,184,
            4103,2446,4284,811,2488,473,3202,2530,4049,3904,
            2698,4103,226,4285,4103,4103,4194,4103,583,4103,
            629,4103,675,125,4103,721,4103,767,4103,813,
            4103,3328,4103,859,2824,581,4103,905,4103,951,
            4103,997,4103,1043,4103,1089,4103,1135,627,4103,
            1181,124,227,123,4103,1227,122,4103,1273,4103,
            1319,131,4103,318,121,1983,4103,1365,92,1411,
            28,110,127,322,4211,4103,222,4188,1,719,
            12,1565,11,1612,10,1659,9,1706,673,8,
            1753,7,1800,5,1847,6,1894,4,1941,3,
            1988,2,2035,4103,357,4103,424,4103,1457,4064,
            29,2866,3034,4103,4103,4317,4318,111,4103,4103,
            4316,4315,4103,4103,4314,4313,4103,4103,4312,4311,
            4103,4103,4310,4309,4103,4103,4307,4306,4103,4103,
            4305,4304,4103,4103,4303,4302,765,2908,4103,4103,
            4301,4300,4103,4103,4299,4308,4103,4103,4298,4103,
            2082,4103,2128,217,537,216,1411,4103,4103,4103,
            4093,3118,4103,4103,4189,4268,4103,4103,4267,4266,
            4103,4103,4265,4264,330,4103,4103,4263,4262,4103,
            4103,4261,4260,3868,4103,4103,4259,4258,4103,238,
            4335,234,4103,4103,4334,4103,4103,4297,4296,4103,
            4103,4272,4273,4103,4103,4103,4103,4103,4103,4103,
            4103,4103,4103,3965,4103,4103,4103,3883,4103,4103,
            4103,4103,4103,4103,4103,4103,4103,2306,4103,4103,
            4103,4103,4103,4103,4103,4103,4103,4103,4103,4103,
            3076
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            367,250,69,242,243,83,83,83,375,376,
            162,80,162,249,52,94,94,94,94,94,
            83,83,405,338,344,289,231,353,353,98,
            98,98,98,98,94,94,415,152,414,335,
            152,246,98,52,228,162,100,100,98,399,
            399,399,399,399,399,399,399,399,399,399,
            399,399,399,399,399,399,399,399,252,252,
            300,300,254,298,298,298,298,298,299,299,
            346,353,302,306,98,308,314,310,319,316,
            162,98,342,229,229,441,77,229,353,353,
            353,353,353,353,353,353,353,353,353,353,
            353,353,353,353,353,353,353,1,162,353,
            98,98,257,130,164,109,109,152,152,99,
            99,348,99,99,98,98,98,98,98,98,
            98,98,98,98,350,352,52,228,162,78,
            77,162,164,228,164,164,164,164,164,164,
            164,164,164,164,164,164,164,164,164,164,
            164,362,355,98,4,361,361,359,164,364,
            364,164,256,229,441,399,399,399,300,299,
            301,300,300,300,300,300,300,300,300,300,
            300,300,300,353,353,98,306,306,310,310,
            316,314,314,314,98,52,228,243,229,441,
            98,162,229,229,402,229,229,229,229,229,
            229,229,229,229,229,229,229,229,229,229,
            229,229,98,98,2,162,98,229,98,301,
            301,229,164,353,353,257,98,257,162,98,
            98,98,98,98,98,98,98,98,98,98,
            96,96,409,350,229,411,94,162,229,164,
            164,364,74,229,295,417,229,229,229,229,
            229,229,229,229,229,229,229,440,441,229,
            98,98,94,379,229,229,301,162,98,162,
            98,52,97,444,51,296,229,296,98,98,
            229
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            80,70,68,60,38,39,40,41,42,43,
            44,45,46,47,48,49,50,6,22,23,
            25,66,37,62,16,63,61,64,65,56,
            57,55,54,52,53,5,34,17,18,19,
            20,21,26,27,28,58,1,35,51,82,
            4,8,9,7,10,11,12,13,14,15,
            59,29,30,31,32,33,3,0,2,36,
            96,74,24,71,84,0,36,96,0,74,
            90,0,25,3,8,9,7,10,11,12,
            13,14,15,24,0,2,89,70,68,60,
            66,62,63,61,64,65,59,1,56,57,
            55,54,52,53,4,5,34,16,17,18,
            19,20,21,26,27,28,58,35,51,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,6,22,23,29,30,31,32,33,
            37,25,8,9,7,10,11,12,13,14,
            15,3,0,70,60,38,39,40,41,42,
            43,44,45,46,47,48,49,50,6,22,
            23,29,30,31,32,33,8,9,7,10,
            11,12,13,14,15,25,66,37,62,16,
            63,61,64,65,59,56,57,55,54,52,
            53,4,5,34,17,18,19,20,21,26,
            27,28,58,1,35,51,68,3,2,0,
            4,2,80,71,36,84,77,78,96,6,
            67,74,23,22,0,76,79,91,73,74,
            0,69,0,81,72,67,34,35,16,17,
            18,19,20,21,5,75,83,85,86,87,
            88,76,77,78,73,91,79,92,93,94,
            26,27,28,95,6,22,23,1,2,80,
            84,96,74,4,36,71,0,69,81,1,
            72,87,88,83,85,16,17,34,35,18,
            19,20,21,4,5,26,27,28,2,80,
            75,71,36,84,86,76,79,92,93,94,
            96,22,23,95,73,91,74,77,78,6,
            0,1,24,76,79,67,0,92,0,4,
            0,24,1,0,80,36,86,0,24,4,
            36,80,0,75,36,0,22,23,73,90,
            77,78,6,3,74,76,79,0,77,78,
            6,8,9,7,10,11,12,13,14,15,
            59,29,30,31,32,33,3,0,1,72,
            0,2,67,0,91,73,67,0,93,0,
            22,23,74,73,91,0,71,67,34,35,
            16,17,18,19,4,20,21,5,1,81,
            83,85,72,87,88,26,27,28,95,24,
            2,36,0,94,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            66,27,27,27,27,14,14,14,27,27,
            26,12,1,20,25,27,27,27,27,27,
            14,14,75,83,10,27,27,27,27,23,
            23,23,23,23,27,27,27,40,20,28,
            40,27,23,25,73,90,23,23,23,71,
            71,71,71,71,71,71,71,71,71,71,
            71,71,71,71,71,71,71,71,27,27,
            71,27,27,27,27,27,27,27,71,71,
            27,27,77,27,23,27,27,27,27,27,
            80,23,27,27,27,27,4,27,27,27,
            27,27,27,27,27,27,27,27,27,27,
            27,27,27,27,27,27,27,23,85,27,
            23,23,27,17,23,6,16,40,40,60,
            60,27,54,54,42,42,48,48,48,48,
            30,36,36,36,27,27,25,87,90,27,
            27,90,23,26,23,23,23,23,23,23,
            23,23,23,23,23,23,23,23,23,23,
            23,27,27,23,23,27,27,27,23,27,
            27,23,27,27,27,71,71,71,71,71,
            71,27,27,27,27,27,27,27,27,27,
            27,27,27,27,27,23,27,27,27,27,
            27,27,27,27,23,25,87,69,27,27,
            23,90,27,27,27,27,27,27,27,27,
            27,27,27,27,27,27,27,27,27,27,
            27,27,23,23,23,89,23,27,23,71,
            71,27,23,27,27,27,23,27,90,22,
            22,22,22,22,22,22,22,22,22,22,
            23,23,27,27,27,27,27,90,27,23,
            23,27,27,27,27,27,27,27,27,27,
            27,27,27,27,27,27,27,27,27,27,
            23,23,27,25,27,27,71,90,23,90,
            23,25,23,27,25,27,27,27,23,23,
            27
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            3,75,0,88,0,2,6,8,0,67,
            0,69,0,50,0,82,2,6,0,51,
            0,44,2,5,4,3,0,56,0,3,
            2,5,4,38,0,5,3,4,36,2,
            0,3,2,5,4,34,0,5,2,3,
            4,30,0,5,2,3,4,28,0,3,
            2,5,4,25,0,70,90,67,68,0,
            42,0,86,0,70,0,76,77,0,74,
            92,0,93,0,81,0,59,0,63,44,
            0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,12,98,7,10,55,86,87,88,89,
            90,92,93,94,95,3,4,5,6,8,
            9,56,57,20,34,46,47,48,61,62,
            63,64,65,1,2,19,58,66,67,68,
            69,70,71,72,73,74,75,76,77,85,
            49,78,79,80,81,82,83,84,91,30,
            31,32,33,53,54,96,21,51,13,42,
            18,25,38,97,16,35,36,37,41,14,
            15,99,17,22,23,24,26,27,28,39,
            40,43,44,45,50,52,59,60,100
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            0,106,105,129,101,102,0,127,122,124,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,123,0,120,121,117,118,
            119,0,115,116,113,114,111,112,109,110,
            0,0,128,108,0,135,136,0,0,0,
            148,0,0,0,141,144,0,0,107,131,
            0,133,137,0,0,140,143,145,146,147,
            0,0,0,103,104,125,126,0,0,130,
            132,134,0,0,0,138,0,139,0,142,
            0,149,150,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            179,13,207,288,187,1,8,54,59,64,
            69,74,79,84,89,94,99,104,109,114,
            119,124,129,134,139,144,149,154,159,22,
            164,168,227,231,235,239,243,247,251,255,
            259,263,267,271,277,294,40,47,172,213,
            281,47,197,197,285,31,220,298,298,306,
            306,314,314,314,314,328,328,336,336,336,
            220
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            6,20,6,6,193,6,6,6,6,6,
            6,6,6,6,6,6,6,6,6,6,
            6,6,6,6,6,6,6,6,6,27,
            6,6,6,6,6,6,6,6,6,6,
            6,6,6,275,275,6,44,51,176,217,
            51,51,193,201,6,34,217,300,303,308,
            311,316,319,322,325,330,333,338,341,344,
            222
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            84,32,84,10,84,77,77,8,7,7,
            7,7,7,7,7,7,7,7,7,7,
            7,7,7,7,7,7,7,62,62,32,
            48,49,83,83,83,83,83,83,83,83,
            83,83,83,16,15,10,26,64,44,46,
            12,12,84,84,11,32,46,28,28,30,
            30,34,34,34,34,36,36,38,38,38,
            46
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            2,94,2,2,71,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,93,
            2,2,2,2,2,2,2,2,2,2,
            2,2,2,80,80,2,96,75,4,71,
            75,75,71,84,2,92,71,17,16,35,
            34,21,20,19,18,5,4,28,27,26,
            36
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            2,15,2,8,2,4,4,7,6,6,
            6,6,6,6,6,6,6,6,6,6,
            6,6,6,6,6,6,6,1,1,15,
            92,92,2,2,2,2,2,2,2,2,
            2,2,2,8,8,8,11,1,100,80,
            8,8,2,2,8,15,80,13,13,15,
            15,19,19,19,19,21,21,24,24,24,
            80
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            164,1,101,88,0,12,0,164,1,101,
            87,0,138,93,138,92,138,70,0,45,
            0,138,92,138,70,0,44,109,45,0,
            138,70,0,43,109,44,109,45,0,186,
            143,68,0,52,109,0,142,81,101,0,
            16,0,0,144,1,141,105,0,144,1,
            141,28,0,144,1,141,27,0,144,1,
            141,26,0,144,1,141,21,0,144,1,
            141,20,0,144,1,141,19,0,144,1,
            141,18,0,144,1,141,17,0,144,1,
            141,16,0,144,1,141,34,0,144,1,
            141,5,0,144,1,141,4,0,144,1,
            141,53,0,144,1,141,52,0,144,1,
            141,54,0,144,1,141,55,0,144,1,
            141,57,0,144,1,141,56,0,144,1,
            141,101,0,144,1,141,51,0,144,1,
            141,35,0,184,1,59,0,146,1,103,
            0,146,24,3,0,7,109,0,138,71,
            143,84,143,1,38,0,143,84,143,1,
            38,0,18,109,12,0,143,1,38,0,
            22,108,18,109,12,0,138,71,143,1,
            38,0,143,36,143,0,18,109,0,143,
            0,19,108,18,109,0,145,1,49,0,
            145,1,48,0,145,1,47,0,145,1,
            46,0,145,1,45,0,145,1,44,0,
            145,1,42,0,145,1,43,0,145,1,
            41,0,145,1,40,0,145,1,39,0,
            180,69,59,0,14,0,178,69,103,0,
            142,81,104,0,138,1,0,144,1,101,
            67,102,0,144,1,60,0,126,0,4,
            123,0,3,123,0,130,0,2,121,0,
            1,121,0,132,0,9,118,0,8,118,
            0,6,118,0,5,118,0,134,0,10,
            116,0,7,116,0,136,0,48,114,0,
            47,114,0,46,114,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            338,404,0,3900,0,404,338,3842,3817,3792,
            3765,3738,3709,3680,3647,3614,3581,3548,3513,3478,
            3441,3404,3367,3286,3244,2306,3202,3160,3118,3076,
            2128,2082,424,357,2262,1519,3034,2992,1457,2950,
            2908,2866,2824,2782,1411,1365,2740,1319,1273,1227,
            1181,1135,1089,1043,997,951,905,859,813,767,
            721,675,629,583,537,3328,491,2218,2174,276,
            2698,2656,2614,2572,2530,2488,2446,2404,2362,2035,
            1988,1941,1894,1847,1800,1753,1706,1659,1612,1565,
            0,3883,3965,3868,3958,3924,3902,3895,0,857,
            811,765,2035,1988,1941,1894,1847,1800,1753,1706,
            1659,1612,1565,719,3979,673,3967,627,581,3960,
            3955,535,3889,3867,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,172,3,167,170,6,78,77,166,171,
            90,189,73,169,24,22,23,149,149,149,
            79,76,102,174,102,146,102,103,59,24,
            24,24,24,24,149,149,190,67,169,192,
            67,166,4,1,1,68,51,35,1,105,
            58,28,27,26,21,20,19,18,17,34,
            5,4,53,52,54,55,57,56,103,59,
            16,37,3,33,32,31,30,29,104,101,
            102,60,109,126,70,130,134,132,139,136,
            24,24,101,146,184,185,143,138,141,141,
            141,141,141,141,141,141,141,141,141,141,
            141,141,141,141,141,141,141,69,69,141,
            81,81,141,67,1,85,83,88,87,17,
            16,138,35,34,5,4,21,20,19,18,
            95,28,27,26,173,3,24,1,36,186,
            187,36,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,178,138,82,35,179,180,3,1,142,
            142,1,101,144,142,51,35,16,105,101,
            105,38,49,48,47,46,45,44,42,43,
            41,40,39,101,101,92,126,126,132,132,
            136,134,134,134,4,24,1,146,156,158,
            96,36,144,177,102,144,144,144,144,144,
            144,144,144,144,144,144,144,144,144,144,
            144,144,86,82,36,36,4,144,36,75,
            75,144,1,141,141,141,81,141,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,138,146,156,167,2,36,144,1,
            1,142,143,145,143,3,145,145,145,145,
            145,145,145,145,145,145,164,89,165,164,
            93,4,2,24,144,144,75,84,71,36,
            71,24,36,138,24,143,138,143,71,71,
            138
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            "@pre",
            "^",
            "^^",
            "?",
            "$empty",
            "NUMERIC_OPERATION",
            "STRING_LITERAL",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "self",
            "inv",
            "pre",
            "post",
            "context",
            "package",
            "endpackage",
            "def",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "body",
            "derive",
            "init",
            "null",
            "attr",
            "oper",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "iterate",
            "forAll",
            "exists",
            "isUnique",
            "any",
            "one",
            "collect",
            "select",
            "reject",
            "collectNested",
            "sortedBy",
            "closure",
            "oclIsKindOf",
            "oclIsTypeOf",
            "oclAsType",
            "oclIsNew",
            "oclIsUndefined",
            "oclIsInvalid",
            "oclIsInState",
            "allInstances",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "Invalid",
            "OclMessage",
            "OclInvalid",
            "EOF_TOKEN",
            "IDENTIFIER",
            "INTEGER_RANGE_START",
            "ERROR_TOKEN",
            "keywordAsIdentifier1",
            "keywordAsIdentifier",
            "operationCS1",
            "operationCS2",
            "pathNameCS",
            "simpleNameCS",
            "parametersCS",
            "variableCS",
            "oclExpressionCS",
            "impliesExpCS",
            "andOrXorExpCS",
            "andOrXorWithLet",
            "equalityExpCS",
            "equalityWithLet",
            "relationalExpCS",
            "relationalWithLet",
            "ifExpCSPrec",
            "additiveWithLet",
            "additiveExpCS",
            "multiplicativeExpCS",
            "multiplicativeWithLet",
            "unaryExpCS",
            "unaryWithLet",
            "dotArrowExpCS",
            "callExpCS",
            "messageExpCS",
            "keywordOperationCallExpCS",
            "argumentsCS",
            "collectionTypeIdentifierCS",
            "collectionLiteralPartsCS",
            "collectionLiteralPartCS",
            "variableListCS2",
            "featureCallExpCS",
            "loopExpCS",
            "iterContents",
            "typeCS",
            "variableCS2",
            "variableListCS",
            "letExpSubCS",
            "oclMessageArgumentsCS",
            "oclMessageArgCS",
            "packageDeclarationCSm",
            "invOrDefCS",
            "prePostOrBodyDeclCS",
            "initOrDerValueCS",
            "packageDeclarationCS",
            "contextDeclCSm",
            "contextDeclCS",
            "defExpressionCS",
            "prePostOrBodyDeclCSm"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final static int
           ERROR_SYMBOL      = 99,
           SCOPE_UBOUND      = 70,
           SCOPE_SIZE        = 71,
           MAX_NAME_LENGTH   = 26;

    public final int getErrorSymbol() { return ERROR_SYMBOL; }
    public final int getScopeUbound() { return SCOPE_UBOUND; }
    public final int getScopeSize() { return SCOPE_SIZE; }
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int
           NUM_STATES        = 321,
           NT_OFFSET         = 99,
           LA_STATE_OFFSET   = 4378,
           MAX_LA            = 2,
           NUM_RULES         = 275,
           NUM_NONTERMINALS  = 95,
           NUM_SYMBOLS       = 194,
           SEGMENT_SIZE      = 8192,
           START_STATE       = 3867,
           IDENTIFIER_SYMBOL = 3,
           EOFT_SYMBOL       = 74,
           EOLT_SYMBOL       = 74,
           ACCEPT_ACTION     = 4102,
           ERROR_ACTION      = 4103;

    public final static boolean BACKTRACK = false;

    public final int getNumStates() { return NUM_STATES; }
    public final int getNtOffset() { return NT_OFFSET; }
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }
    public final int getMaxLa() { return MAX_LA; }
    public final int getNumRules() { return NUM_RULES; }
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }
    public final int getNumSymbols() { return NUM_SYMBOLS; }
    public final int getSegmentSize() { return SEGMENT_SIZE; }
    public final int getStartState() { return START_STATE; }
    public final int getStartSymbol() { return lhs[0]; }
    public final int getIdentifierSymbol() { return IDENTIFIER_SYMBOL; }
    public final int getEoftSymbol() { return EOFT_SYMBOL; }
    public final int getEoltSymbol() { return EOLT_SYMBOL; }
    public final int getAcceptAction() { return ACCEPT_ACTION; }
    public final int getErrorAction() { return ERROR_ACTION; }
    public final boolean isValidForParser() { return isValidForParser; }
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
