/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.utilities.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.utilities.impl.Bag;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public class CollectionFactory {
    private static CollectionFactory instance = null;

    public static CollectionFactory getInstance() {
        if (instance == null) {
            instance = new CollectionFactory();
        }
        return instance;
    }

    public Collection createCollection(int kind) {
        switch (kind) {
            case 2: {
                return new HashSet();
            }
            case 4: {
                return new ArrayList();
            }
            case 5: {
                return new LinkedHashSet();
            }
            case 3: {
                return new Bag();
            }
        }
        String message = OCLMessages.bind((String)OCLMessages.OCLCollectionKindNotImpl_ERROR_, (Object)new Integer(kind));
        IllegalArgumentException error = new IllegalArgumentException(message);
        OCLPlugin.throwing(this.getClass(), "typeCompare", error);
        throw error;
    }

    public Collection createCollection(int kind, Collection c) {
        switch (kind) {
            case 2: {
                return new HashSet(c);
            }
            case 4: {
                return new ArrayList(c);
            }
            case 3: {
                return new Bag(c);
            }
            case 5: {
                return new LinkedHashSet(c);
            }
        }
        String message = OCLMessages.bind((String)OCLMessages.OCLCollectionKindNotImpl_ERROR_, (Object)new Integer(kind));
        IllegalArgumentException error = new IllegalArgumentException(message);
        OCLPlugin.throwing(this.getClass(), "typeCompare", error);
        throw error;
    }
}

