/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

class DAAdvertisement
extends ReplyMessage {
    int errorCode;
    int statelessBootTimestamp;
    String url;
    List scopeList;
    List attrList;
    String spi;
    private String origURL;
    private String origAttrs;
    private String origScopes;
    AuthenticationBlock[] authBlocks;

    DAAdvertisement(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        int n;
        this.errorCode = dataInputStream.readShort();
        this.statelessBootTimestamp = dataInputStream.readInt();
        this.origURL = dataInputStream.readUTF().trim();
        if (!this.origURL.equals("")) {
            this.url = this.origURL.substring(this.origURL.indexOf("//") + 2, this.origURL.length());
        }
        if ((n = this.url.indexOf(":")) > -1) {
            this.url = this.url.substring(0, n);
        }
        this.origScopes = dataInputStream.readUTF();
        this.scopeList = SLPMessage.stringToList(this.origScopes, ",");
        if (this.scopeList.isEmpty()) {
            throw new ServiceLocationException(2, "received DAadvert with empty scope list");
        }
        this.origAttrs = dataInputStream.readUTF();
        this.attrList = SLPMessage.stringToList(this.origAttrs, ",");
        this.spi = dataInputStream.readUTF();
        this.authBlocks = AuthenticationBlock.parse(dataInputStream);
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "could not verify " + this.toString());
        }
    }

    protected void writeTo(DataOutputStream dataOutputStream) throws IOException {
    }

    int getSize() {
        int n = this.getHeaderSize() + 8 + this.origURL.length() + 2 + this.origScopes.length() + 2 + this.origAttrs.length() + 2 + this.spi.length() + 1;
        for (int i = 0; i < this.authBlocks.length; ++i) {
            n += this.authBlocks[i].getLength();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", errorCode " + this.errorCode);
        stringBuffer.append(", statelessBootTimestamp " + this.statelessBootTimestamp);
        stringBuffer.append(", url " + this.url);
        stringBuffer.append(", scopeList " + this.scopeList);
        stringBuffer.append(", attrList " + this.attrList);
        stringBuffer.append(", spi " + this.spi);
        return stringBuffer.toString();
    }

    boolean verify() throws ServiceLocationException {
        for (int i = 0; i < this.authBlocks.length; ++i) {
            if (!this.authBlocks[i].verify(this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp()))) continue;
            return true;
        }
        return false;
    }

    private byte[] getAuthData(String string, int n) throws ServiceLocationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(this.statelessBootTimestamp);
            dataOutputStream.writeUTF(this.origURL);
            dataOutputStream.writeUTF(this.origScopes);
            dataOutputStream.writeUTF(this.origAttrs);
            dataOutputStream.writeUTF(this.spi);
            dataOutputStream.writeInt(n);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(20, iOException.getMessage());
        }
    }

    List getResult() {
        return this.scopeList;
    }
}

