/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class ServiceDeregistration
extends SLPMessage {
    ServiceURL url;
    List scopeList;
    List attList;

    ServiceDeregistration(ServiceURL serviceURL, List list, List list2, Locale locale) {
        this.funcID = (byte)4;
        this.locale = locale;
        if (serviceURL == null) {
            throw new IllegalArgumentException("serviceURL must not be null");
        }
        this.url = serviceURL;
        this.scopeList = list;
        if (this.scopeList == null) {
            this.scopeList = Arrays.asList("default");
        }
        this.attList = list2;
        if (this.attList == null) {
            this.attList = new ArrayList();
        }
    }

    public ServiceDeregistration(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        this.scopeList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        this.url = ServiceURL.fromBytes(dataInputStream);
        this.attList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "Authentication failed for " + this.toString());
        }
    }

    protected void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        dataOutputStream.writeUTF(SLPMessage.listToString(this.scopeList, ","));
        this.url.writeTo(dataOutputStream);
        dataOutputStream.writeUTF(SLPMessage.listToString(this.attList, ","));
    }

    int getSize() {
        return this.getHeaderSize() + 2 + SLPMessage.listToString(this.scopeList, ",").length() + this.url.getLength() + 2 + SLPMessage.listToString(this.attList, ",").length();
    }

    void sign(List list) throws ServiceLocationException {
        this.url.sign(list);
    }

    boolean verify() throws ServiceLocationException {
        return this.url.verify();
    }
}

