/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackLayoutPanel
extends ResizeComposite
implements HasWidgets,
RequiresResize,
ProvidesResize,
IndexedPanel,
HasBeforeSelectionHandlers<Integer>,
HasSelectionHandlers<Integer> {
    private static final String WIDGET_STYLE = "gwt-StackLayoutPanel";
    private static final String CONTENT_STYLE = "gwt-StackLayoutPanelContent";
    private static final String HEADER_STYLE = "gwt-StackLayoutPanelHeader";
    private static final int ANIMATION_TIME = 250;
    private LayoutPanel layoutPanel;
    private Style.Unit unit;
    private ArrayList<LayoutData> layoutData = new ArrayList();
    private int selectedIndex = -1;

    public StackLayoutPanel(Style.Unit unit) {
        this.unit = unit;
        this.layoutPanel = new LayoutPanel();
        this.initWidget(this.layoutPanel);
        this.setStyleName(WIDGET_STYLE);
    }

    @Override
    public void add(Widget w) {
        assert (false) : "Single-argument add() is not supported for this widget";
    }

    public void add(Widget widget, String header, boolean asHtml, double headerSize) {
        this.insert(widget, header, asHtml, headerSize, this.getWidgetCount());
    }

    public void add(Widget widget, String header, double headerSize) {
        this.insert(widget, header, headerSize, this.getWidgetCount());
    }

    public void add(Widget widget, Widget header, double headerSize) {
        this.insert(widget, header, headerSize, this.getWidgetCount());
    }

    @Override
    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.addHandler(handler, BeforeSelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    public void clear() {
        this.layoutPanel.clear();
        this.layoutData.clear();
        this.selectedIndex = -1;
    }

    public Widget getHeaderWidget(int index) {
        this.checkIndex(index);
        return this.layoutData.get((int)index).header.getWidget();
    }

    public Widget getHeaderWidget(Widget child) {
        this.checkChild(child);
        return this.getHeaderWidget(this.getWidgetIndex(child));
    }

    public int getVisibleIndex() {
        return this.selectedIndex;
    }

    public Widget getVisibleWidget() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.getWidget(this.selectedIndex);
    }

    @Override
    public Widget getWidget(int index) {
        return this.layoutPanel.getWidget(index * 2 + 1);
    }

    @Override
    public int getWidgetCount() {
        return this.layoutPanel.getWidgetCount() / 2;
    }

    @Override
    public int getWidgetIndex(Widget child) {
        int index = this.layoutPanel.getWidgetIndex(child);
        if (index == -1) {
            return index;
        }
        return (index - 1) / 2;
    }

    public void insert(Widget child, String text, boolean asHtml, double headerSize, int beforeIndex) {
        HTML contents = new HTML();
        if (asHtml) {
            contents.setHTML(text);
        } else {
            contents.setText(text);
        }
        this.insert(child, contents, headerSize, beforeIndex);
    }

    public void insert(Widget child, String text, double headerSize, int beforeIndex) {
        this.insert(child, text, false, headerSize, beforeIndex);
    }

    public void insert(Widget child, Widget header, double headerSize, int beforeIndex) {
        this.insert(child, new Header(header), headerSize, beforeIndex);
    }

    @Override
    public Iterator<Widget> iterator() {
        return new Iterator<Widget>(){
            int i = 0;
            int last = -1;

            @Override
            public boolean hasNext() {
                return this.i < StackLayoutPanel.this.layoutData.size();
            }

            @Override
            public Widget next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.i++;
                return ((LayoutData)((StackLayoutPanel)StackLayoutPanel.this).layoutData.get((int)this.last)).widget;
            }

            @Override
            public void remove() {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                StackLayoutPanel.this.remove(((LayoutData)((StackLayoutPanel)StackLayoutPanel.this).layoutData.get((int)this.last)).widget);
                this.i = this.last;
                this.last = -1;
            }
        };
    }

    @Override
    public void onResize() {
        this.layoutPanel.onResize();
    }

    @Override
    public boolean remove(int index) {
        return this.remove(this.getWidget(index));
    }

    @Override
    public boolean remove(Widget child) {
        if (child.getParent() != this.layoutPanel) {
            return false;
        }
        for (int i = 0; i < this.layoutData.size(); ++i) {
            LayoutData data = this.layoutData.get(i);
            if (data.widget != child) continue;
            this.layoutPanel.remove(data.header);
            this.layoutPanel.remove(data.widget);
            data.header.removeStyleName(HEADER_STYLE);
            data.widget.removeStyleName(CONTENT_STYLE);
            this.layoutData.remove(i);
            if (this.selectedIndex == i) {
                this.selectedIndex = -1;
                if (this.layoutData.size() > 0) {
                    this.showWidget(this.layoutData.get((int)0).widget);
                }
            }
            return true;
        }
        return false;
    }

    public void setHeaderHTML(int index, String html) {
        this.checkIndex(index);
        LayoutData data = this.layoutData.get(index);
        Widget headerWidget = data.header.getWidget();
        assert (headerWidget instanceof HasHTML) : "Header widget does not implement HasHTML";
        ((HasHTML)((Object)headerWidget)).setHTML(html);
    }

    public void setHeaderText(int index, String text) {
        this.checkIndex(index);
        LayoutData data = this.layoutData.get(index);
        Widget headerWidget = data.header.getWidget();
        assert (headerWidget instanceof HasText) : "Header widget does not implement HasText";
        ((HasText)((Object)headerWidget)).setText(text);
    }

    public void showWidget(int index) {
        this.checkIndex(index);
        this.showWidget(index, 250);
    }

    public void showWidget(Widget child) {
        this.checkChild(child);
        this.showWidget(this.getWidgetIndex(child), 250);
    }

    @Override
    protected void onLoad() {
        this.animate(0);
    }

    private void animate(int duration) {
        int i;
        if (this.layoutData.size() == 0) {
            return;
        }
        double top = 0.0;
        double bottom = 0.0;
        for (i = 0; i < this.layoutData.size(); ++i) {
            LayoutData data = this.layoutData.get(i);
            this.layoutPanel.setWidgetTopHeight(data.header, top, this.unit, data.headerSize, this.unit);
            this.layoutPanel.setWidgetTopHeight(data.widget, top += data.headerSize, this.unit, 0.0, this.unit);
            if (i == this.selectedIndex) break;
        }
        for (int j = this.layoutData.size() - 1; j > i; --j) {
            LayoutData data = this.layoutData.get(j);
            this.layoutPanel.setWidgetBottomHeight(data.header, bottom, this.unit, data.headerSize, this.unit);
            this.layoutPanel.setWidgetBottomHeight(data.widget, bottom, this.unit, 0.0, this.unit);
            bottom += data.headerSize;
        }
        LayoutData data = this.layoutData.get(this.selectedIndex);
        this.layoutPanel.setWidgetTopBottom(data.widget, top, this.unit, bottom, this.unit);
        this.layoutPanel.animate(duration);
    }

    private void checkChild(Widget child) {
        assert (this.layoutPanel.getChildren().contains(child));
    }

    private void checkIndex(int index) {
        assert (index >= 0 && index < this.getWidgetCount()) : "Index out of bounds";
    }

    private void insert(final Widget child, Header header, double headerSize, int beforeIndex) {
        assert (beforeIndex >= 0 && beforeIndex <= this.getWidgetCount()) : "beforeIndex out of bounds";
        int idx = this.getWidgetIndex(child);
        if (idx != -1) {
            this.remove(child);
            if (idx < beforeIndex) {
                --beforeIndex;
            }
        }
        this.layoutPanel.insert(child, beforeIndex *= 2);
        this.layoutPanel.insert(header, beforeIndex);
        this.layoutPanel.setWidgetLeftRight(header, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        this.layoutPanel.setWidgetLeftRight(child, 0.0, Style.Unit.PX, 0.0, Style.Unit.PX);
        LayoutData data = new LayoutData(child, header, headerSize);
        this.layoutData.add(data);
        header.addStyleName(HEADER_STYLE);
        child.addStyleName(CONTENT_STYLE);
        header.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StackLayoutPanel.this.showWidget(child);
            }
        });
        if (this.selectedIndex == -1) {
            this.showWidget(0);
        }
        if (this.isAttached()) {
            this.animate(250);
        }
    }

    private void showWidget(int index, int duration) {
        this.checkIndex(index);
        if (index == this.selectedIndex) {
            return;
        }
        BeforeSelectionEvent<Integer> event = BeforeSelectionEvent.fire(this, index);
        if (event != null && event.isCanceled()) {
            return;
        }
        this.selectedIndex = index;
        if (this.isAttached()) {
            this.animate(duration);
        }
        SelectionEvent.fire(this, index);
    }

    private class Header
    extends Composite
    implements HasClickHandlers {
        public Header(Widget child) {
            this.initWidget(child);
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addDomHandler(handler, ClickEvent.getType());
        }
    }

    private static class LayoutData {
        public double headerSize;
        public Header header;
        public Widget widget;

        public LayoutData(Widget widget, Header header, double headerSize) {
            this.widget = widget;
            this.header = header;
            this.headerSize = headerSize;
        }
    }
}

