/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.derby.iapi.db.ConsistencyChecker;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.db.PropertyInfo;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.load.Export;
import org.apache.derby.impl.load.Import;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.jdbc.InternalDriver;

public class SystemProcedures {
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;
    private static final String DRIVER_TYPE_OPTION = "DATATYPE";
    private static final String ODBC_DRIVER_OPTION = "'ODBC'";
    public static String SQLERRMC_MESSAGE_DELIMITER = new String(new char[]{'\u0014', '\u0014', '\u0014'});
    private static final double LOG10 = StrictMath.log(10.0);

    public static void SQLCAMESSAGE(int sqlcode, short errmcLen, String sqlerrmc, String sqlerrp, int errd0, int errd1, int errd2, int errd3, int errd4, int errd5, String warn, String sqlState, String file, String localeStr, String[] msg, int[] rc) {
        int numMessages = 1;
        int index = 0;
        while (sqlerrmc.indexOf(SQLERRMC_MESSAGE_DELIMITER, index) != -1) {
            index = sqlerrmc.indexOf(SQLERRMC_MESSAGE_DELIMITER, index) + SQLERRMC_MESSAGE_DELIMITER.length();
            ++numMessages;
        }
        if (numMessages == 1) {
            MessageService.getLocalizedMessage(sqlcode, errmcLen, sqlerrmc, sqlerrp, errd0, errd1, errd2, errd3, errd4, errd5, warn, sqlState, file, localeStr, msg, rc);
        } else {
            int startIdx = 0;
            String[] errMsg = new String[2];
            for (int i = 0; i < numMessages; ++i) {
                int endIdx = sqlerrmc.indexOf(SQLERRMC_MESSAGE_DELIMITER, startIdx);
                String sqlError = i == numMessages - 1 ? sqlerrmc.substring(startIdx) : sqlerrmc.substring(startIdx, endIdx);
                if (i > 0) {
                    sqlState = sqlError.substring(0, 5);
                    sqlError = sqlError.substring(6);
                    msg[0] = msg[0] + " SQLSTATE: " + sqlState + ": ";
                }
                MessageService.getLocalizedMessage(sqlcode, (short)sqlError.length(), sqlError, sqlerrp, errd0, errd1, errd2, errd3, errd4, errd5, warn, sqlState, file, localeStr, errMsg, rc);
                if (rc[0] == 0) {
                    msg[0] = i == 0 ? errMsg[0] : msg[0] + errMsg[0];
                }
                startIdx = endIdx + SQLERRMC_MESSAGE_DELIMITER.length();
            }
        }
    }

    private static Connection getDefaultConn() throws SQLException {
        Connection conn;
        InternalDriver id = InternalDriver.activeDriver();
        if (id != null && (conn = id.connect("jdbc:default:connection", null)) != null) {
            return conn;
        }
        throw Util.noCurrentConnection();
    }

    private static DatabaseMetaData getDMD() throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        return conn.getMetaData();
    }

    public static void SQLPROCEDURES(String catalogName, String schemaName, String procName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProceduresForODBC(catalogName, schemaName, procName) : SystemProcedures.getDMD().getProcedures(catalogName, schemaName, procName);
    }

    public static void SQLFUNCTIONS(String catalogName, String schemaName, String funcName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctions(catalogName, schemaName, funcName);
    }

    public static void SQLTABLES(String catalogName, String schemaName, String tableName, String tableType, String options, ResultSet[] rs) throws SQLException {
        String optionValue = SystemProcedures.getOption("GETCATALOGS", options);
        if (optionValue != null && optionValue.trim().equals("1")) {
            rs[0] = SystemProcedures.getDMD().getCatalogs();
            return;
        }
        optionValue = SystemProcedures.getOption("GETTABLETYPES", options);
        if (optionValue != null && optionValue.trim().equals("1")) {
            rs[0] = SystemProcedures.getDMD().getTableTypes();
            return;
        }
        optionValue = SystemProcedures.getOption("GETSCHEMAS", options);
        if (optionValue != null) {
            if ((optionValue = optionValue.trim()).equals("1")) {
                rs[0] = SystemProcedures.getDMD().getSchemas();
                return;
            }
            if (optionValue.equals("2")) {
                EmbedDatabaseMetaData edmd = (EmbedDatabaseMetaData)SystemProcedures.getDMD();
                rs[0] = edmd.getSchemas(catalogName, schemaName);
                return;
            }
        }
        String[] typeArray = null;
        if (tableType != null) {
            StringTokenizer st = new StringTokenizer(tableType, "',");
            typeArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                typeArray[i] = st.nextToken();
                ++i;
            }
        }
        rs[0] = SystemProcedures.getDMD().getTables(catalogName, schemaName, tableName, typeArray);
    }

    public static void SQLFOREIGNKEYS(String pkCatalogName, String pkSchemaName, String pkTableName, String fkCatalogName, String fkSchemaName, String fkTableName, String options, ResultSet[] rs) throws SQLException {
        String exportedKeyProp = SystemProcedures.getOption("EXPORTEDKEY", options);
        String importedKeyProp = SystemProcedures.getOption("IMPORTEDKEY", options);
        rs[0] = importedKeyProp != null && importedKeyProp.trim().equals("1") ? SystemProcedures.getDMD().getImportedKeys(fkCatalogName, fkSchemaName, fkTableName) : (exportedKeyProp != null && exportedKeyProp.trim().equals("1") ? SystemProcedures.getDMD().getExportedKeys(pkCatalogName, pkSchemaName, pkTableName) : (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getCrossReferenceForODBC(pkCatalogName, pkSchemaName, pkTableName, fkCatalogName, fkSchemaName, fkTableName) : SystemProcedures.getDMD().getCrossReference(pkCatalogName, pkSchemaName, pkTableName, fkCatalogName, fkSchemaName, fkTableName)));
    }

    private static String getOption(String pattern, String options) {
        if (options == null) {
            return null;
        }
        int start = options.lastIndexOf(pattern);
        if (start < 0) {
            return null;
        }
        int valueStart = options.indexOf(61, start);
        if (valueStart < 0) {
            return null;
        }
        int valueEnd = options.indexOf(59, valueStart);
        if (valueEnd < 0) {
            return options.substring(valueStart + 1);
        }
        return options.substring(valueStart + 1, valueEnd);
    }

    public static void SQLPROCEDURECOLS(String catalogName, String schemaName, String procName, String paramName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProcedureColumnsForODBC(catalogName, schemaName, procName, paramName) : SystemProcedures.getDMD().getProcedureColumns(catalogName, schemaName, procName, paramName);
    }

    public static void SQLFUNCTIONPARAMS(String catalogName, String schemaName, String funcName, String paramName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctionColumns(catalogName, schemaName, funcName, paramName);
    }

    public static void SQLCOLUMNS(String catalogName, String schemaName, String tableName, String columnName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getColumnsForODBC(catalogName, schemaName, tableName, columnName) : SystemProcedures.getDMD().getColumns(catalogName, schemaName, tableName, columnName);
    }

    public static void SQLCOLPRIVILEGES(String catalogName, String schemaName, String tableName, String columnName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getColumnPrivileges(catalogName, schemaName, tableName, columnName);
    }

    public static void SQLTABLEPRIVILEGES(String catalogName, String schemaName, String tableName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getTablePrivileges(catalogName, schemaName, tableName);
    }

    public static void SQLPRIMARYKEYS(String catalogName, String schemaName, String tableName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getPrimaryKeys(catalogName, schemaName, tableName);
    }

    public static void SQLGETTYPEINFO(short dataType, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getTypeInfoForODBC() : SystemProcedures.getDMD().getTypeInfo();
    }

    public static void SQLSTATISTICS(String catalogName, String schemaName, String tableName, short unique, short approximate, String options, ResultSet[] rs) throws SQLException {
        boolean boolUnique = unique == 0;
        boolean boolApproximate = approximate == 1;
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getIndexInfoForODBC(catalogName, schemaName, tableName, boolUnique, boolApproximate) : SystemProcedures.getDMD().getIndexInfo(catalogName, schemaName, tableName, boolUnique, boolApproximate);
    }

    public static void SQLSPECIALCOLUMNS(short colType, String catalogName, String schemaName, String tableName, short scope, short nullable, String options, ResultSet[] rs) throws SQLException {
        boolean boolNullable;
        boolean bl = boolNullable = nullable == 1;
        rs[0] = colType == 1 ? (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getBestRowIdentifierForODBC(catalogName, schemaName, tableName, scope, boolNullable) : SystemProcedures.getDMD().getBestRowIdentifier(catalogName, schemaName, tableName, scope, boolNullable)) : (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getVersionColumnsForODBC(catalogName, schemaName, tableName) : SystemProcedures.getDMD().getVersionColumns(catalogName, schemaName, tableName));
    }

    public static void SQLUDTS(String catalogName, String schemaPattern, String typeNamePattern, String udtTypes, String options, ResultSet[] rs) throws SQLException {
        int[] types = null;
        if (udtTypes != null && udtTypes.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(udtTypes, " \t\n\t,");
            int udtTypeCount = tokenizer.countTokens();
            types = new int[udtTypeCount];
            String udtType = "";
            try {
                for (int i = 0; i < udtTypeCount; ++i) {
                    udtType = tokenizer.nextToken();
                    types[i] = Integer.parseInt(udtType);
                }
            }
            catch (NumberFormatException nfe) {
                throw new SQLException("Invalid type, " + udtType + ", passed to getUDTs.");
            }
            catch (NoSuchElementException nsee) {
                throw new SQLException("Internal failure: NoSuchElementException in getUDTs.");
            }
        }
        rs[0] = SystemProcedures.getDMD().getUDTs(catalogName, schemaPattern, typeNamePattern, types);
    }

    public static void METADATA(ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getClientCachedMetaData();
    }

    private static boolean isForODBC(String options) {
        String optionValue = SystemProcedures.getOption(DRIVER_TYPE_OPTION, options);
        return optionValue != null && optionValue.toUpperCase().equals(ODBC_DRIVER_OPTION);
    }

    public static void SYSCS_SET_DATABASE_PROPERTY(String key, String value) throws SQLException {
        PropertyInfo.setDatabaseProperty(key, value);
    }

    public static String SYSCS_GET_DATABASE_PROPERTY(String key) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        try {
            return PropertyUtil.getDatabaseProperty(lcc.getTransactionExecute(), key);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void SYSCS_UPDATE_STATISTICS(String schemaname, String tablename, String indexname) throws SQLException {
        String escapedSchema = IdUtil.normalToDelimited(schemaname);
        String escapedTableName = IdUtil.normalToDelimited(tablename);
        String query = "alter table " + escapedSchema + "." + escapedTableName;
        query = indexname == null ? query + " all update statistics " : query + " update statistics " + IdUtil.normalToDelimited(indexname);
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void SYSCS_COMPRESS_TABLE(String schema, String tablename, short sequential) throws SQLException {
        String escapedSchema = IdUtil.normalToDelimited(schema);
        String escapedTableName = IdUtil.normalToDelimited(tablename);
        String query = "alter table " + escapedSchema + "." + escapedTableName + " compress" + (sequential != 0 ? " sequential" : "");
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void SYSCS_FREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().freeze();
    }

    public static void SYSCS_UNFREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().unfreeze();
    }

    public static void SYSCS_CHECKPOINT_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().checkpoint();
    }

    public static void SYSCS_BACKUP_DATABASE(String backupDir) throws SQLException {
        Factory.getDatabaseOfConnection().backup(backupDir, true);
    }

    public static void SYSCS_BACKUP_DATABASE_NOWAIT(String backupDir) throws SQLException {
        Factory.getDatabaseOfConnection().backup(backupDir, false);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(String backupDir, short deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles != 0, true);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(String backupDir, short deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles != 0, false);
    }

    public static void SYSCS_DISABLE_LOG_ARCHIVE_MODE(short deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().disableLogArchiveMode(deleteOnlineArchivedLogFiles != 0);
    }

    public static void SYSCS_SET_RUNTIMESTATISTICS(short enable) throws SQLException {
        ConnectionUtil.getCurrentLCC().setRunTimeStatisticsMode(enable != 0);
    }

    public static void SYSCS_SET_STATISTICS_TIMING(short enable) throws SQLException {
        ConnectionUtil.getCurrentLCC().setStatisticsTiming(enable != 0);
    }

    public static int SYSCS_CHECK_TABLE(String schema, String tablename) throws SQLException {
        boolean ret_val = ConsistencyChecker.checkTable(schema, tablename);
        return ret_val ? 1 : 0;
    }

    public static void SYSCS_INPLACE_COMPRESS_TABLE(String schema, String tablename, short purgeRows, short defragmentRows, short truncateEnd) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            DataDictionary data_dictionary = lcc.getDataDictionary();
            SchemaDescriptor sd = data_dictionary.getSchemaDescriptor(schema, tc, true);
            TableDescriptor td = data_dictionary.getTableDescriptor(tablename, sd, tc);
            if (td != null && td.getTableType() == 5) {
                return;
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        String escapedSchema = IdUtil.normalToDelimited(schema);
        String escapedTableName = IdUtil.normalToDelimited(tablename);
        String query = "alter table " + escapedSchema + "." + escapedTableName + " compress inplace" + (purgeRows != 0 ? " purge" : "") + (defragmentRows != 0 ? " defragment" : "") + (truncateEnd != 0 ? " truncate_end" : "");
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static String SYSCS_GET_RUNTIMESTATISTICS() throws SQLException {
        RunTimeStatistics rts = ConnectionUtil.getCurrentLCC().getRunTimeStatisticsObject();
        if (rts == null) {
            return null;
        }
        return rts.toString();
    }

    public static void INSTALL_JAR(String url, String jar, int deploy) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.install(lcc, schemaName, sqlName, url);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REPLACE_JAR(String url, String jar) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.replace(lcc, schemaName, sqlName, url);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REMOVE_JAR(String jar, int undeploy) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.drop(lcc, schemaName, sqlName);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static void checkJarSQLName(String sqlName) throws StandardException {
        if (sqlName.length() == 0 || sqlName.indexOf(58) != -1) {
            throw StandardException.newException("XCXA0.S");
        }
    }

    public static void SYSCS_EXPORT_TABLE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset);
        conn.commit();
    }

    public static void SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, String lobsFileName) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, lobsFileName);
        conn.commit();
    }

    public static void SYSCS_EXPORT_QUERY(String selectStatement, String fileName, String columnDelimiter, String characterDelimiter, String codeset) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportQuery(conn, selectStatement, fileName, columnDelimiter, characterDelimiter, codeset);
        conn.commit();
    }

    public static void SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE(String selectStatement, String fileName, String columnDelimiter, String characterDelimiter, String codeset, String lobsFileName) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportQuery(conn, selectStatement, fileName, columnDelimiter, characterDelimiter, codeset, lobsFileName);
        conn.commit();
    }

    public static void SYSCS_IMPORT_TABLE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, false);
        }
        catch (SQLException se) {
            conn.rollback();
            throw se;
        }
        conn.commit();
    }

    public static void SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, true);
        }
        catch (SQLException se) {
            conn.rollback();
            throw se;
        }
        conn.commit();
    }

    public static void SYSCS_IMPORT_DATA(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, false);
        }
        catch (SQLException se) {
            conn.rollback();
            throw se;
        }
        conn.commit();
    }

    public static void SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, true);
        }
        catch (SQLException se) {
            conn.rollback();
            throw se;
        }
        conn.commit();
    }

    public static void SYSCS_BULK_INSERT(String schemaName, String tableName, String vtiName, String vtiArg) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        String entityName = IdUtil.normalToDelimited(tableName);
        if (schemaName != null) {
            entityName = IdUtil.normalToDelimited(schemaName) + "." + entityName;
        }
        String binsertSql = "insert into " + entityName + " --DERBY-PROPERTIES insertMode=bulkInsert \n" + "select * from new " + IdUtil.normalToDelimited(vtiName) + "(" + StringUtil.quoteStringLiteral(schemaName) + ", " + StringUtil.quoteStringLiteral(tableName) + ", " + StringUtil.quoteStringLiteral(vtiArg) + ")" + " as t";
        PreparedStatement ps = conn.prepareStatement(binsertSql);
        ps.executeUpdate();
        ps.close();
    }

    public static void SYSCS_RELOAD_SECURITY_POLICY() throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        catch (SecurityException se) {
            throw Util.policyNotReloaded(se);
        }
    }

    public static double PI() {
        return StrictMath.PI;
    }

    public static double LOG10(double value) {
        return StrictMath.log(value) / LOG10;
    }

    public static double COT(double value) {
        return 1.0 / StrictMath.tan(value);
    }

    public static double COSH(double value) {
        return (StrictMath.exp(value) + StrictMath.exp(-value)) / 2.0;
    }

    public static double SINH(double value) {
        return (StrictMath.exp(value) - StrictMath.exp(-value)) / 2.0;
    }

    public static double TANH(double value) {
        return (StrictMath.exp(value) - StrictMath.exp(-value)) / (StrictMath.exp(value) + StrictMath.exp(-value));
    }

    public static int SIGN(double value) {
        return value < 0.0 ? -1 : (value > 0.0 ? 1 : 0);
    }

    public static double RAND(int seed) {
        return new Random(seed).nextDouble();
    }

    public static void SYSCS_SET_USER_ACCESS(String userName, String connectionPermission) throws SQLException {
        try {
            String addListProperty;
            if (userName == null) {
                throw StandardException.newException("28502", userName);
            }
            if ("FULLACCESS".equals(connectionPermission)) {
                addListProperty = "derby.database.fullAccessUsers";
            } else if ("READONLYACCESS".equals(connectionPermission)) {
                addListProperty = "derby.database.readOnlyAccessUsers";
            } else if (connectionPermission == null) {
                addListProperty = null;
            } else {
                throw StandardException.newException("XCZ00.S", connectionPermission);
            }
            SystemProcedures.removeFromAccessList("derby.database.fullAccessUsers", userName);
            SystemProcedures.removeFromAccessList("derby.database.readOnlyAccessUsers", userName);
            if (addListProperty != null) {
                String addList = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY(addListProperty);
                SystemProcedures.SYSCS_SET_DATABASE_PROPERTY(addListProperty, IdUtil.appendNormalToList(userName, addList));
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static void removeFromAccessList(String listProperty, String userName) throws SQLException, StandardException {
        String removeList = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY(listProperty);
        if (removeList != null) {
            SystemProcedures.SYSCS_SET_DATABASE_PROPERTY(listProperty, IdUtil.deleteId(userName, removeList));
        }
    }

    public static String SYSCS_GET_USER_ACCESS(String userName) throws SQLException {
        try {
            if (userName == null) {
                throw StandardException.newException("28502", userName);
            }
            String fullUserList = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.fullAccessUsers");
            if (IdUtil.idOnList(userName, fullUserList)) {
                return "FULLACCESS";
            }
            String readOnlyUserList = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.readOnlyAccessUsers");
            if (IdUtil.idOnList(userName, readOnlyUserList)) {
                return "READONLYACCESS";
            }
            String defaultAccess = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.defaultConnectionMode");
            defaultAccess = defaultAccess != null ? StringUtil.SQLToUpperCase(defaultAccess) : "FULLACCESS";
            return defaultAccess;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void SYSCS_EMPTY_STATEMENT_CACHE() throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        CacheManager statementCache = lcc.getLanguageConnectionFactory().getStatementCache();
        if (statementCache != null) {
            statementCache.ageOut();
        }
    }
}

