/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.FailedProperties40;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.LogicalDatabaseMetaData;
import org.apache.derby.client.am.LogicalDatabaseMetaData40;
import org.apache.derby.client.am.SqlException;

public class LogicalConnection40
extends LogicalConnection {
    public LogicalConnection40(Connection physicalConnection, ClientPooledConnection pooledConnection) throws SqlException {
        super(physicalConnection, pooledConnection);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createArrayOf(typeName, elements);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createBlob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createNClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createSQLXML();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStruct(typeName, attributes);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getClientInfo();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getClientInfo(name);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    protected LogicalDatabaseMetaData newLogicalDatabaseMetaData() throws SQLException {
        return new LogicalDatabaseMetaData40(this, this.physicalConnection_.agent_.logWriter_);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        try {
            if (this.physicalConnection_ == null) {
                return false;
            }
            return this.physicalConnection_.isValid(timeout);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return interfaces.isInstance(this);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setClientInfo(properties);
        }
        catch (SQLClientInfoException cie) {
            this.notifyException(cie);
            throw cie;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw new SQLClientInfoException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new FailedProperties40(properties).getProperties());
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setClientInfo(name, value);
        }
        catch (SQLClientInfoException cie) {
            this.notifyException(cie);
            throw cie;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw new SQLClientInfoException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new FailedProperties40(FailedProperties40.makeProperties(name, value)).getProperties());
        }
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            try {
                return interfaces.cast(this);
            }
            catch (ClassCastException cce) {
                throw new SqlException(null, new ClientMessageId("XJ128.S"), interfaces).getSQLException();
            }
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }
}

