/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.FdocaConstants;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetPackageRequest;
import org.apache.derby.client.net.NetPreparedStatement;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.StatementRequestInterface;

public class NetStatementRequest
extends NetPackageRequest
implements StatementRequestInterface {
    ArrayList extdtaPositions_ = null;
    int overrideLid_ = 80;
    HashMap promototedParameters_ = new HashMap();

    NetStatementRequest(NetAgent netAgent, CcsidManager ccsidManager, int bufferSize) {
        super(netAgent, ccsidManager, bufferSize);
    }

    public void writeExecuteImmediate(NetStatement materialStatement, String sql, Section section) throws SqlException {
        this.buildEXCSQLIMM(section, false, 0L);
        this.buildSQLSTTcommandData(sql);
    }

    public void writePrepareDescribeOutput(NetStatement materialStatement, String sql, Section section) throws SqlException {
        this.buildPRPSQLSTT(section, sql, true, true, 4);
        if (materialStatement.statement_.cursorAttributesToSendOnPrepare_ != null) {
            this.buildSQLATTRcommandData(materialStatement.statement_.cursorAttributesToSendOnPrepare_);
        }
        this.buildSQLSTTcommandData(sql);
    }

    public void writePrepare(NetStatement materialStatement, String sql, Section section) throws SqlException {
        this.buildPRPSQLSTT(section, sql, false, false, 0);
        if (materialStatement.statement_.cursorAttributesToSendOnPrepare_ != null) {
            this.buildSQLATTRcommandData(materialStatement.statement_.cursorAttributesToSendOnPrepare_);
        }
        this.buildSQLSTTcommandData(sql);
    }

    public void writeExecute(NetPreparedStatement materialPreparedStatement, Section section, ColumnMetaData parameterMetaData, Object[] inputs, int numInputColumns, boolean outputExpected, boolean chained) throws SqlException {
        this.buildEXCSQLSTT(section, true, outputExpected, false, null, false, false, 0, false, 0, false, 0, false, 0);
        if (numInputColumns > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean overrideExists = this.buildSQLDTAcommandData(numInputColumns, parameterMetaData, inputs);
            this.buildEXTDTA(parameterMetaData, inputs, chained);
        }
    }

    public void writeOpenQuery(NetPreparedStatement materialPreparedStatement, Section section, int fetchSize, int resultSetType, int numInputColumns, ColumnMetaData parameterMetaData, Object[] inputs) throws SqlException {
        boolean sendQryrowset = this.checkSendQryrowset(fetchSize, resultSetType);
        fetchSize = this.checkFetchsize(fetchSize, resultSetType);
        this.buildOPNQRY(section, sendQryrowset, fetchSize);
        materialPreparedStatement.qryrowsetSentOnOpnqry_ = sendQryrowset;
        if (numInputColumns > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean overrideExists = this.buildSQLDTAcommandData(numInputColumns, parameterMetaData, inputs);
            this.buildEXTDTA(parameterMetaData, inputs, false);
        }
    }

    public void writeOpenQuery(NetStatement materialStatement, Section section, int fetchSize, int resultSetType) throws SqlException {
        boolean sendQryrowset = this.checkSendQryrowset(fetchSize, resultSetType);
        fetchSize = this.checkFetchsize(fetchSize, resultSetType);
        this.buildOPNQRY(section, sendQryrowset, fetchSize);
        materialStatement.qryrowsetSentOnOpnqry_ = sendQryrowset;
    }

    public void writeDescribeInput(NetPreparedStatement materialPreparedStatement, Section section) throws SqlException {
        int typsqlda = 5;
        this.buildDSCSQLSTT(section, true, typsqlda);
    }

    public void writeDescribeOutput(NetPreparedStatement materialPreparedStatement, Section section) throws SqlException {
        this.buildDSCSQLSTT(section, true, 4);
    }

    public void writeExecuteCall(NetStatement materialStatement, boolean outputExpected, String procedureName, Section section, int fetchSize, boolean suppressResultSets, int resultSetType, ColumnMetaData parameterMetaData, Object[] inputs) throws SqlException {
        boolean sendQryrowset = true;
        fetchSize = fetchSize == 0 ? 64 : fetchSize;
        boolean sendPrcnam = procedureName != null;
        int numParameters = parameterMetaData != null ? parameterMetaData.columns_ : 0;
        outputExpected = numParameters > 0;
        this.buildEXCSQLSTT(section, true, outputExpected, sendPrcnam, procedureName, true, !suppressResultSets, 65535, true, -1, true, this.calculateResultSetFlags(), sendQryrowset, fetchSize);
        if (numParameters > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean overrideExists = this.buildSQLDTAcommandData(numParameters, parameterMetaData, inputs);
            this.buildEXTDTA(parameterMetaData, inputs, false);
        }
        materialStatement.qryrowsetSentOnOpnqry_ = sendQryrowset;
    }

    void buildOPNQRY(Section section, boolean sendQueryRowSet, int fetchSize) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8204);
        this.buildPKGNAMCSN(section);
        this.buildQRYBLKSZ();
        if (sendQueryRowSet) {
            this.buildMAXBLKEXT(-1);
            this.buildQRYROWSET(fetchSize);
        }
        if (this.netAgent_.netConnection_.serverSupportsQryclsimp()) {
            this.buildQRYCLSIMP();
        }
        this.updateLengthBytes();
    }

    void buildEXCSQLIMM(Section section, boolean sendQryinsid, long qryinsid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8202);
        this.buildPKGNAMCSN(section);
        this.buildRDBCMTOK();
        if (sendQryinsid) {
            this.buildQRYINSID(qryinsid);
        }
        this.updateLengthBytes();
    }

    void buildPRPSQLSTT(Section section, String sql, boolean sendRtnsqlda, boolean sendTypsqlda, int typsqlda) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8205);
        this.buildPKGNAMCSN(section);
        if (sendRtnsqlda) {
            this.buildRTNSQLDA();
        }
        if (sendTypsqlda) {
            this.buildTYPSQLDA(typsqlda);
        }
        this.updateLengthBytes();
    }

    void buildEXCSQLSET(Section section) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8212);
        this.buildPKGNAMCSN(section);
        this.updateLengthBytes();
    }

    void buildEXCSQLSTT(Section section, boolean sendOutexp, boolean outexp, boolean sendPrcnam, String prcnam, boolean sendQryblksz, boolean sendMaxrslcnt, int maxrslcnt, boolean sendMaxblkext, int maxblkext, boolean sendRslsetflg, int resultSetFlag, boolean sendQryrowset, int qryrowset) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8203);
        this.buildPKGNAMCSN(section);
        this.buildRDBCMTOK();
        if (sendOutexp) {
            this.buildOUTEXP(outexp);
        }
        if (sendQryblksz) {
            this.buildQRYBLKSZ();
        }
        if (sendQryrowset && sendMaxblkext) {
            this.buildMAXBLKEXT(maxblkext);
        }
        if (sendMaxrslcnt) {
            this.buildMAXRSLCNT(maxrslcnt);
        }
        if (sendRslsetflg) {
            this.buildRSLSETFLG(resultSetFlag);
        }
        if (sendQryrowset) {
            this.buildQRYROWSET(qryrowset);
        }
        if (sendPrcnam) {
            this.buildPRCNAM(prcnam);
        }
        this.updateLengthBytes();
    }

    void buildDSCSQLSTT(Section section, boolean sendTypsqlda, int typsqlda) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8200);
        this.buildPKGNAMCSN(section);
        if (sendTypsqlda) {
            this.buildTYPSQLDA(typsqlda);
        }
        this.updateLengthBytes();
    }

    boolean buildSQLDTAcommandData(int numInputColumns, ColumnMetaData parameterMetaData, Object[] inputRow) throws SqlException {
        this.createEncryptedCommandData();
        int loc = this.offset_;
        this.markLengthBytes(9234);
        int[][] protocolTypesAndLengths = this.allocateLidAndLengthsArray(parameterMetaData);
        Hashtable protocolTypeToOverrideLidMapping = null;
        ArrayList mddOverrideArray = null;
        protocolTypeToOverrideLidMapping = this.computeProtocolTypesAndLengths(inputRow, parameterMetaData, protocolTypesAndLengths, protocolTypeToOverrideLidMapping);
        boolean overrideExists = false;
        this.buildFDODSC(numInputColumns, protocolTypesAndLengths, overrideExists, protocolTypeToOverrideLidMapping, mddOverrideArray);
        this.buildFDODTA(numInputColumns, protocolTypesAndLengths, inputRow);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(loc);
        }
        return overrideExists;
    }

    private void buildFDODSC(int numColumns, int[][] protocolTypesAndLengths, boolean overrideExists, Hashtable overrideMap, ArrayList overrideArray) throws SqlException {
        this.markLengthBytes(16);
        this.buildSQLDTA(numColumns, protocolTypesAndLengths, overrideExists, overrideMap, overrideArray);
        this.updateLengthBytes();
    }

    protected void buildSQLDTA(int numColumns, int[][] lidAndLengthOverrides, boolean overrideExists, Hashtable overrideMap, ArrayList overrideArray) throws SqlException {
        if (overrideExists) {
            this.buildMddOverrides(overrideArray);
            this.writeBytes(FdocaConstants.MDD_SQLDTAGRP_TOSEND);
        }
        this.buildSQLDTAGRP(numColumns, lidAndLengthOverrides, overrideExists, overrideMap);
        if (overrideExists) {
            this.writeBytes(FdocaConstants.MDD_SQLDTA_TOSEND);
        }
        this.writeBytes(FdocaConstants.SQLDTA_RLO_TOSEND);
    }

    protected void buildSQLDTAGRP(int numVars, int[][] lidAndLengthOverrides, boolean mddRequired, Hashtable overrideMap) throws SqlException {
        int n = 0;
        int offset = 0;
        n = this.calculateColumnsInSQLDTAGRPtriplet(numVars);
        this.buildTripletHeader(3 * n + 3, 118, 208);
        while (true) {
            this.writeLidAndLengths(lidAndLengthOverrides, n, offset, mddRequired, overrideMap);
            if ((numVars -= n) == 0) break;
            offset += n;
            n = this.calculateColumnsInSQLDTAGRPtriplet(numVars);
            this.buildTripletHeader(3 * n + 3, 127, 0);
        }
    }

    protected void buildOUTOVR(ResultSet resultSet, ColumnMetaData resultSetMetaData) throws SqlException {
        this.createCommandData();
        this.markLengthBytes(9237);
        int[][] outputOverrides = this.calculateOUTOVRLidAndLengthOverrides(resultSet, resultSetMetaData);
        this.buildSQLDTARD(resultSetMetaData.columns_, outputOverrides);
        this.updateLengthBytes();
    }

    private int[][] calculateOUTOVRLidAndLengthOverrides(ResultSet resultSet, ColumnMetaData resultSetMetaData) {
        int numVars = resultSetMetaData.columns_;
        int[][] lidAndLengths = new int[numVars][2];
        block4: for (int i = 0; i < numVars; ++i) {
            switch (resultSetMetaData.types_[i]) {
                case 2004: {
                    lidAndLengths[i][0] = resultSetMetaData.nullable_[i] ? 25 : 24;
                    lidAndLengths[i][1] = 4;
                    continue block4;
                }
                case 2005: {
                    lidAndLengths[i][0] = resultSetMetaData.nullable_[i] ? 27 : 26;
                    lidAndLengths[i][1] = 4;
                }
            }
        }
        return lidAndLengths;
    }

    protected void buildSQLDTARD(int numColumns, int[][] lidAndLengthOverrides) throws SqlException {
        this.buildSQLCADTA(numColumns, lidAndLengthOverrides);
        this.writeBytes(FdocaConstants.SQLDTARD_RLO_TOSEND);
    }

    protected void buildSQLCADTA(int numColumns, int[][] lidAndLengthOverrides) throws SqlException {
        this.buildSQLDTAGRP(numColumns, lidAndLengthOverrides, false, null);
        this.writeBytes(FdocaConstants.SQLCADTA_RLO_TOSEND);
    }

    private void buildFDODTA(int numVars, int[][] protocolTypesAndLengths, Object[] inputs) throws SqlException {
        try {
            Object o = null;
            this.markLengthBytes(5242);
            this.write1Byte(0);
            block25: for (int i = 0; i < numVars; ++i) {
                if (inputs[i] == null) {
                    if (protocolTypesAndLengths[i][0] % 2 != 1) continue;
                    this.write1Byte(255);
                    continue;
                }
                if (protocolTypesAndLengths[i][0] % 2 == 1) {
                    this.write1Byte(0);
                }
                switch (protocolTypesAndLengths[i][0] | 1) {
                    case 63: 
                    case 65: {
                        o = this.retrievePromotedParameterIfExists(i);
                        if (o == null) {
                            this.writeSingleorMixedCcsidLDString((String)inputs[i], this.netAgent_.typdef_.getCcsidMbcEncoding());
                            continue block25;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)o, protocolTypesAndLengths, i);
                        continue block25;
                    }
                    case 51: 
                    case 53: {
                        o = this.retrievePromotedParameterIfExists(i);
                        if (o == null) continue block25;
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)o, protocolTypesAndLengths, i);
                        continue block25;
                    }
                    case 3: {
                        this.writeIntFdocaData((Integer)inputs[i]);
                        continue block25;
                    }
                    case 5: {
                        this.writeShortFdocaData((Short)inputs[i]);
                        continue block25;
                    }
                    case 13: {
                        this.writeFloat(((Float)inputs[i]).floatValue());
                        continue block25;
                    }
                    case 11: {
                        this.writeDouble((Double)inputs[i]);
                        continue block25;
                    }
                    case 15: {
                        this.writeBigDecimal((BigDecimal)inputs[i], protocolTypesAndLengths[i][1] >> 8 & 0xFF, protocolTypesAndLengths[i][1] & 0xFF);
                        continue block25;
                    }
                    case 33: {
                        this.writeDate((Date)inputs[i]);
                        continue block25;
                    }
                    case 35: {
                        this.writeTime((Time)inputs[i]);
                        continue block25;
                    }
                    case 37: {
                        this.writeTimestamp((Timestamp)inputs[i]);
                        continue block25;
                    }
                    case 23: {
                        this.writeLongFdocaData((Long)inputs[i]);
                        continue block25;
                    }
                    case 41: 
                    case 43: {
                        o = this.retrievePromotedParameterIfExists(i);
                        if (o == null) {
                            this.writeLDBytes((byte[])inputs[i]);
                            continue block25;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)o, protocolTypesAndLengths, i);
                        continue block25;
                    }
                    case 203: 
                    case 205: {
                        long dataLength;
                        java.sql.Clob c;
                        o = this.retrievePromotedParameterIfExists(i);
                        if (o == null) {
                            try {
                                c = (java.sql.Clob)inputs[i];
                                if (c instanceof Clob && ((Clob)c).willBeLayerBStreamed()) {
                                    this.setFDODTALobLengthUnknown(i);
                                    continue block25;
                                }
                                dataLength = c.length();
                                this.setFDODTALobLength(protocolTypesAndLengths, i, dataLength);
                                continue block25;
                            }
                            catch (SQLException e) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), e);
                            }
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)o, protocolTypesAndLengths, i);
                        continue block25;
                    }
                    case 201: {
                        long dataLength;
                        o = this.retrievePromotedParameterIfExists(i);
                        if (o == null) {
                            try {
                                Blob b = (Blob)inputs[i];
                                if (b instanceof org.apache.derby.client.am.Blob && ((org.apache.derby.client.am.Blob)b).willBeLayerBStreamed()) {
                                    this.setFDODTALobLengthUnknown(i);
                                    continue block25;
                                }
                                dataLength = b.length();
                                this.setFDODTALobLength(protocolTypesAndLengths, i, dataLength);
                                continue block25;
                            }
                            catch (SQLException e) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), e);
                            }
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (org.apache.derby.client.am.Blob)o, protocolTypesAndLengths, i);
                        continue block25;
                    }
                    case 207: {
                        java.sql.Clob c;
                        o = this.retrievePromotedParameterIfExists(i);
                        if (o == null) {
                            c = (Clob)inputs[i];
                            if (((Clob)c).isString()) {
                                this.setFDODTALobLength(protocolTypesAndLengths, i, ((Clob)c).getUTF8Length());
                                continue block25;
                            }
                            if (!((Lob)((Object)c)).willBeLayerBStreamed()) {
                                this.setFDODTALobLength(protocolTypesAndLengths, i, ((Clob)c).length());
                                continue block25;
                            }
                            this.setFDODTALobLengthUnknown(i);
                            continue block25;
                        }
                        this.setFDODTALob(this.netAgent_.netConnection_.getSecurityMechanism(), (Clob)o, protocolTypesAndLengths, i);
                        continue block25;
                    }
                    case 25: {
                        this.writeIntFdocaData(((org.apache.derby.client.am.Blob)inputs[i]).getLocator());
                        continue block25;
                    }
                    case 27: {
                        this.writeIntFdocaData(((Clob)inputs[i]).getLocator());
                        continue block25;
                    }
                    default: {
                        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.4"), (Object)new Integer(protocolTypesAndLengths[i][0]), (Object)new Integer(numVars), new Integer(i));
                    }
                }
            }
            this.updateLengthBytes();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    private void buildEXTDTA(ColumnMetaData parameterMetaData, Object[] inputRow, boolean chained) throws SqlException {
        try {
            if (this.extdtaPositions_ != null) {
                for (int i = 0; i < this.extdtaPositions_.size(); ++i) {
                    boolean isExternalClob;
                    Lob o;
                    int parameterType;
                    boolean chainedWithSameCorrelator;
                    boolean chainFlag;
                    int index = (Integer)this.extdtaPositions_.get(i);
                    if (i != this.extdtaPositions_.size() - 1) {
                        chainFlag = true;
                        chainedWithSameCorrelator = true;
                    } else {
                        chainFlag = chained;
                        chainedWithSameCorrelator = false;
                    }
                    boolean writeNullByte = false;
                    if (parameterMetaData.nullable_[index]) {
                        writeNullByte = true;
                    }
                    if ((parameterType = parameterMetaData.clientParamtertype_[index]) == 0) {
                        parameterType = parameterMetaData.types_[index];
                    }
                    if (parameterType == 2004 || parameterType == -2 || parameterType == -3 || parameterType == -4) {
                        boolean isExternalBlob;
                        o = (org.apache.derby.client.am.Blob)this.retrievePromotedParameterIfExists(index);
                        org.apache.derby.client.am.Blob b = o == null ? (Blob)inputRow[index] : o;
                        boolean bl = isExternalBlob = !(b instanceof org.apache.derby.client.am.Blob);
                        if (isExternalBlob) {
                            try {
                                this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, (int)b.length(), b.getBinaryStream(), writeNullByte, index + 1);
                                continue;
                            }
                            catch (SQLException e) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), e);
                            }
                        }
                        if (b.isBinaryStream()) {
                            if (b.willBeLayerBStreamed()) {
                                this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, b.getBinaryStream(), writeNullByte, index + 1);
                                continue;
                            }
                            this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, (int)b.length(), b.getBinaryStream(), writeNullByte, index + 1);
                            continue;
                        }
                        this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, (int)b.length(), b.getBinaryStream(), writeNullByte, index + 1);
                        continue;
                    }
                    if (parameterType != 2005 && parameterType != 1 && parameterType != 12 && parameterType != -1) continue;
                    o = (Clob)this.retrievePromotedParameterIfExists(index);
                    Lob c = o == null ? (java.sql.Clob)inputRow[index] : o;
                    boolean bl = isExternalClob = !(c instanceof Clob);
                    if (isExternalClob) {
                        try {
                            this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, (int)c.length(), c.getCharacterStream(), writeNullByte, index + 1);
                            continue;
                        }
                        catch (SQLException e) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), e);
                        }
                    }
                    if (((Clob)c).isCharacterStream()) {
                        if (((Clob)c).willBeLayerBStreamed()) {
                            this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, ((Clob)c).getCharacterStream(), writeNullByte, index + 1);
                            continue;
                        }
                        this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, (int)((Clob)c).length(), ((Clob)c).getCharacterStream(), writeNullByte, index + 1);
                        continue;
                    }
                    if (((Clob)c).isAsciiStream()) {
                        if (((Clob)c).willBeLayerBStreamed()) {
                            this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, ((Clob)c).getAsciiStream(), writeNullByte, index + 1);
                            continue;
                        }
                        this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, (int)((Clob)c).length(), ((Clob)c).getAsciiStream(), writeNullByte, index + 1);
                        continue;
                    }
                    if (((Clob)c).isUnicodeStream()) {
                        if (((Clob)c).willBeLayerBStreamed()) {
                            this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, ((Clob)c).getUnicodeStream(), writeNullByte, index + 1);
                            continue;
                        }
                        this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, (int)((Clob)c).length(), ((Clob)c).getUnicodeStream(), writeNullByte, index + 1);
                        continue;
                    }
                    this.writeScalarStream(chainFlag, chainedWithSameCorrelator, 5228, ((Clob)c).getUTF8Length(), new ByteArrayInputStream(((Clob)c).getUtf8String()), writeNullByte, index + 1);
                }
            }
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    private Object retrievePromotedParameterIfExists(int index) {
        if (this.promototedParameters_.isEmpty()) {
            return null;
        }
        return this.promototedParameters_.get(new Integer(index));
    }

    private int calculateColumnsInSQLDTAGRPtriplet(int numVars) {
        if (numVars > 84) {
            return 84;
        }
        return numVars;
    }

    private Hashtable computeProtocolTypesAndLengths(Object[] inputRow, ColumnMetaData parameterMetaData, int[][] lidAndLengths, Hashtable overrideMap) throws SqlException {
        try {
            int numVars = parameterMetaData.columns_;
            String s = null;
            if (!this.promototedParameters_.isEmpty()) {
                this.promototedParameters_.clear();
            }
            for (int i = 0; i < numVars; ++i) {
                int jdbcType = parameterMetaData.clientParamtertype_[i];
                if (jdbcType == 0) {
                    jdbcType = parameterMetaData.types_[i];
                }
                if (jdbcType == 0) {
                    throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.5"), new Integer(i));
                }
                switch (jdbcType) {
                    case 1: 
                    case 12: {
                        s = (String)inputRow[i];
                        if (s == null || s.length() <= 10922) {
                            lidAndLengths[i][0] = 63;
                            lidAndLengths[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        ByteArrayInputStream bais = null;
                        byte[] ba = null;
                        try {
                            ba = s.getBytes("UTF-8");
                            bais = new ByteArrayInputStream(ba);
                            Clob c = new Clob((Agent)this.netAgent_, bais, "UTF-8", ba.length);
                            this.promototedParameters_.put(new Integer(i), c);
                            lidAndLengths[i][0] = 207;
                            if (c.willBeLayerBStreamed()) {
                                lidAndLengths[i][1] = 32770;
                                break;
                            }
                            lidAndLengths[i][1] = this.buildPlaceholderLength(c.length());
                            break;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"byte array", (Object)"Clob", (Throwable)e);
                        }
                    }
                    case 4: {
                        lidAndLengths[i][0] = 3;
                        lidAndLengths[i][1] = 4;
                        break;
                    }
                    case -7: 
                    case -6: 
                    case 5: 
                    case 16: {
                        lidAndLengths[i][0] = 5;
                        lidAndLengths[i][1] = 2;
                        break;
                    }
                    case 7: {
                        lidAndLengths[i][0] = 13;
                        lidAndLengths[i][1] = 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        lidAndLengths[i][0] = 11;
                        lidAndLengths[i][1] = 8;
                        break;
                    }
                    case 2: 
                    case 3: {
                        int precision;
                        int scale;
                        BigDecimal bigDecimal = (BigDecimal)inputRow[i];
                        if (bigDecimal == null) {
                            scale = 0;
                            precision = 1;
                        } else {
                            if (bigDecimal.scale() < 0) {
                                bigDecimal = bigDecimal.setScale(0);
                                inputRow[i] = bigDecimal;
                            }
                            scale = bigDecimal.scale();
                            precision = Utils.computeBigDecimalPrecision(bigDecimal);
                        }
                        lidAndLengths[i][0] = 15;
                        lidAndLengths[i][1] = (precision << 8) + (scale << 0);
                        break;
                    }
                    case 91: {
                        lidAndLengths[i][0] = 33;
                        lidAndLengths[i][1] = 10;
                        break;
                    }
                    case 92: {
                        lidAndLengths[i][0] = 35;
                        lidAndLengths[i][1] = 8;
                        break;
                    }
                    case 93: {
                        lidAndLengths[i][0] = 37;
                        lidAndLengths[i][1] = 26;
                        break;
                    }
                    case -5: {
                        lidAndLengths[i][0] = 23;
                        lidAndLengths[i][1] = 8;
                        break;
                    }
                    case -1: {
                        java.sql.Clob c;
                        s = (String)inputRow[i];
                        if (s == null || s.length() <= 10922) {
                            lidAndLengths[i][0] = 65;
                            lidAndLengths[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        ByteArrayInputStream bais = null;
                        byte[] ba = null;
                        try {
                            ba = s.getBytes("UTF-8");
                            bais = new ByteArrayInputStream(ba);
                            c = new Clob((Agent)this.netAgent_, bais, "UTF-8", ba.length);
                            this.promototedParameters_.put(new Integer(i), c);
                            lidAndLengths[i][0] = 207;
                            lidAndLengths[i][1] = this.buildPlaceholderLength(((Clob)c).length());
                            break;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"byte array", "Clob");
                        }
                    }
                    case -3: 
                    case -2: {
                        byte[] ba = (byte[])inputRow[i];
                        if (ba == null) {
                            lidAndLengths[i][0] = 41;
                            lidAndLengths[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        if (ba.length <= Short.MAX_VALUE) {
                            lidAndLengths[i][0] = 41;
                            lidAndLengths[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        Blob b = new org.apache.derby.client.am.Blob(ba, this.netAgent_, 0);
                        this.promototedParameters_.put(new Integer(i), b);
                        lidAndLengths[i][0] = 201;
                        lidAndLengths[i][1] = this.buildPlaceholderLength(ba.length);
                        break;
                    }
                    case -4: {
                        byte[] ba = (byte[])inputRow[i];
                        if (ba == null) {
                            lidAndLengths[i][0] = 43;
                            lidAndLengths[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        if (ba.length <= Short.MAX_VALUE) {
                            lidAndLengths[i][0] = 43;
                            lidAndLengths[i][1] = Short.MAX_VALUE;
                            break;
                        }
                        Blob b = new org.apache.derby.client.am.Blob(ba, this.netAgent_, 0);
                        this.promototedParameters_.put(new Integer(i), b);
                        lidAndLengths[i][0] = 201;
                        lidAndLengths[i][1] = this.buildPlaceholderLength(ba.length);
                        break;
                    }
                    case 2004: {
                        Blob b = (Blob)inputRow[i];
                        if (b == null) {
                            lidAndLengths[i][0] = 201;
                            lidAndLengths[i][1] = this.buildPlaceholderLength(parameterMetaData.sqlLength_[i]);
                            break;
                        }
                        if (b instanceof org.apache.derby.client.am.Blob && ((org.apache.derby.client.am.Blob)b).isLocator()) {
                            lidAndLengths[i][0] = 25;
                            lidAndLengths[i][1] = 4;
                            break;
                        }
                        lidAndLengths[i][0] = 201;
                        try {
                            if (b instanceof org.apache.derby.client.am.Blob && ((org.apache.derby.client.am.Blob)b).willBeLayerBStreamed()) {
                                lidAndLengths[i][1] = 32770;
                                break;
                            }
                            lidAndLengths[i][1] = this.buildPlaceholderLength(b.length());
                            break;
                        }
                        catch (SQLException e) {
                            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), e);
                        }
                    }
                    case 2005: {
                        java.sql.Clob c = (java.sql.Clob)inputRow[i];
                        boolean isExternalClob = !(c instanceof Clob);
                        long lobLength = 0L;
                        boolean doesLayerBStreaming = false;
                        if (c == null) {
                            lobLength = parameterMetaData.sqlLength_[i];
                        } else if (c instanceof Clob && ((Clob)c).isLocator()) {
                            lidAndLengths[i][0] = 27;
                            lidAndLengths[i][1] = 4;
                        } else if (isExternalClob) {
                            try {
                                lobLength = c.length();
                            }
                            catch (SQLException e) {
                                throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN009.S"), e);
                            }
                        } else if (((Clob)c).willBeLayerBStreamed()) {
                            doesLayerBStreaming = true;
                        } else {
                            lobLength = ((Clob)c).length();
                        }
                        if (c == null) {
                            lidAndLengths[i][0] = 207;
                            lidAndLengths[i][1] = this.buildPlaceholderLength(lobLength);
                            break;
                        }
                        if (isExternalClob) {
                            lidAndLengths[i][0] = 205;
                            lidAndLengths[i][1] = this.buildPlaceholderLength(lobLength);
                            break;
                        }
                        if (((Clob)c).isCharacterStream()) {
                            lidAndLengths[i][0] = 205;
                            if (doesLayerBStreaming) {
                                lidAndLengths[i][1] = 32770;
                                break;
                            }
                            lidAndLengths[i][1] = this.buildPlaceholderLength(lobLength);
                            break;
                        }
                        if (((Clob)c).isUnicodeStream()) {
                            lidAndLengths[i][0] = 207;
                            if (doesLayerBStreaming) {
                                lidAndLengths[i][1] = 32770;
                                break;
                            }
                            lidAndLengths[i][1] = this.buildPlaceholderLength(lobLength);
                            break;
                        }
                        if (((Clob)c).isAsciiStream()) {
                            lidAndLengths[i][0] = 203;
                            if (doesLayerBStreaming) {
                                lidAndLengths[i][1] = 32770;
                                break;
                            }
                            lidAndLengths[i][1] = this.buildPlaceholderLength(lobLength);
                            break;
                        }
                        if (!((Clob)c).isString()) break;
                        lidAndLengths[i][0] = 207;
                        if (doesLayerBStreaming) {
                            lidAndLengths[i][1] = 32770;
                            break;
                        }
                        lidAndLengths[i][1] = this.buildPlaceholderLength(lobLength);
                        break;
                    }
                    default: {
                        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.6"), new Integer(jdbcType));
                    }
                }
                if (parameterMetaData.nullable_[i]) continue;
                int[] nArray = lidAndLengths[i];
                nArray[0] = nArray[0] - 1;
            }
            return overrideMap;
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    private int buildPlaceholderLength(long totalLength) {
        if (totalLength < 32767L) {
            return 32770;
        }
        if (totalLength < Integer.MAX_VALUE) {
            return 32772;
        }
        if (totalLength < 0x7FFFFFFFFFFFL) {
            return 32774;
        }
        return 32776;
    }

    private void buildOUTEXP(boolean outputExpected) throws SqlException {
        if (outputExpected) {
            this.writeScalar1Byte(8465, -15);
        }
    }

    void buildMAXBLKEXT(int maxNumOfExtraBlocks) throws SqlException {
        if (maxNumOfExtraBlocks != 0) {
            this.writeScalar2Bytes(8513, maxNumOfExtraBlocks);
        }
    }

    void buildQRYROWSET(int fetchSize) throws SqlException {
        this.writeScalar4Bytes(8534, fetchSize);
    }

    private void buildPRCNAM(String prcnam) throws SqlException {
        if (prcnam == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN010.S"));
        }
        int prcnamLength = prcnam.length();
        if (prcnamLength == 0 || prcnamLength > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN011.S"), (Object)new Integer(prcnamLength), new Integer(255));
        }
        this.writeScalarString(8504, prcnam);
    }

    void buildQRYBLKSZ() throws SqlException {
        this.writeScalar4Bytes(8468, 32767L);
    }

    private void buildMAXRSLCNT(int maxResultSetCount) throws SqlException {
        if (maxResultSetCount == 0) {
            return;
        }
        this.writeScalar2Bytes(8512, maxResultSetCount);
    }

    private void buildRDBCMTOK() throws SqlException {
        this.writeScalar1Byte(8453, -15);
    }

    private void buildRSLSETFLG(int resultSetFlag) throws SqlException {
        this.writeScalar1Byte(8514, resultSetFlag);
    }

    void buildQRYINSID(long qryinsid) throws SqlException {
        this.markLengthBytes(8539);
        this.writeLong(qryinsid);
        this.updateLengthBytes();
    }

    private void buildRTNSQLDA() throws SqlException {
        this.writeScalar1Byte(8470, -15);
    }

    private void buildTYPSQLDA(int typeSqlda) throws SqlException {
        if (typeSqlda != 0) {
            this.writeScalar1Byte(8518, typeSqlda);
        }
    }

    private void buildQRYCLSIMP() {
        this.writeScalar1Byte(8541, 1);
    }

    private void setFDODTALobLength(int[][] protocolTypesAndLengths, int i, long dataLength) throws SqlException {
        if (protocolTypesAndLengths[i][1] == 32770) {
            this.writeShort((short)dataLength);
        } else if (protocolTypesAndLengths[i][1] == 32772) {
            this.writeInt((int)dataLength);
        } else if (protocolTypesAndLengths[i][1] == 32774) {
            this.writeLong(dataLength);
        } else if (protocolTypesAndLengths[i][1] == 32776) {
            this.writeLong(dataLength);
        }
        if (dataLength != 0L) {
            if (this.extdtaPositions_ == null) {
                this.extdtaPositions_ = new ArrayList();
            }
            this.extdtaPositions_.add(new Integer(i));
        }
    }

    private void setFDODTALobLengthUnknown(int i) throws SqlException {
        int v = 1;
        short s = (short)(v << 15);
        v = s;
        this.writeShort(s);
        if (this.extdtaPositions_ == null) {
            this.extdtaPositions_ = new ArrayList();
        }
        this.extdtaPositions_.add(new Integer(i));
    }

    private boolean checkSendQryrowset(int fetchSize, int resultSetType) {
        boolean sendQryrowset = false;
        if (resultSetType != 1003) {
            sendQryrowset = true;
        }
        return sendQryrowset;
    }

    private int checkFetchsize(int fetchSize, int resultSetType) {
        if (resultSetType != 1003 && fetchSize == 0) {
            fetchSize = 64;
        }
        return fetchSize;
    }

    private int calculateResultSetFlags() {
        return 4;
    }

    public void writeSetSpecialRegister(Section section, ArrayList sqlsttList) throws SqlException {
        this.buildEXCSQLSET(section);
        for (int i = 0; i < sqlsttList.size(); ++i) {
            this.buildSQLSTTcommandData((String)sqlsttList.get(i));
        }
    }

    private int[][] allocateLidAndLengthsArray(ColumnMetaData parameterMetaData) {
        int numVars = parameterMetaData.columns_;
        int[][] lidAndLengths = parameterMetaData.protocolTypesCache_;
        if (lidAndLengths == null || lidAndLengths.length != numVars) {
            parameterMetaData.protocolTypesCache_ = lidAndLengths = new int[numVars][2];
        }
        return lidAndLengths;
    }

    private void buildMddOverrides(ArrayList sdaOverrides) throws SqlException {
        for (int i = 0; i < sdaOverrides.size(); ++i) {
            byte[] mddBytes = (byte[])sdaOverrides.get(i);
            this.writeBytes(mddBytes);
        }
    }

    private int getNextOverrideLid() {
        return this.overrideLid_++;
    }

    private void setFDODTALob(int securityMechanism, Lob lob, int[][] protocolTypesAndLengths, int i) throws SqlException, SQLException {
        if (lob.willBeLayerBStreamed()) {
            this.setFDODTALobLengthUnknown(i);
        } else {
            this.setFDODTALobLength(protocolTypesAndLengths, i, lob.length());
        }
    }
}

