/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.AttributeEntry;
import org.apache.derby.iapi.services.classfile.Attributes;
import org.apache.derby.iapi.services.classfile.CONSTANT_Double_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Float_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Integer_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Long_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;
import org.apache.derby.iapi.services.classfile.MemberTable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.util.ByteArray;

public class ClassHolder {
    protected int minor_version = 3;
    protected int major_version = 45;
    protected int access_flags;
    protected int this_class;
    protected int super_class;
    protected int[] interfaces;
    protected MemberTable field_info;
    protected MemberTable method_info;
    protected Attributes attribute_info;
    protected Hashtable cptHashTable;
    protected Vector cptEntries;
    private int cptEstimatedSize;
    private final CONSTANT_Index_info searchIndex = new CONSTANT_Index_info(0, 0, 0);

    protected ClassHolder(int estimatedConstantPoolCount) {
        this.cptEntries = new Vector(estimatedConstantPoolCount);
        this.cptHashTable = new Hashtable(estimatedConstantPoolCount, 0.75f);
        this.cptEntries.setSize(1);
    }

    public ClassHolder(String fullyQualifiedName, String superClassName, int modifiers) {
        this(100);
        this.access_flags = modifiers | 0x20;
        this.this_class = this.addClassReference(fullyQualifiedName);
        this.super_class = this.addClassReference(superClassName);
        this.method_info = new MemberTable(0);
    }

    private void put(ClassFormatOutput out) throws IOException {
        out.putU4(-889275714);
        out.putU2(this.minor_version);
        out.putU2(this.major_version);
        out.putU2("constant_pool", this.cptEntries.size());
        this.cptPut(out);
        out.putU2(this.access_flags);
        out.putU2(this.this_class);
        out.putU2(this.super_class);
        if (this.interfaces != null) {
            int ilen = this.interfaces.length;
            out.putU2(ilen);
            for (int i = 0; i < ilen; ++i) {
                out.putU2(this.interfaces[i]);
            }
        } else {
            out.putU2(0);
        }
        if (this.field_info != null) {
            out.putU2(this.field_info.size());
            this.field_info.put(out);
        } else {
            out.putU2(0);
        }
        if (this.method_info != null) {
            out.putU2(this.method_info.size());
            this.method_info.put(out);
        } else {
            out.putU2(0);
        }
        if (this.attribute_info != null) {
            out.putU2(this.attribute_info.size());
            this.attribute_info.put(out);
        } else {
            out.putU2(0);
        }
    }

    public ByteArray getFileFormat() throws IOException {
        int classFileSize = 24;
        classFileSize += this.cptEstimatedSize;
        if (this.interfaces != null) {
            classFileSize += this.interfaces.length * 2;
        }
        if (this.field_info != null) {
            classFileSize += this.field_info.classFileSize();
        }
        if (this.method_info != null) {
            classFileSize += this.method_info.classFileSize();
        }
        if (this.attribute_info != null) {
            classFileSize += this.attribute_info.classFileSize();
        }
        ClassFormatOutput cfo = new ClassFormatOutput(classFileSize + 200);
        this.put(cfo);
        return new ByteArray(cfo.getData(), 0, cfo.size());
    }

    public int getModifier() {
        return this.access_flags;
    }

    public String getName() {
        return this.className(this.this_class).replace('/', '.');
    }

    public ClassMember addMember(String simpleName, String descriptor, int modifier) {
        MemberTable mt;
        if (descriptor.startsWith("(")) {
            if (this.method_info != null && this.method_info.find(simpleName, descriptor) != null) {
                SanityManager.THROWASSERT("Method already exists " + simpleName + " " + descriptor);
            }
        } else if (this.field_info != null && this.field_info.find(simpleName, descriptor) != null) {
            SanityManager.THROWASSERT("Field already exists " + simpleName + " " + descriptor);
        }
        CONSTANT_Utf8_info utf = this.addUtf8Entry(simpleName);
        int nameIndex = utf.getIndex();
        int descriptorIndex = this.addUtf8Entry(descriptor).getIndex();
        ClassMember item = new ClassMember(this, modifier, nameIndex, descriptorIndex);
        if (descriptor.startsWith("(")) {
            mt = this.method_info;
            if (mt == null) {
                mt = this.method_info = new MemberTable(0);
            }
        } else {
            mt = this.field_info;
            if (mt == null) {
                mt = this.field_info = new MemberTable(0);
            }
        }
        mt.addEntry(item);
        return item;
    }

    public int addFieldReference(String className, String simpleName, String descriptor) {
        return this.addReference(9, className, simpleName, descriptor);
    }

    public int addFieldReference(ClassMember field) {
        return this.addReference(9, field);
    }

    public int addMethodReference(String className, String simpleName, String descriptor, boolean isInterface) {
        int tag = isInterface ? 11 : 10;
        return this.addReference(tag, className, simpleName, descriptor);
    }

    private int addReference(int tag, String className, String simpleName, String descriptor) {
        int classIndex = this.addClassReference(className);
        int nameTypeIndex = this.addNameAndType(simpleName, descriptor);
        return this.addIndexReference(tag, classIndex, nameTypeIndex);
    }

    private int addReference(int tag, ClassMember member) {
        int nameTypeIndex = this.addIndexReference(12, member.name_index, member.descriptor_index);
        return this.addIndexReference(tag, this.this_class, nameTypeIndex);
    }

    public int addConstant(String value) {
        return this.addString(value);
    }

    public int addUtf8(String value) {
        return this.addUtf8Entry(value).getIndex();
    }

    public int addConstant(int value) {
        return this.addDirectEntry(new CONSTANT_Integer_info(value));
    }

    public int addConstant(float value) {
        return this.addDirectEntry(new CONSTANT_Float_info(value));
    }

    public int addConstant(long value) {
        return this.addDirectEntry(new CONSTANT_Long_info(value));
    }

    public int addConstant(double value) {
        return this.addDirectEntry(new CONSTANT_Double_info(value));
    }

    public int getConstantPoolIndex() {
        return this.this_class;
    }

    public void addAttribute(String attributeName, ClassFormatOutput info) {
        if (this.attribute_info == null) {
            this.attribute_info = new Attributes(1);
        }
        CONSTANT_Utf8_info autf = this.addUtf8Entry(attributeName);
        int index = autf.getIndex();
        this.attribute_info.addEntry(new AttributeEntry(index, info));
    }

    public String getSuperClassName() {
        if (this.super_class == 0) {
            return null;
        }
        return this.className(this.super_class).replace('/', '.');
    }

    protected int addEntry(Object key, ConstantPoolEntry item) {
        item.setIndex(this.cptEntries.size());
        if (key != null) {
            this.cptHashTable.put(key, item);
        }
        this.cptEntries.addElement(item);
        this.cptEstimatedSize += item.classFileSize();
        if (item.doubleSlot()) {
            this.cptEntries.addElement(null);
            return 2;
        }
        return 1;
    }

    private int addDirectEntry(ConstantPoolEntry item) {
        ConstantPoolEntry existingItem = this.findMatchingEntry(item);
        if (existingItem != null) {
            item = existingItem;
        } else {
            this.addEntry(item.getKey(), item);
        }
        return item.getIndex();
    }

    private int addIndexReference(int tag, int i1, int i2) {
        this.searchIndex.set(tag, i1, i2);
        ConstantPoolEntry item = this.findMatchingEntry(this.searchIndex);
        if (item == null) {
            item = new CONSTANT_Index_info(tag, i1, i2);
            this.addEntry(item.getKey(), item);
        }
        return item.getIndex();
    }

    public int addClassReference(String fullyQualifiedName) {
        if (ClassHolder.isExternalClassName(fullyQualifiedName)) {
            fullyQualifiedName = ClassHolder.convertToInternalClassName(fullyQualifiedName);
        }
        int name_index = this.addUtf8Entry(fullyQualifiedName).getIndex();
        return this.addIndexReference(7, name_index, 0);
    }

    private int addNameAndType(String name, String descriptor) {
        int nameIndex = this.addUtf8Entry(name).getIndex();
        int descriptorIndex = this.addUtf8Entry(descriptor).getIndex();
        return this.addIndexReference(12, nameIndex, descriptorIndex);
    }

    private CONSTANT_Utf8_info addUtf8Entry(String value) {
        CONSTANT_Utf8_info item = (CONSTANT_Utf8_info)this.findMatchingEntry(value);
        if (item == null) {
            item = new CONSTANT_Utf8_info(value);
            this.addEntry(value, item);
        }
        return item;
    }

    private CONSTANT_Utf8_info addExtraUtf8(String value) {
        CONSTANT_Utf8_info item = new CONSTANT_Utf8_info(value);
        this.addEntry(null, item);
        return item;
    }

    private int addString(String value) {
        CONSTANT_Utf8_info sutf = this.addUtf8Entry(value);
        int valueIndex = sutf.setAsString();
        if (valueIndex == 0) {
            valueIndex = this.addExtraUtf8(value).getIndex();
            sutf.setAlternative(valueIndex);
        }
        return this.addIndexReference(8, valueIndex, 0);
    }

    private int addCodeUtf8(String value) {
        CONSTANT_Utf8_info sutf = this.addUtf8Entry(value);
        int index = sutf.setAsCode();
        if (index == 0) {
            CONSTANT_Utf8_info eutf = this.addExtraUtf8(value);
            eutf.setAsCode();
            index = eutf.getIndex();
            sutf.setAlternative(index);
        }
        return index;
    }

    protected void cptPut(ClassFormatOutput out) throws IOException {
        Enumeration e = this.cptEntries.elements();
        while (e.hasMoreElements()) {
            ConstantPoolEntry item = (ConstantPoolEntry)e.nextElement();
            if (item == null) continue;
            item.put(out);
        }
    }

    public ConstantPoolEntry getEntry(int index) {
        return (ConstantPoolEntry)this.cptEntries.elementAt(index);
    }

    protected String className(int classIndex) {
        CONSTANT_Index_info ci = (CONSTANT_Index_info)this.getEntry(classIndex);
        return this.nameIndexToString(ci.getI1()).replace('/', '.');
    }

    int findUtf8(String value) {
        ConstantPoolEntry item = this.findMatchingEntry(value);
        if (item == null) {
            return -1;
        }
        return item.getIndex();
    }

    public int findClass(String fullyQualifiedName) {
        String internalName = ClassHolder.convertToInternalClassName(fullyQualifiedName);
        int utf_index = this.findUtf8(internalName);
        if (utf_index < 0) {
            return -1;
        }
        return this.findIndexIndex(7, utf_index, 0);
    }

    public int findNameAndType(String name, String descriptor) {
        int name_index = this.findUtf8(name);
        if (name_index < 0) {
            return -1;
        }
        int descriptor_index = this.findUtf8(descriptor);
        if (descriptor_index < 0) {
            return -1;
        }
        return this.findIndexIndex(12, name_index, descriptor_index);
    }

    protected CONSTANT_Index_info findIndexEntry(int tag, int i1, int i2) {
        this.searchIndex.set(tag, i1, i2);
        return (CONSTANT_Index_info)this.findMatchingEntry(this.searchIndex);
    }

    protected int findIndexIndex(int tag, int i1, int i2) {
        CONSTANT_Index_info item = this.findIndexEntry(tag, i1, i2);
        if (item == null) {
            return -1;
        }
        return item.getIndex();
    }

    protected ConstantPoolEntry findMatchingEntry(Object key) {
        return (ConstantPoolEntry)this.cptHashTable.get(key);
    }

    String nameIndexToString(int index) {
        return this.getEntry(index).toString();
    }

    protected String getClassName(int index) {
        if (index == 0) {
            return "";
        }
        return this.nameIndexToString(this.getEntry(index).getI1());
    }

    public static boolean isExternalClassName(String className) {
        if (className.indexOf(46) != -1) {
            return true;
        }
        int len = className.length();
        if (len == 0) {
            return false;
        }
        return className.charAt(len - 1) == ']';
    }

    public static String convertToInternalClassName(String externalName) {
        return ClassHolder.convertToInternal(externalName, false);
    }

    public static String convertToInternalDescriptor(String externalName) {
        return ClassHolder.convertToInternal(externalName, true);
    }

    private static String convertToInternal(String externalName, boolean descriptor) {
        SanityManager.ASSERT(externalName != null, "unexpected null");
        int len = externalName.length();
        String retVal = null;
        int origLen = len;
        int arity = 0;
        if (externalName.charAt(len - 1) == ']') {
            while (len > 0 && externalName.charAt(len - 1) == ']' && externalName.charAt(len - 2) == '[') {
                len -= 2;
                ++arity;
            }
        }
        SanityManager.ASSERT(len > 0);
        String internalName = origLen == len ? externalName : externalName.substring(0, len);
        switch (len) {
            case 7: {
                if (!"boolean".equals(internalName)) break;
                retVal = ClassHolder.makeDesc('Z', arity);
                break;
            }
            case 4: {
                if ("void".equals(internalName)) {
                    retVal = ClassHolder.makeDesc('V', arity);
                    break;
                }
                if ("long".equals(internalName)) {
                    retVal = ClassHolder.makeDesc('J', arity);
                    break;
                }
                if ("byte".equals(internalName)) {
                    retVal = ClassHolder.makeDesc('B', arity);
                    break;
                }
                if (!"char".equals(internalName)) break;
                retVal = ClassHolder.makeDesc('C', arity);
                break;
            }
            case 3: {
                if (!"int".equals(internalName)) break;
                retVal = ClassHolder.makeDesc('I', arity);
                break;
            }
            case 6: {
                if (!"double".equals(internalName)) break;
                retVal = ClassHolder.makeDesc('D', arity);
                break;
            }
            case 5: {
                if ("short".equals(internalName)) {
                    retVal = ClassHolder.makeDesc('S', arity);
                    break;
                }
                if (!"float".equals(internalName)) break;
                retVal = ClassHolder.makeDesc('F', arity);
            }
        }
        if (retVal == null) {
            retVal = ClassHolder.makeDesc(internalName, arity, descriptor);
        }
        return retVal;
    }

    private static String makeDesc(char builtin, int arity) {
        if (arity == 0) {
            switch (builtin) {
                case 'B': {
                    return "B";
                }
                case 'C': {
                    return "C";
                }
                case 'D': {
                    return "D";
                }
                case 'F': {
                    return "F";
                }
                case 'I': {
                    return "I";
                }
                case 'J': {
                    return "J";
                }
                case 'S': {
                    return "S";
                }
                case 'Z': {
                    return "Z";
                }
                case 'V': {
                    return "V";
                }
            }
            SanityManager.THROWASSERT("No type match");
            return null;
        }
        StringBuffer desc = new StringBuffer(arity + 3);
        for (int i = 0; i < arity; ++i) {
            desc.append('[');
        }
        desc.append(ClassHolder.makeDesc(builtin, 0));
        return desc.toString();
    }

    private static String makeDesc(String className, int arity, boolean descriptor) {
        if (!descriptor && arity == 0) {
            return className.replace('.', '/');
        }
        StringBuffer desc = new StringBuffer(arity + 2 + className.length());
        for (int i = 0; i < arity; ++i) {
            desc.append('[');
        }
        desc.append('L');
        desc.append(className.replace('.', '/'));
        desc.append(';');
        return desc.toString();
    }
}

