/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;

public abstract class PermissionsDescriptor
extends TupleDescriptor
implements Cloneable,
Provider {
    protected UUID oid;
    private String grantee;
    private final String grantor;

    PermissionsDescriptor(DataDictionary dd, String grantee, String grantor) {
        super(dd);
        this.grantee = grantee;
        this.grantor = grantor;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            SanityManager.THROWASSERT("Could not clone a " + this.getClass().getName(), cnse);
            return null;
        }
    }

    public abstract int getCatalogNumber();

    protected boolean keyEquals(PermissionsDescriptor other) {
        return this.grantee.equals(other.grantee);
    }

    protected int keyHashCode() {
        return this.grantee.hashCode();
    }

    public void setGrantee(String grantee) {
        this.grantee = grantee;
    }

    public final String getGrantee() {
        return this.grantee;
    }

    public final String getGrantor() {
        return this.grantor;
    }

    public UUID getUUID() {
        return this.oid;
    }

    public void setUUID(UUID oid) {
        this.oid = oid;
    }

    public abstract boolean checkOwner(String var1) throws StandardException;

    public UUID getObjectID() {
        return this.oid;
    }

    public boolean isPersistent() {
        return true;
    }
}

