/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;

public class StatementColumnPermission
extends StatementTablePermission {
    private FormatableBitSet columns;

    public StatementColumnPermission(UUID tableUUID, int privType, FormatableBitSet columns) {
        super(tableUUID, privType);
        this.columns = columns;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatementColumnPermission) {
            StatementColumnPermission other = (StatementColumnPermission)obj;
            if (!this.columns.equals(other.columns)) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant, Activation activation) throws StandardException {
        int remains;
        DataDictionary dd = lcc.getDataDictionary();
        ExecPreparedStatement ps = activation.getPreparedStatement();
        if (this.hasPermissionOnTable(lcc, activation, authorizationId, forGrant, ps)) {
            return;
        }
        FormatableBitSet permittedColumns = null;
        if (!forGrant) {
            permittedColumns = this.addPermittedColumns(dd, false, "PUBLIC", permittedColumns);
            permittedColumns = this.addPermittedColumns(dd, false, authorizationId, permittedColumns);
        }
        permittedColumns = this.addPermittedColumns(dd, true, "PUBLIC", permittedColumns);
        permittedColumns = this.addPermittedColumns(dd, true, authorizationId, permittedColumns);
        FormatableBitSet unresolvedColumns = (FormatableBitSet)this.columns.clone();
        int i = unresolvedColumns.anySetBit();
        while (i >= 0) {
            if (permittedColumns != null && permittedColumns.get(i)) {
                unresolvedColumns.clear(i);
            }
            i = unresolvedColumns.anySetBit(i);
        }
        if (unresolvedColumns.anySetBit() < 0) {
            return;
        }
        String role = lcc.getCurrentRoleId(activation);
        RoleGrantDescriptor rd = null;
        if (role != null) {
            String dbo = dd.getAuthorizationDatabaseOwner();
            rd = dd.getRoleGrantDescriptor(role, authorizationId, dbo);
            if (rd == null) {
                rd = dd.getRoleGrantDescriptor(role, "PUBLIC", dbo);
            }
            if (rd == null) {
                lcc.setCurrentRole(activation, null);
            } else {
                String r;
                RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), role, true);
                while (unresolvedColumns.anySetBit() >= 0 && (r = rci.next()) != null) {
                    unresolvedColumns = this.tryRole(lcc, dd, forGrant, r, unresolvedColumns);
                }
            }
        }
        if ((remains = unresolvedColumns.anySetBit()) >= 0) {
            TableDescriptor td = this.getTableDescriptor(dd);
            ColumnDescriptor cd = td.getColumnDescriptor(remains + 1);
            if (cd == null) {
                throw StandardException.newException("4250E", "column");
            }
            throw StandardException.newException(forGrant ? "42503" : "42502", authorizationId, (Object)this.getPrivName(), (Object)cd.getColumnName(), (Object)td.getSchemaName(), (Object)td.getName());
        }
        DependencyManager dm = dd.getDependencyManager();
        RoleGrantDescriptor rgd = dd.getRoleDefinitionDescriptor(role);
        ContextManager cm = lcc.getContextManager();
        dm.addDependency(ps, rgd, cm);
        dm.addDependency(activation, rgd, cm);
    }

    private FormatableBitSet addPermittedColumns(DataDictionary dd, boolean forGrant, String authorizationId, FormatableBitSet permittedColumns) throws StandardException {
        if (permittedColumns != null && permittedColumns.getNumBitsSet() == permittedColumns.size()) {
            return permittedColumns;
        }
        ColPermsDescriptor perms = dd.getColumnPermissions(this.tableUUID, this.privType, false, authorizationId);
        if (perms != null) {
            if (permittedColumns == null) {
                return perms.getColumns();
            }
            permittedColumns.or(perms.getColumns());
        }
        return permittedColumns;
    }

    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dd, authid, false)) {
            return dd.getTablePermissions(this.tableUUID, authid);
        }
        if (this.oneAuthHasPermissionOnTable(dd, "PUBLIC", false)) {
            return dd.getTablePermissions(this.tableUUID, "PUBLIC");
        }
        ColPermsDescriptor colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, authid);
        if (colsPermsDesc != null && colsPermsDesc.getColumns() != null) {
            FormatableBitSet permittedColumns = colsPermsDesc.getColumns();
            int i = this.columns.anySetBit();
            while (i >= 0) {
                if (permittedColumns.get(i)) {
                    return colsPermsDesc;
                }
                i = this.columns.anySetBit(i);
            }
        }
        return null;
    }

    public PermissionsDescriptor getPUBLIClevelColPermsDescriptor(String authid, DataDictionary dd) throws StandardException {
        ColPermsDescriptor colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, authid);
        FormatableBitSet permittedColumns = colsPermsDesc.getColumns();
        boolean allColumnsCoveredByUserLevelPrivilege = true;
        int i = this.columns.anySetBit();
        while (i >= 0 && allColumnsCoveredByUserLevelPrivilege) {
            if (!permittedColumns.get(i)) {
                allColumnsCoveredByUserLevelPrivilege = false;
            }
            i = this.columns.anySetBit(i);
        }
        if (allColumnsCoveredByUserLevelPrivilege) {
            return null;
        }
        return dd.getColumnPermissions(this.tableUUID, this.privType, false, "PUBLIC");
    }

    public boolean allColumnsCoveredByUserOrPUBLIC(String authid, DataDictionary dd) throws StandardException {
        int i;
        ColPermsDescriptor colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, authid);
        FormatableBitSet permittedColumns = colsPermsDesc.getColumns();
        FormatableBitSet unresolvedColumns = (FormatableBitSet)this.columns.clone();
        boolean result = true;
        if (permittedColumns != null) {
            i = unresolvedColumns.anySetBit();
            while (i >= 0) {
                if (permittedColumns.get(i)) {
                    unresolvedColumns.clear(i);
                }
                i = unresolvedColumns.anySetBit(i);
            }
        }
        if (unresolvedColumns.anySetBit() >= 0) {
            colsPermsDesc = dd.getColumnPermissions(this.tableUUID, this.privType, false, "PUBLIC");
            permittedColumns = colsPermsDesc.getColumns();
            if (permittedColumns != null) {
                i = unresolvedColumns.anySetBit();
                while (i >= 0) {
                    if (permittedColumns.get(i)) {
                        unresolvedColumns.clear(i);
                    }
                    i = unresolvedColumns.anySetBit(i);
                }
            }
            if (unresolvedColumns.anySetBit() >= 0) {
                result = false;
            }
        }
        return result;
    }

    private FormatableBitSet tryRole(LanguageConnectionContext lcc, DataDictionary dd, boolean forGrant, String r, FormatableBitSet unresolvedColumns) throws StandardException {
        FormatableBitSet permittedColumns = null;
        if (!forGrant) {
            permittedColumns = this.addPermittedColumns(dd, false, r, null);
        }
        permittedColumns = this.addPermittedColumns(dd, true, r, permittedColumns);
        int i = unresolvedColumns.anySetBit();
        while (i >= 0) {
            if (permittedColumns != null && permittedColumns.get(i)) {
                unresolvedColumns.clear(i);
            }
            i = unresolvedColumns.anySetBit(i);
        }
        return unresolvedColumns;
    }

    public String toString() {
        return "StatementColumnPermission: " + this.getPrivName() + " " + this.tableUUID + " columns: " + this.columns;
    }
}

